package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.MixnickChangeResponse;

/**
 * TOP API: taobao.mixnick.change request
 * 
 * @author top auto create
 * @since 1.0, 2015.03.03
 */
public class MixnickChangeRequest extends BaseTaobaoRequest<MixnickChangeResponse> {
	
	

	/** 
	* 输入的appkey
	 */
	private String srcAppkey;

	/** 
	* 输入的混淆nick
	 */
	private String srcMixNick;

	public void setSrcAppkey(String srcAppkey) {
		this.srcAppkey = srcAppkey;
	}

	public String getSrcAppkey() {
		return this.srcAppkey;
	}

	public void setSrcMixNick(String srcMixNick) {
		this.srcMixNick = srcMixNick;
	}

	public String getSrcMixNick() {
		return this.srcMixNick;
	}

	public String getApiMethodName() {
		return "taobao.mixnick.change";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("src_appkey", this.srcAppkey);
		txtParams.put("src_mix_nick", this.srcMixNick);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<MixnickChangeResponse> getResponseClass() {
		return MixnickChangeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(srcAppkey, "srcAppkey");
		RequestCheckUtils.checkNotEmpty(srcMixNick, "srcMixNick");
	}
	

}