package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.MixnickWetoplayResponse;

/**
 * TOP API: taobao.mixnick.wetoplay request
 * 
 * @author top auto create
 * @since 1.0, 2015.11.27
 */
public class MixnickWetoplayRequest extends BaseTaobaoRequest<MixnickWetoplayResponse> {
	
	

	/** 
	* 排查问题id
	 */
	private String traceId;

	/** 
	* 微淘混淆nick
	 */
	private String weMixnick;

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getTraceId() {
		return this.traceId;
	}

	public void setWeMixnick(String weMixnick) {
		this.weMixnick = weMixnick;
	}

	public String getWeMixnick() {
		return this.weMixnick;
	}

	public String getApiMethodName() {
		return "taobao.mixnick.wetoplay";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("trace_id", this.traceId);
		txtParams.put("we_mixnick", this.weMixnick);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<MixnickWetoplayResponse> getResponseClass() {
		return MixnickWetoplayResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}