package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.WeitaoFeedCancelResponse;

/**
 * TOP API: taobao.weitao.feed.cancel request
 * 
 * @author top auto create
 * @since 1.0, 2015.09.16
 */
public class WeitaoFeedCancelRequest extends BaseTaobaoRequest<WeitaoFeedCancelResponse> {
	
	

	/** 
	* 三方活动ID
	 */
	private String bizId;

	/** 
	* 是否彻底删除（店铺动态不可见，等同卖家广播后台删除），默认false
	 */
	private Boolean delete;

	/** 
	* 广播id
	 */
	private Long feedId;

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getBizId() {
		return this.bizId;
	}

	public void setDelete(Boolean delete) {
		this.delete = delete;
	}

	public Boolean getDelete() {
		return this.delete;
	}

	public void setFeedId(Long feedId) {
		this.feedId = feedId;
	}

	public Long getFeedId() {
		return this.feedId;
	}

	public String getApiMethodName() {
		return "taobao.weitao.feed.cancel";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_id", this.bizId);
		txtParams.put("delete", this.delete);
		txtParams.put("feed_id", this.feedId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WeitaoFeedCancelResponse> getResponseClass() {
		return WeitaoFeedCancelResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
		RequestCheckUtils.checkNotEmpty(feedId, "feedId");
	}
	

}