package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.WeitaoFeedIsrelationResponse;

/**
 * TOP API: taobao.weitao.feed.isrelation request
 * 
 * @author top auto create
 * @since 1.0, 2017.01.19
 */
public class WeitaoFeedIsrelationRequest extends BaseTaobaoRequest<WeitaoFeedIsrelationResponse> {
	
	

	/** 
	* 要查询的粉丝的淘宝昵称
	 */
	private String fansNick;

	/** 
	* 要查询的公共账号的淘宝昵称
	 */
	private String sellerNick;

	public void setFansNick(String fansNick) {
		this.fansNick = fansNick;
	}

	public String getFansNick() {
		return this.fansNick;
	}

	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}

	public String getApiMethodName() {
		return "taobao.weitao.feed.isrelation";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("fans_nick", this.fansNick);
		txtParams.put("seller_nick", this.sellerNick);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WeitaoFeedIsrelationResponse> getResponseClass() {
		return WeitaoFeedIsrelationResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(fansNick, "fansNick");
		RequestCheckUtils.checkNotEmpty(sellerNick, "sellerNick");
	}
	

}