package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.WeitaoFeedSynchronizeNewResponse;

/**
 * TOP API: taobao.weitao.feed.synchronize.new request
 * 
 * @author top auto create
 * @since 1.0, 2015.09.18
 */
public class WeitaoFeedSynchronizeNewRequest extends BaseTaobaoRequest<WeitaoFeedSynchronizeNewResponse> {
	
	

	/** 
	* feed点击跳转的活动地址
	 */
	private String detailUrl;

	/** 
	* feed展示结束时间
	 */
	private Long endTime;

	/** 
	* 广播类型：粉丝猜价格461、投票有礼462、粉丝抢红包463、盖楼有礼464、加购有礼465
	 */
	private Long feedType;

	/** 
	* 宝贝列表，用于card展示，0~2个宝贝ID
	 */
	private String itemIds;

	/** 
	* 活动ID
	 */
	private String sbizId;

	/** 
	* feed展示开始时间
	 */
	private Long startTime;

	/** 
	* feed描述
	 */
	private String summary;

	/** 
	* feed标题
	 */
	private String title;

	public void setDetailUrl(String detailUrl) {
		this.detailUrl = detailUrl;
	}

	public String getDetailUrl() {
		return this.detailUrl;
	}

	public void setEndTime(Long endTime) {
		this.endTime = endTime;
	}

	public Long getEndTime() {
		return this.endTime;
	}

	public void setFeedType(Long feedType) {
		this.feedType = feedType;
	}

	public Long getFeedType() {
		return this.feedType;
	}

	public void setItemIds(String itemIds) {
		this.itemIds = itemIds;
	}

	public String getItemIds() {
		return this.itemIds;
	}

	public void setSbizId(String sbizId) {
		this.sbizId = sbizId;
	}

	public String getSbizId() {
		return this.sbizId;
	}

	public void setStartTime(Long startTime) {
		this.startTime = startTime;
	}

	public Long getStartTime() {
		return this.startTime;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public String getSummary() {
		return this.summary;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTitle() {
		return this.title;
	}

	public String getApiMethodName() {
		return "taobao.weitao.feed.synchronize.new";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("detail_url", this.detailUrl);
		txtParams.put("end_time", this.endTime);
		txtParams.put("feed_type", this.feedType);
		txtParams.put("item_ids", this.itemIds);
		txtParams.put("sbiz_id", this.sbizId);
		txtParams.put("start_time", this.startTime);
		txtParams.put("summary", this.summary);
		txtParams.put("title", this.title);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WeitaoFeedSynchronizeNewResponse> getResponseClass() {
		return WeitaoFeedSynchronizeNewResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(detailUrl, "detailUrl");
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(feedType, "feedType");
		RequestCheckUtils.checkMaxListSize(itemIds, 20, "itemIds");
		RequestCheckUtils.checkNotEmpty(sbizId, "sbizId");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
		RequestCheckUtils.checkNotEmpty(summary, "summary");
		RequestCheckUtils.checkNotEmpty(title, "title");
	}
	

}