package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.WeitaoFeedSynchronizeResponse;

/**
 * TOP API: taobao.weitao.feed.synchronize request
 * 
 * @author top auto create
 * @since 1.0, 2015.07.30
 */
public class WeitaoFeedSynchronizeRequest extends BaseTaobaoRequest<WeitaoFeedSynchronizeResponse> {
	
	

	/** 
	* 活动id
	 */
	private Long bizId;

	/** 
	* feed封面图片url
	 */
	private String coverPath;

	/** 
	* feed点击跳转的活动地址
	 */
	private String detailUrl;

	/** 
	* feed展示结束时间
	 */
	private Long endTime;

	/** 
	* feed展示开始时间
	 */
	private Long startTime;

	/** 
	* feed描述
	 */
	private String summary;

	/** 
	* feed标题
	 */
	private String title;

	public void setBizId(Long bizId) {
		this.bizId = bizId;
	}

	public Long getBizId() {
		return this.bizId;
	}

	public void setCoverPath(String coverPath) {
		this.coverPath = coverPath;
	}

	public String getCoverPath() {
		return this.coverPath;
	}

	public void setDetailUrl(String detailUrl) {
		this.detailUrl = detailUrl;
	}

	public String getDetailUrl() {
		return this.detailUrl;
	}

	public void setEndTime(Long endTime) {
		this.endTime = endTime;
	}

	public Long getEndTime() {
		return this.endTime;
	}

	public void setStartTime(Long startTime) {
		this.startTime = startTime;
	}

	public Long getStartTime() {
		return this.startTime;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public String getSummary() {
		return this.summary;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTitle() {
		return this.title;
	}

	public String getApiMethodName() {
		return "taobao.weitao.feed.synchronize";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_id", this.bizId);
		txtParams.put("cover_path", this.coverPath);
		txtParams.put("detail_url", this.detailUrl);
		txtParams.put("end_time", this.endTime);
		txtParams.put("start_time", this.startTime);
		txtParams.put("summary", this.summary);
		txtParams.put("title", this.title);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WeitaoFeedSynchronizeResponse> getResponseClass() {
		return WeitaoFeedSynchronizeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
		RequestCheckUtils.checkNotEmpty(coverPath, "coverPath");
		RequestCheckUtils.checkNotEmpty(detailUrl, "detailUrl");
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
		RequestCheckUtils.checkNotEmpty(summary, "summary");
		RequestCheckUtils.checkNotEmpty(title, "title");
	}
	

}