package com.taobao.api.response;

import java.util.Date;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.marketing.lottery.draw.dodraw response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaMarketingLotteryDrawDodrawResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6192955174787945841L;

	/** 
	 * success
	 */
	@ApiField("is_success")
	private Boolean isSuccess;

	/** 
	 * 抽奖结果
	 */
	@ApiField("lottery_draw_result")
	private LotteryDrawResultDto lotteryDrawResult;

	/** 
	 * code
	 */
	@ApiField("msg_code")
	private Long msgCode;

	/** 
	 * msg
	 */
	@ApiField("msg_info")
	private String msgInfo;


	public void setIsSuccess(Boolean isSuccess) {
		this.isSuccess = isSuccess;
	}
	public Boolean getIsSuccess( ) {
		return this.isSuccess;
	}

	public void setLotteryDrawResult(LotteryDrawResultDto lotteryDrawResult) {
		this.lotteryDrawResult = lotteryDrawResult;
	}
	public LotteryDrawResultDto getLotteryDrawResult( ) {
		return this.lotteryDrawResult;
	}

	public void setMsgCode(Long msgCode) {
		this.msgCode = msgCode;
	}
	public Long getMsgCode( ) {
		return this.msgCode;
	}

	public void setMsgInfo(String msgInfo) {
		this.msgInfo = msgInfo;
	}
	public String getMsgInfo( ) {
		return this.msgInfo;
	}
	
	/**
 * 奖品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LotteryAwardDto extends TaobaoObject {

	private static final long serialVersionUID = 5762392564479213517L;

	/**
		 * 奖品详情url
		 */
		@ApiField("award_detail_url")
		private String awardDetailUrl;
		/**
		 * 奖品实例id
		 */
		@ApiField("award_inst_id")
		private String awardInstId;
		/**
		 * 奖品价值，分
		 */
		@ApiField("award_price")
		private Long awardPrice;
		/**
		 * 奖品类型
		 */
		@ApiField("award_type")
		private Long awardType;
		/**
		 * 奖品类型名称
		 */
		@ApiField("award_type_name")
		private String awardTypeName;
		/**
		 * 可用库存
		 */
		@ApiField("can_use_res_count")
		private String canUseResCount;
		/**
		 * 使用门槛文案
		 */
		@ApiField("condition")
		private String condition;
		/**
		 * 币种单位
		 */
		@ApiField("currency")
		private String currency;
		/**
		 * 币种符号
		 */
		@ApiField("currency_sign")
		private String currencySign;
		/**
		 * 展示名称
		 */
		@ApiField("display_name")
		private String displayName;
		/**
		 * 发放结束时间
		 */
		@ApiField("end_date")
		private Date endDate;
		/**
		 * 奖品id
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 抽奖活动id
		 */
		@ApiField("lottery_activity_id")
		private String lotteryActivityId;
		/**
		 * 卖家设置名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 奖品logo
		 */
		@ApiField("pict_url")
		private String pictUrl;
		/**
		 * 发放开始时间
		 */
		@ApiField("start_date")
		private Date startDate;
		/**
		 * 使用门槛，分
		 */
		@ApiField("start_fee")
		private Long startFee;
		/**
		 * 总库存
		 */
		@ApiField("total_res_count")
		private String totalResCount;
		/**
		 * 使用结束时间
		 */
		@ApiField("use_end_date")
		private Date useEndDate;
		/**
		 * 使用开始时间
		 */
		@ApiField("use_start_date")
		private Date useStartDate;
	

	public String getAwardDetailUrl() {
			return this.awardDetailUrl;
		}
		public void setAwardDetailUrl(String awardDetailUrl) {
			this.awardDetailUrl = awardDetailUrl;
		}
		public String getAwardInstId() {
			return this.awardInstId;
		}
		public void setAwardInstId(String awardInstId) {
			this.awardInstId = awardInstId;
		}
		public Long getAwardPrice() {
			return this.awardPrice;
		}
		public void setAwardPrice(Long awardPrice) {
			this.awardPrice = awardPrice;
		}
		public Long getAwardType() {
			return this.awardType;
		}
		public void setAwardType(Long awardType) {
			this.awardType = awardType;
		}
		public String getAwardTypeName() {
			return this.awardTypeName;
		}
		public void setAwardTypeName(String awardTypeName) {
			this.awardTypeName = awardTypeName;
		}
		public String getCanUseResCount() {
			return this.canUseResCount;
		}
		public void setCanUseResCount(String canUseResCount) {
			this.canUseResCount = canUseResCount;
		}
		public String getCondition() {
			return this.condition;
		}
		public void setCondition(String condition) {
			this.condition = condition;
		}
		public String getCurrency() {
			return this.currency;
		}
		public void setCurrency(String currency) {
			this.currency = currency;
		}
		public String getCurrencySign() {
			return this.currencySign;
		}
		public void setCurrencySign(String currencySign) {
			this.currencySign = currencySign;
		}
		public String getDisplayName() {
			return this.displayName;
		}
		public void setDisplayName(String displayName) {
			this.displayName = displayName;
		}
		public Date getEndDate() {
			return this.endDate;
		}
		public void setEndDate(Date endDate) {
			this.endDate = endDate;
		}
		public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public String getLotteryActivityId() {
			return this.lotteryActivityId;
		}
		public void setLotteryActivityId(String lotteryActivityId) {
			this.lotteryActivityId = lotteryActivityId;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getPictUrl() {
			return this.pictUrl;
		}
		public void setPictUrl(String pictUrl) {
			this.pictUrl = pictUrl;
		}
		public Date getStartDate() {
			return this.startDate;
		}
		public void setStartDate(Date startDate) {
			this.startDate = startDate;
		}
		public Long getStartFee() {
			return this.startFee;
		}
		public void setStartFee(Long startFee) {
			this.startFee = startFee;
		}
		public String getTotalResCount() {
			return this.totalResCount;
		}
		public void setTotalResCount(String totalResCount) {
			this.totalResCount = totalResCount;
		}
		public Date getUseEndDate() {
			return this.useEndDate;
		}
		public void setUseEndDate(Date useEndDate) {
			this.useEndDate = useEndDate;
		}
		public Date getUseStartDate() {
			return this.useStartDate;
		}
		public void setUseStartDate(Date useStartDate) {
			this.useStartDate = useStartDate;
		}

}

	/**
 * 抽奖结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LotteryDrawResultDto extends TaobaoObject {

	private static final long serialVersionUID = 8433483541649265765L;

	/**
		 * 奖品信息
		 */
		@ApiField("award")
		private LotteryAwardDto award;
		/**
		 * 结果信息
		 */
		@ApiField("result_msg")
		private String resultMsg;
		/**
		 * 结果类型（1z中奖2奖品已发完3限流5未中奖）
		 */
		@ApiField("result_type")
		private Long resultType;
		/**
		 * 店铺logo
		 */
		@ApiField("shop_logo")
		private String shopLogo;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_title")
		private String shopTitle;
		/**
		 * 展示模板
		 */
		@ApiField("template")
		private String template;
	

	public LotteryAwardDto getAward() {
			return this.award;
		}
		public void setAward(LotteryAwardDto award) {
			this.award = award;
		}
		public String getResultMsg() {
			return this.resultMsg;
		}
		public void setResultMsg(String resultMsg) {
			this.resultMsg = resultMsg;
		}
		public Long getResultType() {
			return this.resultType;
		}
		public void setResultType(Long resultType) {
			this.resultType = resultType;
		}
		public String getShopLogo() {
			return this.shopLogo;
		}
		public void setShopLogo(String shopLogo) {
			this.shopLogo = shopLogo;
		}
		public String getShopTitle() {
			return this.shopTitle;
		}
		public void setShopTitle(String shopTitle) {
			this.shopTitle = shopTitle;
		}
		public String getTemplate() {
			return this.template;
		}
		public void setTemplate(String template) {
			this.template = template;
		}

}



}
