/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.AdcreativesRelatedCapabilityGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AdcreativesRelatedCapabilityApi {
    private ApiClient apiClient;

    public AdcreativesRelatedCapabilityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdcreativesRelatedCapabilityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call adcreativesRelatedCapabilityGetCall(Long accountId, Long adId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/adcreatives_related_capability/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (adId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ad_id", adId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call adcreativesRelatedCapabilityGetValidateBeforeCall(Long accountId, Long adId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling adcreativesRelatedCapabilityGet(Async)");
        }
        if (adId == null) {
            throw new ApiException("Missing the required parameter 'adId' when calling adcreativesRelatedCapabilityGet(Async)");
        }
        Call call = this.adcreativesRelatedCapabilityGetCall(accountId, adId, fields, progressListener, progressRequestListener);
        return call;
    }

    public AdcreativesRelatedCapabilityGetResponse adcreativesRelatedCapabilityGet(Long accountId, Long adId, List<String> fields) throws ApiException {
        ApiResponse<AdcreativesRelatedCapabilityGetResponse> resp = this.adcreativesRelatedCapabilityGetWithHttpInfo(accountId, adId, fields);
        return resp.getData();
    }

    public ApiResponse<AdcreativesRelatedCapabilityGetResponse> adcreativesRelatedCapabilityGetWithHttpInfo(Long accountId, Long adId, List<String> fields) throws ApiException {
        Call call = this.adcreativesRelatedCapabilityGetValidateBeforeCall(accountId, adId, fields, null, null);
        Type localVarReturnType = new TypeToken<AdcreativesRelatedCapabilityGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call adcreativesRelatedCapabilityGetAsync(Long accountId, Long adId, List<String> fields, final ApiCallback<AdcreativesRelatedCapabilityGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.adcreativesRelatedCapabilityGetValidateBeforeCall(accountId, adId, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AdcreativesRelatedCapabilityGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

