/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AsyncReportFilesApi {
    private ApiClient apiClient;

    public AsyncReportFilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AsyncReportFilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call asyncReportFilesGetCall(Long accountId, Long taskId, Long fileId, Boolean weixinOfficialAccountsUpgradeEnabled, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/async_report_files/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (taskId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("task_id", taskId));
        }
        if (fileId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("file_id", fileId));
        }
        if (weixinOfficialAccountsUpgradeEnabled != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("weixin_official_accounts_upgrade_enabled", weixinOfficialAccountsUpgradeEnabled));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call asyncReportFilesGetValidateBeforeCall(Long accountId, Long taskId, Long fileId, Boolean weixinOfficialAccountsUpgradeEnabled, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling asyncReportFilesGet(Async)");
        }
        if (taskId == null) {
            throw new ApiException("Missing the required parameter 'taskId' when calling asyncReportFilesGet(Async)");
        }
        if (fileId == null) {
            throw new ApiException("Missing the required parameter 'fileId' when calling asyncReportFilesGet(Async)");
        }
        Call call = this.asyncReportFilesGetCall(accountId, taskId, fileId, weixinOfficialAccountsUpgradeEnabled, fields, progressListener, progressRequestListener);
        return call;
    }

    public String asyncReportFilesGet(Long accountId, Long taskId, Long fileId, Boolean weixinOfficialAccountsUpgradeEnabled, List<String> fields) throws ApiException {
        ApiResponse<String> resp = this.asyncReportFilesGetWithHttpInfo(accountId, taskId, fileId, weixinOfficialAccountsUpgradeEnabled, fields);
        return resp.getData();
    }

    public ApiResponse<String> asyncReportFilesGetWithHttpInfo(Long accountId, Long taskId, Long fileId, Boolean weixinOfficialAccountsUpgradeEnabled, List<String> fields) throws ApiException {
        Call call = this.asyncReportFilesGetValidateBeforeCall(accountId, taskId, fileId, weixinOfficialAccountsUpgradeEnabled, fields, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call asyncReportFilesGetAsync(Long accountId, Long taskId, Long fileId, Boolean weixinOfficialAccountsUpgradeEnabled, List<String> fields, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.asyncReportFilesGetValidateBeforeCall(accountId, taskId, fileId, weixinOfficialAccountsUpgradeEnabled, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

