/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.PropertyFilesAddResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class PropertyFilesApi {
    private ApiClient apiClient;

    public PropertyFilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PropertyFilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call propertyFilesAddCall(Long accountId, Long propertySetId, Long sessionId, String fileName, File file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/property_files/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (propertySetId != null) {
            localVarFormParams.put("property_set_id", propertySetId);
        }
        if (sessionId != null) {
            localVarFormParams.put("session_id", sessionId);
        }
        if (fileName != null) {
            localVarFormParams.put("file_name", fileName);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call propertyFilesAddValidateBeforeCall(Long accountId, Long propertySetId, Long sessionId, String fileName, File file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling propertyFilesAdd(Async)");
        }
        if (propertySetId == null) {
            throw new ApiException("Missing the required parameter 'propertySetId' when calling propertyFilesAdd(Async)");
        }
        if (sessionId == null) {
            throw new ApiException("Missing the required parameter 'sessionId' when calling propertyFilesAdd(Async)");
        }
        if (fileName == null) {
            throw new ApiException("Missing the required parameter 'fileName' when calling propertyFilesAdd(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling propertyFilesAdd(Async)");
        }
        Call call = this.propertyFilesAddCall(accountId, propertySetId, sessionId, fileName, file, progressListener, progressRequestListener);
        return call;
    }

    public PropertyFilesAddResponse propertyFilesAdd(Long accountId, Long propertySetId, Long sessionId, String fileName, File file) throws ApiException {
        ApiResponse<PropertyFilesAddResponse> resp = this.propertyFilesAddWithHttpInfo(accountId, propertySetId, sessionId, fileName, file);
        return resp.getData();
    }

    public ApiResponse<PropertyFilesAddResponse> propertyFilesAddWithHttpInfo(Long accountId, Long propertySetId, Long sessionId, String fileName, File file) throws ApiException {
        Call call = this.propertyFilesAddValidateBeforeCall(accountId, propertySetId, sessionId, fileName, file, null, null);
        Type localVarReturnType = new TypeToken<PropertyFilesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call propertyFilesAddAsync(Long accountId, Long propertySetId, Long sessionId, String fileName, File file, final ApiCallback<PropertyFilesAddResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.propertyFilesAddValidateBeforeCall(accountId, propertySetId, sessionId, fileName, file, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PropertyFilesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

