/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiContainer;
import com.tencent.ads.ApiException;
import com.tencent.ads.Configuration;
import com.tencent.ads.container.AdcreativesApiContainer;
import com.tencent.ads.container.AdgroupsApiContainer;
import com.tencent.ads.container.AdsApiContainer;
import com.tencent.ads.container.BatchRequestsApiContainer;
import com.tencent.ads.container.CampaignsApiContainer;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.model.AdStatus;
import com.tencent.ads.model.AdcreativesAddRequest;
import com.tencent.ads.model.AdcreativesAddResponse;
import com.tencent.ads.model.AdcreativesAddResponseData;
import com.tencent.ads.model.AdcreativesDeleteRequest;
import com.tencent.ads.model.AdcreativesGetResponseData;
import com.tencent.ads.model.AdgroupsAddRequest;
import com.tencent.ads.model.AdgroupsAddResponse;
import com.tencent.ads.model.AdgroupsAddResponseData;
import com.tencent.ads.model.AdgroupsDeleteRequest;
import com.tencent.ads.model.AdgroupsGetResponseData;
import com.tencent.ads.model.AdgroupsUpdateRequest;
import com.tencent.ads.model.AdgroupsUpdateResponse;
import com.tencent.ads.model.AdsAddRequest;
import com.tencent.ads.model.AdsAddResponseData;
import com.tencent.ads.model.AdsDeleteRequest;
import com.tencent.ads.model.AdsGetResponseData;
import com.tencent.ads.model.AdsUpdateRequest;
import com.tencent.ads.model.AdsUpdateResponse;
import com.tencent.ads.model.BatchRequestSpecStruct;
import com.tencent.ads.model.BatchRequestsAddListStruct;
import com.tencent.ads.model.BatchRequestsAddRequest;
import com.tencent.ads.model.BatchRequestsAddResponseData;
import com.tencent.ads.model.CampaignsAddRequest;
import com.tencent.ads.model.CampaignsAddResponseData;
import com.tencent.ads.model.CampaignsDeleteRequest;
import com.tencent.ads.model.CampaignsUpdateRequest;
import com.tencent.ads.model.CampaignsUpdateResponse;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.utils.BasicNameValuePair;
import com.tencent.ads.utils.NameValuePair;
import com.tencent.ads.utils.URLEncode;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RapidAdsContainer
extends ApiContainer {
    @Inject
    CampaignsApiContainer campaignsApi;
    @Inject
    AdgroupsApiContainer adgroupsApi;
    @Inject
    AdcreativesApiContainer adcreativesApi;
    @Inject
    AdsApiContainer adApi;
    @Inject
    BatchRequestsApiContainer batchRequestsApi;
    private final ApiClient apiClient = Configuration.getDefaultApiClient();
    private final int ATTEMPT_TIMES = 2;
    private final ThreadLocal<Exception> lastException = new ThreadLocal();

    public RapidAddAdsResponseData rapidAddAds(RapidAddAdsRequestData rapidAddAdsRequest) throws TencentAdsResponseException {
        Long accountId = null;
        Long campaignId = null;
        Long adgroupId = null;
        Long adcreativeId = null;
        Long adId = null;
        RapidAddAdsResponseData rapidAddAdsResponse = new RapidAddAdsResponseData();
        if (rapidAddAdsRequest.campaignsAddRequest.getAccountId() != null) {
            accountId = rapidAddAdsRequest.campaignsAddRequest.getAccountId();
        }
        if (rapidAddAdsRequest.adgroupsAddRequest.getAccountId() != null && accountId != null) {
            if (!accountId.equals(rapidAddAdsRequest.adgroupsAddRequest.getAccountId())) {
                throw new TencentAdsResponseException("Account id not consistent!");
            }
            accountId = rapidAddAdsRequest.adgroupsAddRequest.getAccountId();
        }
        if (rapidAddAdsRequest.adcreativesAddRequest.getAccountId() != null && accountId != null) {
            if (!accountId.equals(rapidAddAdsRequest.adcreativesAddRequest.getAccountId())) {
                throw new TencentAdsResponseException("Account id not consistent!");
            }
            accountId = rapidAddAdsRequest.adcreativesAddRequest.getAccountId();
        }
        if (rapidAddAdsRequest.adAddRequest.getAccountId() != null && accountId != null) {
            if (!accountId.equals(rapidAddAdsRequest.adAddRequest.getAccountId())) {
                throw new TencentAdsResponseException("Account id not consistent!");
            }
            accountId = rapidAddAdsRequest.adAddRequest.getAccountId();
        }
        AdStatus campaignStatus = rapidAddAdsRequest.campaignsAddRequest.getConfiguredStatus();
        rapidAddAdsRequest.campaignsAddRequest.setAccountId(accountId);
        rapidAddAdsRequest.campaignsAddRequest.setConfiguredStatus(AdStatus.SUSPEND);
        for (int i = 0; i < 2; ++i) {
            try {
                rapidAddAdsResponse.campaignsAddResponseData = this.campaignsApi.campaignsAdd(rapidAddAdsRequest.campaignsAddRequest);
                campaignId = rapidAddAdsResponse.campaignsAddResponseData.getCampaignId();
                break;
            }
            catch (ApiException | TencentAdsResponseException exception) {
                if (i != 1) continue;
                exception.printStackTrace();
                throw new TencentAdsResponseException(exception.getMessage());
            }
        }
        AdStatus adgroupStatus = rapidAddAdsRequest.adgroupsAddRequest.getConfiguredStatus();
        rapidAddAdsRequest.adgroupsAddRequest.setAccountId(accountId);
        rapidAddAdsRequest.adgroupsAddRequest.setCampaignId(campaignId);
        rapidAddAdsRequest.adgroupsAddRequest.setConfiguredStatus(AdStatus.SUSPEND);
        rapidAddAdsRequest.adcreativesAddRequest.setAccountId(accountId);
        rapidAddAdsRequest.adcreativesAddRequest.setCampaignId(campaignId);
        try {
            BatchAddResult batchAddResult = this.batchAdd(accountId, campaignId, rapidAddAdsRequest, rapidAddAdsResponse);
            adgroupId = batchAddResult.adgroupId;
            adcreativeId = batchAddResult.adcreativeId;
        }
        catch (TencentAdsResponseException exception) {
            adgroupId = this.getFailedAdgroup(accountId, campaignId);
            if (adgroupId != null) {
                this.deleteAdgroup(accountId, adgroupId);
            }
            if ((adcreativeId = this.getFailedAdcreative(accountId, campaignId)) != null) {
                this.deleteAdcreative(accountId, adcreativeId);
            }
            this.deleteCampaign(accountId, campaignId);
            throw new TencentAdsResponseException(this.lastException.get().getMessage());
        }
        AdStatus adStatus = rapidAddAdsRequest.adAddRequest.getConfiguredStatus();
        rapidAddAdsRequest.adAddRequest.setAccountId(accountId);
        rapidAddAdsRequest.adAddRequest.setAdgroupId(adgroupId);
        rapidAddAdsRequest.adAddRequest.setAdcreativeId(adcreativeId);
        rapidAddAdsRequest.adAddRequest.setConfiguredStatus(AdStatus.SUSPEND);
        for (int i = 0; i < 2; ++i) {
            try {
                rapidAddAdsResponse.adsAddResponseData = this.adApi.adsAdd(rapidAddAdsRequest.adAddRequest);
                adId = rapidAddAdsResponse.adsAddResponseData.getAdId();
                break;
            }
            catch (Exception exception) {
                if (exception instanceof ApiException && (adId = this.getFailedAd(accountId, campaignId)) != null) {
                    rapidAddAdsResponse.adsAddResponseData = new AdsAddResponseData().adId(adId);
                    break;
                }
                if (i != 1) continue;
                exception.printStackTrace();
                this.deleteAdgroup(accountId, adgroupId);
                this.deleteAdcreative(accountId, adcreativeId);
                this.deleteCampaign(accountId, campaignId);
                throw new TencentAdsResponseException(exception.getMessage());
            }
        }
        try {
            this.batchUpdate(accountId, campaignId, adgroupId, adId, campaignStatus, adgroupStatus, adStatus);
        }
        catch (TencentAdsResponseException exception) {
            this.deleteAds(accountId, adId);
            this.deleteAdgroup(accountId, adgroupId);
            this.deleteAdcreative(accountId, adcreativeId);
            this.deleteCampaign(accountId, campaignId);
            throw new TencentAdsResponseException(exception.getMessage());
        }
        return rapidAddAdsResponse;
    }

    protected String buildFormData(String json) {
        JsonParser jsonParser = new JsonParser();
        JsonElement root = jsonParser.parse(json);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addNameValuePair(params, root, "");
        return URLEncode.format(params, StandardCharsets.UTF_8);
    }

    protected void addNameValuePair(List<NameValuePair> params, JsonElement element, String prefix) {
        block3: {
            block4: {
                block2: {
                    if (!element.isJsonArray()) break block2;
                    int index = 0;
                    for (JsonElement listElement : element.getAsJsonArray()) {
                        this.addNameValuePair(params, listElement, prefix + "[" + index + "]");
                        ++index;
                    }
                    break block3;
                }
                if (!element.isJsonPrimitive()) break block4;
                params.add(new BasicNameValuePair(prefix, element.getAsString()));
                break block3;
            }
            if (!element.isJsonObject()) break block3;
            for (String key : element.getAsJsonObject().keySet()) {
                JsonElement value = element.getAsJsonObject().get(key);
                String temp = prefix;
                temp = temp.equals("") ? key : temp + "[" + key + "]";
                this.addNameValuePair(params, value, temp);
            }
        }
    }

    protected void batchUpdate(Long accountId, Long campaignId, Long adgroupId, Long adId, AdStatus campaignStatus, AdStatus adgroupStatus, AdStatus adStatus) throws TencentAdsResponseException {
        String version = "v1.1";
        BatchRequestsAddRequest batchRequestsAddRequest = new BatchRequestsAddRequest();
        ArrayList<Class> requestClasses = new ArrayList<Class>(Arrays.asList(CampaignsUpdateRequest.class, AdgroupsUpdateRequest.class, AdsUpdateRequest.class));
        ArrayList<Class> responseClasses = new ArrayList<Class>(Arrays.asList(CampaignsUpdateResponse.class, AdgroupsUpdateResponse.class, AdsUpdateResponse.class));
        ArrayList<BatchRequestSpecStruct> batchRequestSpecs = new ArrayList<BatchRequestSpecStruct>();
        CampaignsUpdateRequest campaignsUpdateRequest = this.buildCampaignUpdateRequest(accountId, campaignId, campaignStatus);
        String campaignUpdateFormData = this.buildFormData(campaignsUpdateRequest.toString());
        batchRequestSpecs.add(new BatchRequestSpecStruct().relativePath(version + "/campaigns/update").body(campaignUpdateFormData));
        AdgroupsUpdateRequest adgroupsUpdateRequest = this.buildAdgroupUpdateRequest(accountId, adgroupId, adgroupStatus);
        String adgroupUpdateFormData = this.buildFormData(adgroupsUpdateRequest.toString());
        batchRequestSpecs.add(new BatchRequestSpecStruct().relativePath(version + "/adgroups/update").body(adgroupUpdateFormData));
        AdsUpdateRequest adsUpdateRequest = this.buildAdsUpdateRequest(accountId, adId, adStatus);
        String adUpdateFormData = this.buildFormData(adsUpdateRequest.toString());
        batchRequestSpecs.add(new BatchRequestSpecStruct().relativePath(version + "/ads/update").body(adUpdateFormData));
        batchRequestsAddRequest.setBatchRequestSpec(batchRequestSpecs);
        for (int attemptTime = 0; attemptTime < 2; ++attemptTime) {
            try {
                BatchRequestsAddResponseData batchRequestsAddResponse = this.batchRequestsApi.batchRequestsAdd(batchRequestsAddRequest);
                ArrayList requestClassesCopy = new ArrayList();
                for (int i = 0; i < requestClasses.size(); ++i) {
                    requestClassesCopy.add(null);
                }
                Collections.copy(requestClassesCopy, requestClasses);
                ArrayList batchRequestSpecCopy = new ArrayList();
                for (int i = 0; i < batchRequestSpecs.size(); ++i) {
                    batchRequestSpecCopy.add(null);
                }
                Collections.copy(batchRequestSpecCopy, batchRequestSpecs);
                for (int classIndex = 0; classIndex < requestClassesCopy.size(); ++classIndex) {
                    Class responseClass = (Class)responseClasses.get(classIndex);
                    BatchRequestsAddListStruct response = batchRequestsAddResponse.getList().get(classIndex);
                    Object result = this.parseResponse(response.getBody(), responseClass);
                    if (result == null) continue;
                    requestClasses.remove(requestClassesCopy.get(classIndex));
                    responseClasses.remove(requestClassesCopy.get(classIndex));
                    batchRequestSpecs.remove(batchRequestSpecCopy.get(classIndex));
                }
                if (requestClasses.size() != 0) continue;
                return;
            }
            catch (ApiException | TencentAdsResponseException exception) {
                if (attemptTime != 1) continue;
                exception.printStackTrace();
                throw new TencentAdsResponseException(exception.getMessage());
            }
        }
        throw new TencentAdsResponseException(this.lastException.get().getMessage());
    }

    protected BatchAddResult batchAdd(Long accountId, Long campaignId, RapidAddAdsRequestData rapidAddAdsRequest, RapidAddAdsResponseData rapidAddAdsResponse) throws TencentAdsResponseException {
        String version = "v1.1";
        BatchAddResult batchAddResult = new BatchAddResult();
        BatchRequestsAddRequest batchRequestsAddRequest = new BatchRequestsAddRequest();
        for (int i = 0; i < 2; ++i) {
            boolean needAdcreative;
            ArrayList<BatchRequestSpecStruct> batchRequestSpecs = new ArrayList<BatchRequestSpecStruct>();
            boolean needAdgroup = batchAddResult.adgroupId == null;
            boolean bl = needAdcreative = batchAddResult.adcreativeId == null;
            if (needAdgroup) {
                String adgroupAddFormData = this.buildFormData(rapidAddAdsRequest.adgroupsAddRequest.toString());
                batchRequestSpecs.add(new BatchRequestSpecStruct().relativePath(version + "/adgroups/add").body(adgroupAddFormData));
            }
            if (needAdcreative) {
                String adcreativeAddFormData = this.buildFormData(rapidAddAdsRequest.adcreativesAddRequest.toString());
                batchRequestSpecs.add(new BatchRequestSpecStruct().relativePath(version + "/adcreatives/add").body(adcreativeAddFormData));
            }
            batchRequestsAddRequest.setBatchRequestSpec(batchRequestSpecs);
            try {
                BatchRequestsAddResponseData batchRequestsAddResponse = this.batchRequestsApi.batchRequestsAdd(batchRequestsAddRequest);
                BatchRequestsAddListStruct adgroupsApiResponse = null;
                BatchRequestsAddListStruct adcreativeApiResponse = null;
                if (needAdgroup && needAdcreative) {
                    adgroupsApiResponse = batchRequestsAddResponse.getList().get(0);
                    adcreativeApiResponse = batchRequestsAddResponse.getList().get(1);
                } else if (needAdgroup) {
                    adgroupsApiResponse = batchRequestsAddResponse.getList().get(0);
                } else if (needAdcreative) {
                    adcreativeApiResponse = batchRequestsAddResponse.getList().get(0);
                }
                if (needAdgroup) {
                    AdgroupsAddResponse adgroupsAddResponse = (AdgroupsAddResponse)this.parseResponse(adgroupsApiResponse.getBody(), (Type)((Object)AdgroupsAddResponse.class));
                    if (adgroupsAddResponse != null) {
                        rapidAddAdsResponse.adgroupsAddResponseData = adgroupsAddResponse.getData();
                        batchAddResult.adgroupId = adgroupsAddResponse.getData().getAdgroupId();
                    } else if (this.lastException.get() instanceof ApiException) {
                        batchAddResult.adgroupId = this.getFailedAdgroup(accountId, campaignId);
                    }
                }
                if (needAdcreative) {
                    AdcreativesAddResponse adcreativesAddResponse = (AdcreativesAddResponse)this.parseResponse(adcreativeApiResponse.getBody(), (Type)((Object)AdcreativesAddResponse.class));
                    if (adcreativesAddResponse != null) {
                        rapidAddAdsResponse.adcreativesAddResponseData = adcreativesAddResponse.getData();
                        batchAddResult.adcreativeId = adcreativesAddResponse.getData().getAdcreativeId();
                    } else if (this.lastException.get() instanceof ApiException) {
                        batchAddResult.adcreativeId = this.getFailedAdcreative(accountId, campaignId);
                    }
                }
                if (batchAddResult.adgroupId == null || batchAddResult.adcreativeId == null) continue;
                return batchAddResult;
            }
            catch (ApiException | TencentAdsResponseException exception) {
                if (i != 1) continue;
                exception.printStackTrace();
                throw new TencentAdsResponseException(exception.getMessage());
            }
        }
        throw new TencentAdsResponseException(this.lastException.get().getMessage());
    }

    protected <T> T parseResponse(String body, Type type) {
        try {
            String url = "http://ignored";
            Request request = new Request.Builder().url(url).build();
            ResponseBody responseBody = ResponseBody.create((MediaType)MediaType.parse((String)"text"), (String)body);
            Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(200).body(responseBody).build();
            Object addResponse = this.apiClient.handleResponse(response, type);
            this.handleResponse(this.gson.toJson(addResponse));
            return addResponse;
        }
        catch (ApiException | TencentAdsResponseException exception) {
            exception.printStackTrace();
            this.lastException.set(exception);
            return null;
        }
    }

    protected Long getFailedAdgroup(Long accountId, Long campaignId) {
        Long adgroupId = null;
        List<FilteringStruct> filtering = Collections.singletonList(new FilteringStruct().field("campaign_id").operator("EQUALS").values(Collections.singletonList(String.valueOf(campaignId))));
        List<String> fields = Collections.singletonList("adgroup_id");
        for (int i = 0; i < 2; ++i) {
            try {
                AdgroupsGetResponseData adgroupsGetResponse = this.adgroupsApi.adgroupsGet(accountId, filtering, null, null, null, null, fields);
                if (adgroupsGetResponse.getList() == null || adgroupsGetResponse.getList().size() != 1) break;
                adgroupId = adgroupsGetResponse.getList().get(0).getAdgroupId();
                break;
            }
            catch (ApiException | TencentAdsResponseException e) {
                if (i != 1) continue;
                e.printStackTrace();
                continue;
            }
        }
        return adgroupId;
    }

    protected Long getFailedAdcreative(Long accountId, Long campaignId) {
        Long adcreativeId = null;
        List<FilteringStruct> filtering = Collections.singletonList(new FilteringStruct().field("campaign_id").operator("EQUALS").values(Collections.singletonList(String.valueOf(campaignId))));
        List<String> fields = Collections.singletonList("adcreative_id");
        for (int i = 0; i < 2; ++i) {
            try {
                AdcreativesGetResponseData adcreativesGetResponseData = this.adcreativesApi.adcreativesGet(accountId, filtering, null, null, null, null, null, fields);
                if (adcreativesGetResponseData.getList() == null || adcreativesGetResponseData.getList().size() != 1) break;
                adcreativeId = adcreativesGetResponseData.getList().get(0).getAdcreativeId();
                break;
            }
            catch (ApiException | TencentAdsResponseException e) {
                if (i != 1) continue;
                e.printStackTrace();
                continue;
            }
        }
        return adcreativeId;
    }

    protected Long getFailedAd(Long accountId, Long campaignId) {
        Long adId = null;
        List<FilteringStruct> filtering = Collections.singletonList(new FilteringStruct().field("campaign_id").operator("EQUALS").values(Collections.singletonList(String.valueOf(campaignId))));
        List<String> fields = Collections.singletonList("ad_id");
        for (int i = 0; i < 2; ++i) {
            try {
                AdsGetResponseData adsGetResponseData = this.adApi.adsGet(accountId, filtering, null, null, null, null, fields);
                if (adsGetResponseData.getList() == null || adsGetResponseData.getList().size() != 1) break;
                adId = adsGetResponseData.getList().get(0).getAdId();
                break;
            }
            catch (ApiException | TencentAdsResponseException e) {
                if (i != 1) continue;
                e.printStackTrace();
                continue;
            }
        }
        return adId;
    }

    protected CampaignsUpdateRequest buildCampaignUpdateRequest(Long accountId, Long campaignId, AdStatus status) {
        CampaignsUpdateRequest campaignsUpdateRequest = new CampaignsUpdateRequest().accountId(accountId).campaignId(campaignId);
        if (status == null) {
            status = AdStatus.NORMAL;
        }
        campaignsUpdateRequest.setConfiguredStatus(status);
        return campaignsUpdateRequest;
    }

    protected AdgroupsUpdateRequest buildAdgroupUpdateRequest(Long accountId, Long adgroupId, AdStatus status) {
        AdgroupsUpdateRequest adgroupsUpdateRequest = new AdgroupsUpdateRequest().accountId(accountId).adgroupId(adgroupId);
        if (status == null) {
            status = AdStatus.NORMAL;
        }
        adgroupsUpdateRequest.setConfiguredStatus(status);
        return adgroupsUpdateRequest;
    }

    protected AdsUpdateRequest buildAdsUpdateRequest(Long accountId, Long adId, AdStatus status) {
        if (status == null) {
            status = AdStatus.NORMAL;
        }
        AdsUpdateRequest adsUpdateRequest = new AdsUpdateRequest().accountId(accountId).adId(adId);
        adsUpdateRequest.setConfiguredStatus(status);
        return adsUpdateRequest;
    }

    protected void deleteAds(Long accoungId, Long adId) {
        AdsDeleteRequest adsDeleteRequest = new AdsDeleteRequest().accountId(accoungId).adId(adId);
        for (int i = 0; i < 2; ++i) {
            try {
                this.adApi.adsDelete(adsDeleteRequest);
                break;
            }
            catch (ApiException | TencentAdsResponseException exception) {
                exception.printStackTrace();
                continue;
            }
        }
    }

    protected void deleteAdgroup(Long accountId, Long adgroupId) {
        AdgroupsDeleteRequest adgroupsDeleteRequest = new AdgroupsDeleteRequest().accountId(accountId).adgroupId(adgroupId);
        for (int i = 0; i < 2; ++i) {
            try {
                this.adgroupsApi.adgroupsDelete(adgroupsDeleteRequest);
                break;
            }
            catch (ApiException | TencentAdsResponseException exception) {
                exception.printStackTrace();
                continue;
            }
        }
    }

    protected void deleteCampaign(Long accountId, Long campaignId) {
        CampaignsDeleteRequest campaignsDeleteRequest = new CampaignsDeleteRequest().accountId(accountId).campaignId(campaignId);
        for (int i = 0; i < 2; ++i) {
            try {
                this.campaignsApi.campaignsDelete(campaignsDeleteRequest);
                break;
            }
            catch (ApiException | TencentAdsResponseException exception) {
                exception.printStackTrace();
                continue;
            }
        }
    }

    protected void deleteAdcreative(Long accountId, Long adcreativeId) {
        AdcreativesDeleteRequest adcreativesDeleteRequest = new AdcreativesDeleteRequest().accountId(accountId).adcreativeId(adcreativeId);
        for (int i = 0; i < 2; ++i) {
            try {
                this.adcreativesApi.adcreativesDelete(adcreativesDeleteRequest);
                break;
            }
            catch (ApiException | TencentAdsResponseException exception) {
                exception.printStackTrace();
                continue;
            }
        }
    }

    public static class RapidAddAdsResponseData {
        public CampaignsAddResponseData campaignsAddResponseData;
        public AdgroupsAddResponseData adgroupsAddResponseData;
        public AdcreativesAddResponseData adcreativesAddResponseData;
        public AdsAddResponseData adsAddResponseData;
    }

    public static class RapidAddAdsRequestData {
        public CampaignsAddRequest campaignsAddRequest;
        public AdgroupsAddRequest adgroupsAddRequest;
        public AdcreativesAddRequest adcreativesAddRequest;
        public AdsAddRequest adAddRequest;

        public RapidAddAdsRequestData() {
        }

        public RapidAddAdsRequestData(CampaignsAddRequest campaignsAddRequest, AdgroupsAddRequest adgroupsAddRequest, AdcreativesAddRequest adcreativesAddRequest, AdsAddRequest adAddRequest) {
            this.campaignsAddRequest = campaignsAddRequest;
            this.adgroupsAddRequest = adgroupsAddRequest;
            this.adcreativesAddRequest = adcreativesAddRequest;
            this.adAddRequest = adAddRequest;
        }
    }

    class BatchAddResult {
        Long adgroupId;
        Long adcreativeId;

        BatchAddResult() {
        }
    }
}

