/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.SM3MessageDigest;
import com.tencent.kona.crypto.spec.SM2KeyAgreementParamSpec;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.crypto.util.Constants;
import com.tencent.kona.sun.security.ec.ECOperations;
import com.tencent.kona.sun.security.ec.point.MutablePoint;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class SM2KeyAgreement
extends KeyAgreementSpi {
    private SM2KeyAgreementParamSpec paramSpec;
    private ECPrivateKey ephemeralPrivateKey;
    private ECPublicKey peerEphemeralPublicKey;
    private final MessageDigest sm3MD = new SM3MessageDigest();
    private static final BigInteger TWO_POW_W = BigInteger.ONE.shiftLeft(SM2KeyAgreement.w());
    private static final BigInteger TWO_POW_W_SUB_ONE = TWO_POW_W.subtract(BigInteger.ONE);
    private static final byte[] A = CryptoUtils.intToBytes32(SM2ParameterSpec.CURVE.getA());
    private static final byte[] B = CryptoUtils.intToBytes32(SM2ParameterSpec.CURVE.getB());
    private static final byte[] GEN_X = CryptoUtils.intToBytes32(SM2ParameterSpec.GENERATOR.getAffineX());
    private static final byte[] GEN_Y = CryptoUtils.intToBytes32(SM2ParameterSpec.GENERATOR.getAffineY());

    @Override
    protected void engineInit(Key key, SecureRandom random) {
        throw new UnsupportedOperationException("Use init(Key, AlgorithmParameterSpec, SecureRandom) instead");
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Only accept ECPrivateKey");
        }
        if (!(params instanceof SM2KeyAgreementParamSpec)) {
            throw new InvalidAlgorithmParameterException("Only accept SM2KeyAgreementParamSpec");
        }
        this.paramSpec = (SM2KeyAgreementParamSpec)params;
        this.ephemeralPrivateKey = (ECPrivateKey)key;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.ephemeralPrivateKey == null || this.paramSpec == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.peerEphemeralPublicKey != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Only accept ECPublicKey");
        }
        this.peerEphemeralPublicKey = (ECPublicKey)key;
        return null;
    }

    private static int w() {
        return (int)Math.ceil((double)SM2ParameterSpec.ORDER.subtract(BigInteger.ONE).bitLength() / 2.0) - 1;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        BigInteger rA = this.ephemeralPrivateKey.getS();
        MutablePoint rAMutablePoint = ECOperations.SM2OPS.multiply(SM2ParameterSpec.GENERATOR, CryptoUtils.toByteArrayLE(rA));
        BigInteger x1 = rAMutablePoint.asAffine().getX().asBigInteger();
        BigInteger x1Bar = TWO_POW_W.add(x1.and(TWO_POW_W_SUB_ONE));
        BigInteger dA = this.paramSpec.privateKey.getS();
        BigInteger tA = dA.add(x1Bar.multiply(rA)).mod(SM2ParameterSpec.ORDER);
        ECPoint rBPubPoint = this.peerEphemeralPublicKey.getW();
        BigInteger x2 = rBPubPoint.getAffineX();
        BigInteger x2Bar = TWO_POW_W.add(x2.and(TWO_POW_W_SUB_ONE));
        ECPoint pBPubPoint = this.paramSpec.peerPublicKey.getW();
        MutablePoint interimMutablePoint = ECOperations.SM2OPS.multiply(rBPubPoint, CryptoUtils.toByteArrayLE(x2Bar));
        ECOperations.SM2OPS.setSum(interimMutablePoint, ECOperations.SM2OPS.toAffinePoint(pBPubPoint));
        ECPoint uPoint = ECOperations.toECPoint(ECOperations.SM2OPS.multiply(interimMutablePoint.asAffine(), CryptoUtils.toByteArrayLE(SM2ParameterSpec.COFACTOR.multiply(tA))));
        if (uPoint.equals(ECOperations.INFINITY)) {
            throw new IllegalStateException("Generate secret failed");
        }
        byte[] vX = CryptoUtils.intToBytes32(uPoint.getAffineX());
        byte[] vY = CryptoUtils.intToBytes32(uPoint.getAffineY());
        byte[] zA = this.z(this.paramSpec.id, this.paramSpec.publicKey.getW());
        byte[] zB = this.z(this.paramSpec.peerId, this.paramSpec.peerPublicKey.getW());
        return this.kdf(vX, vY, zA, zB);
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (offset + this.paramSpec.sharedKeyLength > sharedSecret.length) {
            throw new ShortBufferException("Need " + this.paramSpec.sharedKeyLength + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), algorithm);
    }

    private byte[] z(byte[] origId, ECPoint pubPoint) {
        byte[] id = origId == null ? Constants.defaultId() : origId;
        int idLen = id.length << 3;
        this.sm3MD.update((byte)(idLen >>> 8));
        this.sm3MD.update((byte)idLen);
        this.sm3MD.update(id);
        this.sm3MD.update(A);
        this.sm3MD.update(B);
        this.sm3MD.update(GEN_X);
        this.sm3MD.update(GEN_Y);
        this.sm3MD.update(CryptoUtils.intToBytes32(pubPoint.getAffineX()));
        this.sm3MD.update(CryptoUtils.intToBytes32(pubPoint.getAffineY()));
        return this.sm3MD.digest();
    }

    private byte[] kdf(byte[] vX, byte[] vY, byte[] zA, byte[] zB) {
        byte[] combined = this.combine(vX, vY, zA, zB);
        byte[] derivedKey = new byte[this.paramSpec.sharedKeyLength];
        int reminder = this.paramSpec.sharedKeyLength % 32;
        int count = this.paramSpec.sharedKeyLength / 32 + (reminder == 0 ? 0 : 1);
        for (int i = 1; i <= count; ++i) {
            int length = i == count && reminder != 0 ? reminder : 32;
            this.sm3MD.update(combined);
            this.sm3MD.update(CryptoUtils.intToBytes4(i));
            byte[] digest = this.sm3MD.digest();
            System.arraycopy(digest, 0, derivedKey, (i - 1) * 32, length);
        }
        return derivedKey;
    }

    private byte[] combine(byte[] vX, byte[] vY, byte[] zA, byte[] zB) {
        byte[] result = new byte[vX.length + vY.length + zA.length + zB.length];
        System.arraycopy(vX, 0, result, 0, vX.length);
        System.arraycopy(vY, 0, result, vX.length, vY.length);
        if (this.paramSpec.isInitiator) {
            System.arraycopy(zA, 0, result, vX.length + vY.length, zA.length);
            System.arraycopy(zB, 0, result, vX.length + vY.length + zA.length, zB.length);
        } else {
            System.arraycopy(zB, 0, result, vX.length + vY.length, zB.length);
            System.arraycopy(zA, 0, result, vX.length + vY.length + zB.length, zA.length);
        }
        return result;
    }
}

