/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;

public class SM2PrivateKey
implements ECPrivateKey {
    private static final long serialVersionUID = 8891019868158427133L;
    private final BigInteger keyS;
    private final byte[] key;

    public SM2PrivateKey(byte[] key) {
        CryptoUtils.checkKey(key);
        this.keyS = CryptoUtils.toBigInt(key);
        this.key = CryptoUtils.priKey(this.keyS);
    }

    public SM2PrivateKey(BigInteger keyS) {
        CryptoUtils.checkKey(keyS);
        this.keyS = keyS;
        this.key = CryptoUtils.priKey(keyS);
    }

    public SM2PrivateKey(ECPrivateKey ecPrivateKey) {
        this(ecPrivateKey.getS());
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public BigInteger getS() {
        return this.keyS;
    }

    @Override
    public ECParameterSpec getParams() {
        return SM2ParameterSpec.instance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SM2PrivateKey that = (SM2PrivateKey)o;
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }
}

