/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.SM3MessageDigest;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public class SM3HMac
extends MacSpi {
    private final MessageDigest md = new SM3MessageDigest();
    private final byte[] k_ipad = new byte[64];
    private final byte[] k_opad = new byte[64];
    private boolean first = true;

    @Override
    protected int engineGetMacLength() {
        return 32;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] secret = key.getEncoded();
        if (secret == null) {
            throw new InvalidKeyException("Missing key data");
        }
        if (secret.length > 64) {
            byte[] tmp = this.md.digest(secret);
            Arrays.fill(secret, (byte)0);
            secret = tmp;
        }
        for (int i = 0; i < 64; ++i) {
            byte si = i < secret.length ? secret[i] : (byte)0;
            this.k_ipad[i] = (byte)(si ^ 0x36);
            this.k_opad[i] = (byte)(si ^ 0x5C);
        }
        Arrays.fill(secret, (byte)0);
        secret = null;
        this.engineReset();
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(input, offset, len);
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(input);
    }

    @Override
    protected byte[] engineDoFinal() {
        if (this.first) {
            this.md.update(this.k_ipad);
        } else {
            this.first = true;
        }
        try {
            byte[] tmp = this.md.digest();
            this.md.update(this.k_opad);
            this.md.update(tmp);
            this.md.digest(tmp, 0, tmp.length);
            return tmp;
        }
        catch (DigestException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected void engineReset() {
        if (!this.first) {
            this.md.reset();
            this.first = true;
        }
    }
}

