/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;

public final class SM4Engine {
    private static final byte[] S = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    private static final int[] T0 = new int[]{-1898620069, -795721150, 1307223975, 117308411, -53529805, 1709344647, -918686476, 1807081182, 1310087256, 1857346266, 1142181968, -893318389, -2010603360, 402190319, -1674792784, 285545492, -2027180884, -77161059, -224892310, -1367877159, -2111133528, 1186790138, 0x14041010, -809496817, 0x2A8AAAA, 0x54451111, 1595100236, -1104766824, 1833444645, -1635509734, 503715864, -40147354, -325160334, 1245907209, 273760577, 620221395, -711768506, 1408024511, -124099998, -1837372951, -13382452, 0x4555151, 655043628, 1329728781, 1508816823, -204718273, 481211058, -362575479, 1961333651, 2142359246, 1813803120, 229353126, -305518809, 0x28082020, 1223402403, -1047046570, -2138963454, -1545830529, -996781486, 318368747, -1586178603, -1282589122, -1019216644, 1050974874, 1531321629, 453450780, 1000709790, 0xCFFF3F3, 1072746447, -1082995251, 1259822172, 1387850474, -1887367666, 1029203301, -868421392, 2098816100, 2128976795, -1853417962, 1934507325, 0x8AAA2A2, -932601439, -949310035, -2055010810, 2058406602, -1250900539, -194670191, -1294374037, -1484181970, 419161059, 1206431663, 856636476, 1732914477, -1334722111, 240605529, -375425418, -516565804, 1713272952, -1272672112, 906901560, 643791225, -278753907, 945381729, -1781381305, 715164298, -1322937196, -1440577400, -1937903119, -683938580, 83952644, -1524530044, -1736842783, -1685774818, -2066263213, 0, 1581717785, 190209373, -476217730, -1613738161, -1155031908, 441665865, 2085433649, -298395432, 167905288, 2078580639, 547521154, -725150957, -389340381, -425952646, 1122610091, 1136525054, -1568134614, -1697559733, 0x40410101, -607903969, -667361056, 1639438038, 799116942, 737468383, 988924875, -154322117, 502982631, -446659195, 0x41155454, 631473798, 1625523075, 380418746, 693925237, 883331730, -140939666, -466300720, 1914333288, 0x1545555, 430945974, -544125362, -97335096, -265240384, 569825239, -1131531726, 1974716102, 1876987791, 1763538036, 787864539, 1793166219, -1775322952, -1971320310, -26764903, -490132693, -530480767, -1060961533, -1926650716, -1356624756, 128560814, 957166644, 525487437, 1984903481, -747717187, -2116659369, -1210552465, -348660516, 0x51441515, -1495434373, 167704567, -1232324038, -1825588036, 251857932, 0x3FCFFFF, -1033131607, -1166816823, -647187019, -596790863, 928673133, 357582149, -1181796810, 1998285932, 330153662, -628078006, 1471803118, -1445038217, 1287582450, -2088829443, 0x55114444, -1109760153, 744321393, 0x45400505, 1663007868, 1343242304, 844851561, -1193581725, 571090984, -977139961, -181287740, -1467342302, 833066646, -103925961, -1753551379, 1237317366, -1725057868, -1535782447, -1865202877, 1511147592, 1488642786, 1910937495, 1689703122, 1890763458, -1383389658, -848779867, -879403426, 1649092905, 0x3C0C3030, -829138342, -1418273315, -2038433287, -245066347, 1572595430, 905103303, 755573796, -775547113, -697321031, -557507813, -1803152878, 2014863456, 821281731, -1988299275, 1559212979, -767891224, -1394642061, 2035037493, -1608482688, -1653021211, 1458420667, 593395069, -968951560, -1949016225, -406311121, -583408412, 1749623073};
    private static final int[] T1 = new int[]{1536087387, 1120965186, -1488065881, -83427845, 0x33FCCF33, -2023366009, -188137996, -563366434, 1481512536, -630278950, 1346638928, 197837067, -1601689440, -283641617, -1331942224, 336659732, -1400427604, -1644468579, 1794283626, -642877479, -1467864408, -96027398, 0x10140410, 0xFCFC00F, -1442666326, 0x11544511, 1281299276, -1732368744, 627918885, 446596122, 404620824, 1727896422, 1928109682, 155861769, 1091588417, -752551981, 1188401990, -1085018945, 1660459618, -376275991, -855690292, 1359238481, 740756268, 223298061, -1218842953, 0x3FF3CC3F, -1306743118, -1981127799, -1821055085, -830492210, 1886133360, -1509053530, 669895207, 0x20280820, -1555502173, 1455527766, 0x2808202, 2141445247, 1388615250, -351077909, -710839083, 1051954494, -54312964, -1707170662, 492520989, 471533340, -1640258146, -217251853, -817893169, -843091251, 1548425052, -363677462, 244285710, 1698519141, -255050512, 1685920100, -1686182501, 378636054, 1030966845, -1576490334, -1580701279, -1379439955, 109413126, -897929014, -977964859, -1846254191, 1806883179, 782731566, -484901917, -1354241873, 1009979196, 761743917, -1045401151, 1494112089, 1995022198, -723438124, 2019958392, -1867242352, 943066680, 2032557945, -1913691507, 1631082849, 1201001031, -1976917878, -1800329836, -2002115960, -242450959, -321438740, 67436804, -2069552764, -510101023, 513508638, 1401214803, 0, 425608985, 1561024093, 2128846206, 1335873615, -1665456228, 1226462025, 830229809, -655477032, 134873608, -1619270497, -2111790462, 332711699, 602458915, 2061933690, -1421678165, -29114882, 0x2AA2882A, 1268437323, 0x1404101, 534496287, -522700576, -698239018, -1909481074, -550767393, -885329461, 1006030139, -417465625, -2048565115, 0x54411554, -2044353658, -2090802301, -1172919110, 1965644917, -1842043246, 1861720430, -790350640, 1752308328, 1426150485, -1239830602, 1323274574, -923127096, -1058000704, -685639977, 851217970, -965364794, -1888493425, 1953045876, -617679397, -1955929717, -1198117192, 0xA8A800A, -1711380583, 736282923, -2116001407, 0x3C0C303, -1534252636, -1934679156, -1375229522, 876154164, 1293898317, 964054841, -1110217027, 1468126807, 1874319471, -588564516, 0x15514415, 2074533243, -150339849, 985041978, -1131204676, 202310412, -16515841, -1446876247, -910527543, -1244042059, -1310954063, 1832344173, 1159024709, 918130486, 1819745132, -1106006594, 1255837770, -296240658, 2007621239, -229851406, -41713923, 0x44551144, 1740495463, 1898732913, 0x5454005, 2086870908, 1078988864, 1764907881, 1673059171, 673319464, 130400775, -990563900, 0x22A88A22, -1775130730, 939118135, -308839699, -162938890, -1265029708, -777751087, 1133564739, 1213862472, -497501470, -1754143081, -765151534, -1032801598, 648907558, -1513264987, 1590400350, 694307625, 0x303C0C30, 1523487834, -575965475, -108625927, -1779342187, -430064666, -952765753, 606931236, 399623703, -1177129031, 467584283, 311723538, 1618483296, -1020202045, -175538955, -1285754957, -388875544, 1940709235, 897141813, -2136989568, -442664731, -1151930949, 2099469949, -121225480, 1602999391, 803719215, -455263772, 560482593};
    private static final int[] T2 = new int[]{1532726997, 1111675026, -1482207766, -67434755, 0x3333FCCF, -2021169694, -185284291, -555848779, 1482182166, -623219020, 1347437588, 185322177, -1600092120, -269543432, -1330602964, 336859397, -1397979349, -1650590874, 1785393816, -640045449, -1465351638, -84261188, 0x10101404, 0xF0FCFC0, -1431698776, 0x11115445, 1280073491, -1734820314, 623209800, 437952132, 404233734, 1718025627, 1920134302, 151603779, 1094783057, -741137161, 1179047315, -1077980180, 1650653338, -370568581, -858980557, 1364264021, 741091083, 218976066, -1212720658, 0x3F3FF3CC, -1296950098, -1987450269, -1819052825, -825327695, 1886415900, -1499066965, 656928202, 0x20202808, -1549580053, 1448526231, 0x2028082, 2139071452, 1381155990, -336915719, -707419788, 1044296589, -50543809, -1701167452, 488463174, 471603975, -1633797211, -202175233, -808501264, -842154126, 1549552407, -353742152, 235835265, 1701133656, -252654532, 1684307225, -1684308251, 370577799, 1027437390, -1566439254, -1583232919, -1381120150, 101090691, -892699984, -976898704, -1852705691, 1802220249, 774809481, -471656197, -1347467288, 1010578191, 757950282, -1044270991, 1499008599, 1987504543, -724246219, 2021156382, -1869564892, 943207950, 2037982815, -1920077982, 1633761369, 1195873746, -1970656608, -1802194651, -2004309470, -235828099, -320022725, 67372289, -2071681759, -505309063, 505322373, 1397982423, 0, 421092935, 1566378838, 2122245021, 1330618320, -1667450073, 1229527635, 825326669, -656871882, 134744578, -1616938012, -2105401182, 320066759, 589555915, 2054874780, -1414839575, -16890947, 0x2A2AA288, 1263246033, 0x1014041, 522181572, -522135496, -690593353, -1903284319, -539022348, -875873551, 993785549, -404283910, -2054822560, 0x54544115, -2038028893, -2088541981, -1162209620, 1970612572, -1835912026, 1852766105, -791616460, 1751675418, 1431634260, -1229579857, 1313791889, -926352846, -1061097424, -673766922, 842185870, -960072269, -1886425120, 1953786141, -606392587, -1953797407, -1195862482, 0xA0A8A80, -1717961113, 724296393, -2122194847, 0x303C0C3, -1532719831, -1936937181, -1364326487, 875837709, 1296899922, 960067151, -1111633042, 1465352662, 1869592536, -589501641, 0x15155144, 2071701213, -134804994, 976926348, -1128492241, 202116867, -64516, -1448492437, -909526413, -1246373524, -1313743763, 1835874138, 1162155344, 909556111, 1819047707, -1094839379, 1246419600, -286369863, 2004330974, -219001666, -33717378, 0x44445511, 1734852058, 1903242333, 0x5054540, 2088526623, 1077956624, 1768501851, 1667479771, 673718794, 117949890, -993725135, 0x2222A88A, -1768541785, 926415310, -303196294, -151631425, -1263232723, -774790027, 1128501459, 1212701202, -488482630, -1751682586, -757963594, -1027444558, 640069003, -1515860632, 1583270805, 690577995, 0x30303C0C, 1515900564, -572675210, -101087617, -1785335452, -421110341, -943245838, 606350601, 387436998, -1179003281, 454811333, 303207558, 1616934936, -1010618125, -168457860, -1280090897, -387395014, 1936960735, 892696908, -2139054048, -437936776, -1145350419, 2105353054, -117914050, 1600097236, 791668680, -454763207, 555837513};
    private static final int[] T3 = new int[]{-715433074, -1841151280, -358111411, -33817850, -818727940, -494434459, 1039463625, -1243685269, 374888526, -1260725650, 340807748, -1056240694, 681615496, -118493417, 749777052, 0x5141411, 732736647, 1721605627, -1737856270, 2010765742, 0x2AA8A882, -1124402618, 0x4101014, -1072754737, -1465210366, 0x45111154, 323767391, 647534782, 1210393965, -2078664034, 102242334, -1687787779, -1636666644, 1124665674, 1363230992, -137112796, -1824110891, -322977965, -1704828168, 2078927250, 0x33CCCCFF, 1431392516, 187444263, 1108151631, -289949863, -868270093, -1364020708, 1669958122, -409758860, -1311846785, 477130860, -1415141875, -903403539, 0x8202028, -341597368, -1755949375, -2113797504, -595624029, -1772989756, -101979374, 1960170913, -1925300557, 0x3FFCFCC3, -1533371842, 1176313179, 119282715, -1516331461, -789748, -254816449, 1926090175, 391928907, -1192564142, -2129785201, 1483040061, 1022423244, 426009725, -442786946, -2028595567, 1312636275, -1432182264, 1772200392, 1789767111, -2096757115, -1328887174, 1892009397, 1704038900, -647271502, -1993462105, -68951272, -391139513, 0xF3C3C33, 1244474727, 1908523440, 1465473294, -1619626263, 903140577, 511211622, 613454004, 238565430, 1601796390, 1653444079, 1499554104, -767080555, -1601533398, 630494385, 0x228888AA, 2113008012, 1005382871, 17040389, 562332837, 2044846488, -2061623653, -682404988, 0, 1192827230, 1448959243, -1652654365, -800108641, 664575163, 1397311770, 1295069564, 920180974, 34080778, -459300997, -1568505312, -955051052, -886889496, -1669694746, -374625470, -1107362237, -2010502494, -783594598, 0x41010140, -1004593189, 954261720, -1210657183, -1584493009, -186654933, -238302406, -851756042, -85465315, 1619363301, 0x15545441, -1551464923, -477920416, -1397048810, 1551201577, -1500343756, -1720815881, 886100196, 443050098, 1414878465, -1346980327, -1857138977, 852019450, 817938672, -153626847, -1909312836, -1278818699, -527462545, 494171241, -170140882, -510948502, 783857814, -2146825590, 1738119678, -919917598, 1635877344, -1023212608, 698655885, 596413615, -1448169977, 221525049, 1380797727, 1329150326, 1857928659, -698919039, -663785545, 937221355, 0x44151551, -579109978, -17303799, -1942340938, 800898195, 51121167, -50331901, 1806281154, 1942604218, 1823847897, 1840361948, 1517120823, 1346716949, -1892272455, 460090487, -1380008429, -1874179366, -1175523753, -562595927, -1091374516, 2130574723, 0x11444455, -630757443, 1567715628, 0x40050545, 528252003, 272646224, 1533634866, -614243400, 0xA282822, -1039726651, 834979061, -1977474392, -1483303375, -835241991, 2062413207, -1074334135, 766817433, 1976684964, -750566512, 306727002, -1159536040, -426272911, -1227697564, -1295859088, -1960434003, 1755686349, -1788977461, 1260988770, 0xC30303C, -1806017842, 1994251691, 2147088774, 1687524849, -1142495651, -221788363, 153363501, -971565103, 1874442710, -988079138, -2045635948, 408969336, -205274320, 2096493961, -273435812, 988342482, -546081876, 1278555513, 545292448, 2028332445, -306463914, 1585282339, 1056504006, -731947125, -936431641, 971302109, 1226908008};
    private static final int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    private static final int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};

    public static int[] expandKey(byte[] key, boolean encrypt) {
        int[] mk = new int[]{CryptoUtils.bytes4ToInt(key, 0), CryptoUtils.bytes4ToInt(key, 4), CryptoUtils.bytes4ToInt(key, 8), CryptoUtils.bytes4ToInt(key, 12)};
        int[] k = new int[]{mk[0] ^ FK[0], mk[1] ^ FK[1], mk[2] ^ FK[2], mk[3] ^ FK[3]};
        int[] rk = new int[32];
        if (encrypt) {
            rk[0] = k[0] ^ SM4Engine.tprime(k[1] ^ k[2] ^ k[3] ^ CK[0]);
            rk[1] = k[1] ^ SM4Engine.tprime(k[2] ^ k[3] ^ rk[0] ^ CK[1]);
            rk[2] = k[2] ^ SM4Engine.tprime(k[3] ^ rk[0] ^ rk[1] ^ CK[2]);
            rk[3] = k[3] ^ SM4Engine.tprime(rk[0] ^ rk[1] ^ rk[2] ^ CK[3]);
            for (int i = 4; i < 32; ++i) {
                rk[i] = rk[i - 4] ^ SM4Engine.tprime(rk[i - 3] ^ rk[i - 2] ^ rk[i - 1] ^ CK[i]);
            }
        } else {
            rk[31] = k[0] ^ SM4Engine.tprime(k[1] ^ k[2] ^ k[3] ^ CK[0]);
            rk[30] = k[1] ^ SM4Engine.tprime(k[2] ^ k[3] ^ rk[31] ^ CK[1]);
            rk[29] = k[2] ^ SM4Engine.tprime(k[3] ^ rk[31] ^ rk[30] ^ CK[2]);
            rk[28] = k[3] ^ SM4Engine.tprime(rk[31] ^ rk[30] ^ rk[29] ^ CK[3]);
            for (int i = 27; i >= 0; --i) {
                rk[i] = rk[i + 4] ^ SM4Engine.tprime(rk[i + 3] ^ rk[i + 2] ^ rk[i + 1] ^ CK[31 - i]);
            }
        }
        return rk;
    }

    private static int tprime(int z) {
        return SM4Engine.lprime(SM4Engine.tau(z));
    }

    private static int lprime(int b) {
        return b ^ CryptoUtils.circularLeftShift(b, 13) ^ CryptoUtils.circularLeftShift(b, 23);
    }

    public static void processBlock(int[] rk, byte[] in, int inOffset, byte[] out, int outOffset) {
        int[] x = new int[]{CryptoUtils.bytes4ToInt(in, inOffset), CryptoUtils.bytes4ToInt(in, inOffset + 4), CryptoUtils.bytes4ToInt(in, inOffset + 8), CryptoUtils.bytes4ToInt(in, inOffset + 12)};
        x[0] = x[0] ^ SM4Engine.tSlow(x[1] ^ x[2] ^ x[3] ^ rk[0]);
        x[1] = x[1] ^ SM4Engine.tSlow(x[2] ^ x[3] ^ x[0] ^ rk[1]);
        x[2] = x[2] ^ SM4Engine.tSlow(x[3] ^ x[0] ^ x[1] ^ rk[2]);
        x[3] = x[3] ^ SM4Engine.tSlow(x[0] ^ x[1] ^ x[2] ^ rk[3]);
        for (int i = 4; i < 28; ++i) {
            int n = i % 4;
            x[n] = x[n] ^ SM4Engine.tFast(x[(i + 1) % 4] ^ x[(i + 2) % 4] ^ x[(i + 3) % 4] ^ rk[i]);
        }
        x[0] = x[0] ^ SM4Engine.tSlow(x[1] ^ x[2] ^ x[3] ^ rk[28]);
        x[1] = x[1] ^ SM4Engine.tSlow(x[2] ^ x[3] ^ x[0] ^ rk[29]);
        x[2] = x[2] ^ SM4Engine.tSlow(x[3] ^ x[0] ^ x[1] ^ rk[30]);
        x[3] = x[3] ^ SM4Engine.tSlow(x[0] ^ x[1] ^ x[2] ^ rk[31]);
        CryptoUtils.intToBytes4(x[3], out, outOffset);
        CryptoUtils.intToBytes4(x[2], out, outOffset + 4);
        CryptoUtils.intToBytes4(x[1], out, outOffset + 8);
        CryptoUtils.intToBytes4(x[0], out, outOffset + 12);
    }

    private static int tFast(int a) {
        return T0[a >> 24 & 0xFF] ^ T1[a >> 16 & 0xFF] ^ T2[a >> 8 & 0xFF] ^ T3[a & 0xFF];
    }

    private static int tSlow(int a) {
        return SM4Engine.l(SM4Engine.tau(a));
    }

    private static int l(int b) {
        return b ^ CryptoUtils.circularLeftShift(b, 2) ^ CryptoUtils.circularLeftShift(b, 10) ^ CryptoUtils.circularLeftShift(b, 18) ^ CryptoUtils.circularLeftShift(b, 24);
    }

    private static int tau(int a) {
        int b0 = S[a >> 24 & 0xFF] & 0xFF;
        int b1 = S[a >> 16 & 0xFF] & 0xFF;
        int b2 = S[a >> 8 & 0xFF] & 0xFF;
        int b3 = S[a & 0xFF] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    public static void main(String[] args) {
        SM4Engine.genLookupTables();
    }

    private static void genLookupTables() {
        System.out.println("T0:");
        SM4Engine.genLookupTable(0);
        System.out.println("T1:");
        SM4Engine.genLookupTable(1);
        System.out.println("T2:");
        SM4Engine.genLookupTable(2);
        System.out.println("T3:");
        SM4Engine.genLookupTable(3);
    }

    private static void genLookupTable(int index) {
        for (int i = 0; i < 256; ++i) {
            int elem = SM4Engine.l(SM4Engine.integer(S[i], index));
            System.out.printf("0x%08X,", elem);
            if ((i + 1) % 4 != 0) {
                System.out.print(" ");
                continue;
            }
            System.out.println();
        }
    }

    private static int integer(byte sElem, int index) {
        return CryptoUtils.bytes4ToInt(SM4Engine.array(sElem, index), 0);
    }

    private static byte[] array(byte sElem, int index) {
        byte[] elem = new byte[4];
        elem[index] = sElem;
        return elem;
    }
}

