/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.provider.SM4GenParameterSpec;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class SM4ParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SM4GenParameterSpec paramSpec;
    private SecureRandom random;

    @Override
    protected void engineInit(int keySize, SecureRandom random) {
        throw new InvalidParameterException("Use init(AlgorithmParameterSpec paramSpec) or init(AlgorithmParameterSpec, SecureRandom)");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(paramSpec instanceof SM4GenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only SM4GenParameterSpec is supported");
        }
        this.paramSpec = (SM4GenParameterSpec)paramSpec;
        this.random = random;
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.paramSpec.getParamSpecClass().equals(IvParameterSpec.class) ? this.genParams() : this.genGcmParams();
    }

    private AlgorithmParameters genParams() {
        byte[] iv = new byte[16];
        this.random.nextBytes(iv);
        try {
            AlgorithmParameters params = CryptoInsts.getAlgorithmParameters("SM4");
            params.init(new IvParameterSpec(iv));
            return params;
        }
        catch (Exception ex) {
            throw new ProviderException("Unexpected exception", ex);
        }
    }

    private AlgorithmParameters genGcmParams() {
        byte[] iv = new byte[12];
        this.random.nextBytes(iv);
        try {
            AlgorithmParameters params = CryptoInsts.getAlgorithmParameters("SM4");
            params.init(new GCMParameterSpec(128, iv));
            return params;
        }
        catch (Exception ex) {
            throw new ProviderException("Unexpected exception", ex);
        }
    }
}

