/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.spec;

import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.util.Constants;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class SM2KeyAgreementParamSpec
implements AlgorithmParameterSpec {
    public final byte[] id;
    public final SM2PrivateKey privateKey;
    public final SM2PublicKey publicKey;
    public final byte[] peerId;
    public final SM2PublicKey peerPublicKey;
    public final boolean isInitiator;
    public final int sharedKeyLength;

    public SM2KeyAgreementParamSpec(byte[] id, ECPrivateKey privateKey, ECPublicKey publicKey, byte[] peerId, ECPublicKey peerPublicKey, boolean isInitiator, int sharedKeyLength) {
        this.id = id;
        this.privateKey = new SM2PrivateKey(privateKey);
        this.publicKey = new SM2PublicKey(publicKey);
        this.peerId = peerId;
        this.peerPublicKey = new SM2PublicKey(peerPublicKey);
        this.isInitiator = isInitiator;
        this.sharedKeyLength = sharedKeyLength;
    }

    public SM2KeyAgreementParamSpec(ECPrivateKey privateKey, ECPublicKey publicKey, ECPublicKey peerPublicKey, boolean isInitiator, int sharedKeyLength) {
        this(Constants.defaultId(), privateKey, publicKey, Constants.defaultId(), peerPublicKey, isInitiator, sharedKeyLength);
    }
}

