/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util;

import com.tencent.kona.sun.security.action.GetPropertyAction;
import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.KnownOIDs;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.PatternSyntaxException;
import javax.crypto.Cipher;

public final class SecurityProviderConstants {
    private static final Debug debug;
    private static final ConcurrentHashMap<String, List<String>> aliasesMap;
    public static final int DEF_DSA_KEY_SIZE;
    public static final int DEF_RSA_KEY_SIZE;
    public static final int DEF_RSASSA_PSS_KEY_SIZE;
    public static final int DEF_DH_KEY_SIZE;
    public static final int DEF_EC_KEY_SIZE;
    public static final int DEF_ED_KEY_SIZE;
    public static final int DEF_XEC_KEY_SIZE;
    private static final AtomicInteger DEF_AES_KEY_SIZE;
    private static final String KEY_LENGTH_PROP = "jdk.security.defaultKeySize";

    private SecurityProviderConstants() {
    }

    private static List<String> store(String stdName, KnownOIDs oid, String ... extraAliases) {
        ArrayList<String> value;
        if (oid == null && extraAliases.length != 0) {
            value = Arrays.asList(extraAliases);
        } else {
            value = new ArrayList();
            if (oid != null) {
                value.add("OID." + oid.value());
                value.add(oid.value());
                String[] knownAliases = oid.aliases();
                if (knownAliases != null) {
                    Collections.addAll(value, knownAliases);
                }
            }
            Collections.addAll(value, extraAliases);
        }
        aliasesMap.put(stdName, value);
        return value;
    }

    public static List<String> getAliases(String o) {
        List<String> res = aliasesMap.get(o);
        if (res == null) {
            KnownOIDs e = KnownOIDs.findMatch(o);
            if (e != null) {
                return SecurityProviderConstants.store(o, e, new String[0]);
            }
            throw new ProviderException("Cannot find aliases for " + o);
        }
        return res;
    }

    public static final int getDefDSASubprimeSize(int primeSize) {
        if (primeSize <= 1024) {
            return 160;
        }
        if (primeSize == 2048) {
            return 224;
        }
        if (primeSize == 3072) {
            return 256;
        }
        throw new InvalidParameterException("Invalid DSA Prime Size: " + primeSize);
    }

    public static final int getDefAESKeySize() {
        int currVal = DEF_AES_KEY_SIZE.get();
        if (currVal == -1) {
            int v = 256;
            try {
                int max = Cipher.getMaxAllowedKeyLength("AES");
                if (v > max) {
                    v = max;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            DEF_AES_KEY_SIZE.compareAndSet(-1, v);
            currVal = v;
        }
        return currVal;
    }

    static {
        int aesKeySize;
        int xecKeySize;
        int edKeySize;
        int ecKeySize;
        int dhKeySize;
        int rsaSsaPssKeySize;
        int rsaKeySize;
        int dsaKeySize;
        block23: {
            debug = Debug.getInstance("jca", "ProviderConfig");
            String keyLengthStr = GetPropertyAction.privilegedGetProperty(KEY_LENGTH_PROP);
            dsaKeySize = 2048;
            rsaSsaPssKeySize = rsaKeySize = 3072;
            dhKeySize = 3072;
            ecKeySize = 384;
            edKeySize = 255;
            xecKeySize = 255;
            aesKeySize = -1;
            if (keyLengthStr != null) {
                try {
                    String[] pairs;
                    for (String p : pairs = keyLengthStr.split(",")) {
                        int value;
                        String[] algoAndValue = p.split(":");
                        if (algoAndValue.length != 2) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid pair in jdk.security.defaultKeySize property: " + p);
                            continue;
                        }
                        String algoName = algoAndValue[0].trim().toUpperCase(Locale.ENGLISH);
                        try {
                            value = Integer.parseInt(algoAndValue[1].trim());
                        }
                        catch (NumberFormatException nfe) {
                            if (debug == null) continue;
                            debug.println("Ignoring invalid value in jdk.security.defaultKeySize property: " + p);
                            continue;
                        }
                        if (algoName.equals("DSA")) {
                            dsaKeySize = value;
                        } else if (algoName.equals("RSA")) {
                            rsaKeySize = value;
                        } else if (algoName.equals("RSASSA-PSS")) {
                            rsaSsaPssKeySize = value;
                        } else if (algoName.equals("DH")) {
                            dhKeySize = value;
                        } else if (algoName.equals("EC")) {
                            ecKeySize = value;
                        } else if (algoName.equalsIgnoreCase("EdDSA")) {
                            edKeySize = value;
                        } else if (algoName.equals("XDH")) {
                            xecKeySize = value;
                        } else if (algoName.equals("AES")) {
                            aesKeySize = value;
                        } else {
                            if (debug == null) continue;
                            debug.println("Ignoring unsupported algo in jdk.security.defaultKeySize property: " + p);
                            continue;
                        }
                        if (debug == null) continue;
                        debug.println("Overriding default " + algoName + " keysize with value from " + KEY_LENGTH_PROP + " property: " + value);
                    }
                }
                catch (PatternSyntaxException pse) {
                    if (debug == null) break block23;
                    debug.println("Unexpected exception while parsing jdk.security.defaultKeySize property: " + pse);
                }
            }
        }
        DEF_DSA_KEY_SIZE = dsaKeySize;
        DEF_RSA_KEY_SIZE = rsaKeySize;
        DEF_RSASSA_PSS_KEY_SIZE = rsaSsaPssKeySize;
        DEF_DH_KEY_SIZE = dhKeySize;
        DEF_EC_KEY_SIZE = ecKeySize;
        DEF_ED_KEY_SIZE = edKeySize;
        DEF_XEC_KEY_SIZE = xecKeySize;
        DEF_AES_KEY_SIZE = new AtomicInteger(aesKeySize);
        aliasesMap = new ConcurrentHashMap();
        SecurityProviderConstants.store("SHA1withDSA", KnownOIDs.SHA1withDSA, KnownOIDs.OIW_JDK_SHA1withDSA.value(), KnownOIDs.OIW_SHA1withDSA.value(), "DSA", "SHA/DSA", "SHA-1/DSA", "SHA1/DSA", "SHAwithDSA", "DSAWithSHA1");
        SecurityProviderConstants.store("DSA", KnownOIDs.DSA, KnownOIDs.OIW_DSA.value());
        SecurityProviderConstants.store("SHA1withRSA", KnownOIDs.SHA1withRSA, KnownOIDs.OIW_SHA1withRSA.value());
        SecurityProviderConstants.store("SHA-1", KnownOIDs.SHA_1, new String[0]);
        SecurityProviderConstants.store("PBEWithMD5AndDES", KnownOIDs.PBEWithMD5AndDES, "PBE");
        SecurityProviderConstants.store("DiffieHellman", KnownOIDs.DiffieHellman, new String[0]);
        SecurityProviderConstants.store("EC", KnownOIDs.EC, "EllipticCurve");
        SecurityProviderConstants.store("X.509", null, "X509");
        SecurityProviderConstants.store("NONEwithDSA", null, "RawDSA");
        SecurityProviderConstants.store("DESede", null, "TripleDES");
        SecurityProviderConstants.store("ARCFOUR", KnownOIDs.ARCFOUR, new String[0]);
        SecurityProviderConstants.store("PKCS1", KnownOIDs.PKCS1, KnownOIDs.RSA.value());
        SecurityProviderConstants.store("AES/KW/NoPadding", null, "AESWrap");
        SecurityProviderConstants.store("AES/KWP/NoPadding", null, "AESWrapPad");
    }
}

