/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public class SSLUtils {
    public static String getPropCertListFormat() {
        return System.getProperty("com.tencent.kona.ssl.certListFormat");
    }

    public static void setPropCertListFormat(String format) {
        String certListFormat = format == null || format.length() == 0 ? "" : format.toUpperCase(Locale.ENGLISH);
        System.setProperty("com.tencent.kona.ssl.certListFormat", certListFormat);
    }

    public static KeyPairGenerator getECKeyPairGenerator(String namedGroup) throws NoSuchAlgorithmException {
        String algorithm = "curvesm2".equalsIgnoreCase(namedGroup) ? "SM2" : "EC";
        return CryptoInsts.getKeyPairGenerator((String)algorithm);
    }
}

