/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.internal.spec;

import java.security.spec.AlgorithmParameterSpec;

public class TlcpSM2PremasterSecretParameterSpec
implements AlgorithmParameterSpec {
    private final int clientVersion;
    private final int serverVersion;
    private final byte[] encodedSecret;

    public TlcpSM2PremasterSecretParameterSpec(int clientVersion, int serverVersion) {
        this.clientVersion = this.checkVersion(clientVersion);
        this.serverVersion = this.checkVersion(serverVersion);
        this.encodedSecret = null;
    }

    public TlcpSM2PremasterSecretParameterSpec(int clientVersion, int serverVersion, byte[] encodedSecret) {
        this.clientVersion = this.checkVersion(clientVersion);
        this.serverVersion = this.checkVersion(serverVersion);
        if (encodedSecret == null || encodedSecret.length != 48) {
            throw new IllegalArgumentException("Encoded secret is not exactly 48 bytes");
        }
        this.encodedSecret = encodedSecret;
    }

    private int checkVersion(int version) {
        if (version < 0 || version > 65535) {
            throw new IllegalArgumentException("Version must be between 0 and 65,535");
        }
        return version;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public int getMajorVersion() {
        if (this.clientVersion >= 770) {
            return this.clientVersion >>> 8 & 0xFF;
        }
        return this.serverVersion >>> 8 & 0xFF;
    }

    public int getMinorVersion() {
        if (this.clientVersion >= 770) {
            return this.clientVersion & 0xFF;
        }
        return this.serverVersion & 0xFF;
    }

    public byte[] getEncodedSecret() {
        return this.encodedSecret == null ? null : (byte[])this.encodedSecret.clone();
    }
}

