/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.provider;

import com.tencent.kona.sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import com.tencent.kona.sun.security.internal.spec.TlsKeyMaterialSpec;
import com.tencent.kona.sun.security.provider.TlcpPrfGenerator;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class TlcpKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlcpKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private TlsKeyMaterialParameterSpec spec;
    private int protocolVersion;

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsKeyMaterialParameterSpec)params;
        if (!"RAW".equals(this.spec.getMasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.protocolVersion != 257 && this.protocolVersion != 771) {
            throw new InvalidAlgorithmParameterException("Only TLCP and TLS 1.2 supported");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        try {
            return this.engineGenerateKey0();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }

    private SecretKey engineGenerateKey0() throws GeneralSecurityException {
        byte[] masterSecret = this.spec.getMasterSecret().getEncoded();
        byte[] clientRandom = this.spec.getClientRandom();
        byte[] serverRandom = this.spec.getServerRandom();
        SecretKeySpec clientMacKey = null;
        SecretKeySpec serverMacKey = null;
        SecretKeySpec clientCipherKey = null;
        SecretKeySpec serverCipherKey = null;
        IvParameterSpec clientIv = null;
        IvParameterSpec serverIv = null;
        int macLength = this.spec.getMacKeyLength();
        int expandedKeyLength = this.spec.getExpandedCipherKeyLength();
        boolean isExportable = expandedKeyLength != 0;
        int keyLength = this.spec.getCipherKeyLength();
        int ivLength = this.spec.getIvLength();
        int keyBlockLen = macLength + keyLength + (isExportable ? 0 : ivLength);
        byte[] seed = TlcpPrfGenerator.concat(serverRandom, clientRandom);
        byte[] keyBlock = TlcpPrfGenerator.doTLCPPRF(masterSecret, TlcpPrfGenerator.LABEL_KEY_EXPANSION, seed, keyBlockLen <<= 1, this.spec.getPRFHashAlg(), this.spec.getPRFHashLength(), this.spec.getPRFBlockSize());
        int ofs = 0;
        if (macLength != 0) {
            byte[] tmp = new byte[macLength];
            System.arraycopy(keyBlock, ofs, tmp, 0, macLength);
            clientMacKey = new SecretKeySpec(tmp, "Mac");
            System.arraycopy(keyBlock, ofs += macLength, tmp, 0, macLength);
            ofs += macLength;
            serverMacKey = new SecretKeySpec(tmp, "Mac");
        }
        if (keyLength == 0) {
            return new TlsKeyMaterialSpec(clientMacKey, serverMacKey);
        }
        String alg = this.spec.getCipherAlgorithm();
        if (!isExportable) {
            byte[] clientKeyBytes = new byte[keyLength];
            System.arraycopy(keyBlock, ofs, clientKeyBytes, 0, keyLength);
            clientCipherKey = new SecretKeySpec(clientKeyBytes, alg);
            byte[] serverKeyBytes = new byte[keyLength];
            System.arraycopy(keyBlock, ofs += keyLength, serverKeyBytes, 0, keyLength);
            ofs += keyLength;
            serverCipherKey = new SecretKeySpec(serverKeyBytes, alg);
            if (ivLength != 0) {
                byte[] tmp = new byte[ivLength];
                System.arraycopy(keyBlock, ofs, tmp, 0, ivLength);
                clientIv = new IvParameterSpec(tmp);
                System.arraycopy(keyBlock, ofs += ivLength, tmp, 0, ivLength);
                serverIv = new IvParameterSpec(tmp);
            }
        }
        return new TlsKeyMaterialSpec(clientMacKey, serverMacKey, clientCipherKey, clientIv, serverCipherKey, serverIv);
    }
}

