/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.DHKeyExchange;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLTrafficKeyDerivation;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLHandshakeException;

final class DHClientKeyExchange {
    static final DHClientKeyExchangeConsumer dhHandshakeConsumer = new DHClientKeyExchangeConsumer();
    static final DHClientKeyExchangeProducer dhHandshakeProducer = new DHClientKeyExchangeProducer();

    DHClientKeyExchange() {
    }

    private static final class DHClientKeyExchangeConsumer
    implements SSLConsumer {
        private DHClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            DHKeyExchange.DHEPossession dhePossession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof DHKeyExchange.DHEPossession)) continue;
                dhePossession = (DHKeyExchange.DHEPossession)possession;
                break;
            }
            if (dhePossession == null) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No expected DHE possessions for client key exchange");
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            DHClientKeyExchangeMessage ckem = new DHClientKeyExchangeMessage(shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Consuming DH ClientKeyExchange handshake message", (Object[])new Object[]{ckem});
            }
            try {
                DHParameterSpec params = dhePossession.publicKey.getParams();
                DHPublicKeySpec spec = new DHPublicKeySpec(new BigInteger(1, ckem.y), params.getP(), params.getG());
                KeyFactory kf = CryptoInsts.getKeyFactory((String)"DiffieHellman");
                DHPublicKey peerPublicKey = (DHPublicKey)kf.generatePublic(spec);
                if (!shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), peerPublicKey)) {
                    throw new SSLHandshakeException("DHPublicKey does not comply to algorithm constraints");
                }
                NamedGroup namedGroup = NamedGroup.valueOf(params);
                shc.handshakeCredentials.add(new DHKeyExchange.DHECredentials(peerPublicKey, namedGroup));
            }
            catch (IOException | GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate DHPublicKey").initCause(e);
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class DHClientKeyExchangeProducer
    implements HandshakeProducer {
        private DHClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            DHKeyExchange.DHECredentials dheCredentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof DHKeyExchange.DHECredentials)) continue;
                dheCredentials = (DHKeyExchange.DHECredentials)cd;
                break;
            }
            if (dheCredentials == null) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No DHE credentials negotiated for client key exchange");
            }
            DHKeyExchange.DHEPossession dhePossession = new DHKeyExchange.DHEPossession(dheCredentials, chc.sslContext.getSecureRandom());
            chc.handshakePossessions.add(dhePossession);
            DHClientKeyExchangeMessage ckem = new DHClientKeyExchangeMessage(chc);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced DH ClientKeyExchange handshake message", (Object[])new Object[]{ckem});
            }
            ckem.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class DHClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] y;

        DHClientKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            DHKeyExchange.DHEPossession dhePossession = null;
            for (SSLPossession possession : chc.handshakePossessions) {
                if (!(possession instanceof DHKeyExchange.DHEPossession)) continue;
                dhePossession = (DHKeyExchange.DHEPossession)possession;
                break;
            }
            if (dhePossession == null) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No DHE credentials negotiated for client key exchange");
            }
            DHPublicKey publicKey = dhePossession.publicKey;
            DHParameterSpec params = publicKey.getParams();
            this.y = Utilities.toByteArray((BigInteger)publicKey.getY());
        }

        DHClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            if (m.remaining() < 3) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ClientKeyExchange message: insufficient data");
            }
            this.y = Record.getBytes16(m);
            if (m.hasRemaining()) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ClientKeyExchange message: unknown extra data");
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            return this.y.length + 2;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putBytes16(this.y);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"DH ClientKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_Yc\": '{'\n{0}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent((String)hexEncoder.encodeBuffer(this.y), (String)"      ")};
            return messageFormat.format(messageFields);
        }
    }
}

