/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ClientHello;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.ServerHello;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;

abstract class HelloCookieManager {
    HelloCookieManager() {
    }

    abstract byte[] createCookie(ServerHandshakeContext var1, ClientHello.ClientHelloMessage var2) throws IOException;

    abstract boolean isCookieValid(ServerHandshakeContext var1, ClientHello.ClientHelloMessage var2, byte[] var3) throws IOException;

    private static final class T13HelloCookieManager
    extends HelloCookieManager {
        final SecureRandom secureRandom;
        private int cookieVersion;
        private final byte[] cookieSecret;
        private final byte[] legacySecret;
        private final ReentrantLock t13ManagerLock = new ReentrantLock();

        T13HelloCookieManager(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            this.cookieVersion = secureRandom.nextInt();
            this.cookieSecret = new byte[64];
            this.legacySecret = new byte[64];
            secureRandom.nextBytes(this.cookieSecret);
            System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte[] createCookie(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello) {
            MessageDigest md;
            byte[] secret;
            int version;
            this.t13ManagerLock.lock();
            try {
                version = this.cookieVersion;
                secret = this.cookieSecret;
                if ((this.cookieVersion & 0xFFFFFF) == 0) {
                    System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 64);
                    this.secureRandom.nextBytes(this.cookieSecret);
                }
                ++this.cookieVersion;
            }
            finally {
                this.t13ManagerLock.unlock();
            }
            try {
                md = CryptoInsts.getMessageDigest((String)context.negotiatedCipherSuite.hashAlg.name);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("MessageDigest algorithm " + context.negotiatedCipherSuite.hashAlg.name + " is not available", nsae);
            }
            byte[] headerBytes = clientHello.getHeaderBytes();
            md.update(headerBytes);
            byte[] headerCookie = md.digest(secret);
            context.handshakeHash.update();
            byte[] clientHelloHash = context.handshakeHash.digest();
            byte[] prefix = new byte[]{(byte)(context.negotiatedCipherSuite.id >> 8 & 0xFF), (byte)(context.negotiatedCipherSuite.id & 0xFF), (byte)(version >> 24 & 0xFF)};
            byte[] cookie = Arrays.copyOf(prefix, prefix.length + headerCookie.length + clientHelloHash.length);
            System.arraycopy(headerCookie, 0, cookie, prefix.length, headerCookie.length);
            System.arraycopy(clientHelloHash, 0, cookie, prefix.length + headerCookie.length, clientHelloHash.length);
            return cookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean isCookieValid(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello, byte[] cookie) throws IOException {
            MessageDigest md;
            byte[] secret;
            if (cookie == null || cookie.length <= 32) {
                return false;
            }
            int csId = (cookie[0] & 0xFF) << 8 | cookie[1] & 0xFF;
            CipherSuite cs = CipherSuite.valueOf(csId);
            if (cs == null || cs.hashAlg == null || cs.hashAlg.hashLength == 0) {
                return false;
            }
            int hashLen = cs.hashAlg.hashLength;
            if (cookie.length != 3 + hashLen * 2) {
                return false;
            }
            byte[] prevHeadCookie = Arrays.copyOfRange(cookie, 3, 3 + hashLen);
            byte[] prevClientHelloHash = Arrays.copyOfRange(cookie, 3 + hashLen, cookie.length);
            this.t13ManagerLock.lock();
            try {
                secret = (byte)(this.cookieVersion >> 24 & 0xFF) == cookie[2] ? this.cookieSecret : this.legacySecret;
            }
            finally {
                this.t13ManagerLock.unlock();
            }
            try {
                md = CryptoInsts.getMessageDigest((String)cs.hashAlg.name);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("MessageDigest algorithm " + cs.hashAlg.name + " is not available", nsae);
            }
            byte[] headerBytes = clientHello.getHeaderBytes();
            md.update(headerBytes);
            byte[] headerCookie = md.digest(secret);
            if (!MessageDigest.isEqual(headerCookie, prevHeadCookie)) {
                return false;
            }
            byte[] hrrMessage = ServerHello.hrrReproducer.produce(context, clientHello);
            context.handshakeHash.push(hrrMessage);
            byte[] hashedClientHello = new byte[4 + hashLen];
            hashedClientHello[0] = SSLHandshake.MESSAGE_HASH.id;
            hashedClientHello[1] = 0;
            hashedClientHello[2] = 0;
            hashedClientHello[3] = (byte)(hashLen & 0xFF);
            System.arraycopy(prevClientHelloHash, 0, hashedClientHello, 4, hashLen);
            context.handshakeHash.push(hashedClientHello);
            return true;
        }
    }

    private static final class D13HelloCookieManager
    extends HelloCookieManager {
        D13HelloCookieManager(SecureRandom secureRandom) {
        }

        @Override
        byte[] createCookie(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        boolean isCookieValid(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello, byte[] cookie) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class D10HelloCookieManager
    extends HelloCookieManager {
        final SecureRandom secureRandom;
        private int cookieVersion;
        private final byte[] cookieSecret;
        private final byte[] legacySecret;
        private final ReentrantLock d10ManagerLock = new ReentrantLock();

        D10HelloCookieManager(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            this.cookieVersion = secureRandom.nextInt();
            this.cookieSecret = new byte[32];
            this.legacySecret = new byte[32];
            secureRandom.nextBytes(this.cookieSecret);
            System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 32);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte[] createCookie(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello) {
            MessageDigest md;
            byte[] secret;
            int version;
            this.d10ManagerLock.lock();
            try {
                version = this.cookieVersion;
                secret = this.cookieSecret;
                if ((this.cookieVersion & 0xFFFFFF) == 0) {
                    System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 32);
                    this.secureRandom.nextBytes(this.cookieSecret);
                }
                ++this.cookieVersion;
            }
            finally {
                this.d10ManagerLock.unlock();
            }
            try {
                md = CryptoInsts.getMessageDigest((String)"SHA-256");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("MessageDigest algorithm SHA-256 is not available", nsae);
            }
            byte[] helloBytes = clientHello.getHelloCookieBytes();
            md.update(helloBytes);
            byte[] cookie = md.digest(secret);
            cookie[0] = (byte)(version >> 24 & 0xFF);
            return cookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean isCookieValid(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello, byte[] cookie) {
            MessageDigest md;
            byte[] secret;
            if (cookie == null || cookie.length != 32) {
                return false;
            }
            this.d10ManagerLock.lock();
            try {
                secret = (this.cookieVersion >> 24 & 0xFF) == cookie[0] ? this.cookieSecret : this.legacySecret;
            }
            finally {
                this.d10ManagerLock.unlock();
            }
            try {
                md = CryptoInsts.getMessageDigest((String)"SHA-256");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("MessageDigest algorithm SHA-256 is not available", nsae);
            }
            byte[] helloBytes = clientHello.getHelloCookieBytes();
            md.update(helloBytes);
            byte[] target = md.digest(secret);
            target[0] = cookie[0];
            return MessageDigest.isEqual(target, cookie);
        }
    }

    static class Builder {
        final SecureRandom secureRandom;
        private volatile D10HelloCookieManager d10HelloCookieManager;
        private volatile D13HelloCookieManager d13HelloCookieManager;
        private volatile T13HelloCookieManager t13HelloCookieManager;
        private final ReentrantLock managerLock = new ReentrantLock();

        Builder(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HelloCookieManager valueOf(ProtocolVersion protocolVersion) {
            if (protocolVersion.isDTLS) {
                if (protocolVersion.useTLS13PlusSpec()) {
                    if (this.d13HelloCookieManager != null) {
                        return this.d13HelloCookieManager;
                    }
                    this.managerLock.lock();
                    try {
                        if (this.d13HelloCookieManager == null) {
                            this.d13HelloCookieManager = new D13HelloCookieManager(this.secureRandom);
                        }
                    }
                    finally {
                        this.managerLock.unlock();
                    }
                    return this.d13HelloCookieManager;
                }
                if (this.d10HelloCookieManager != null) {
                    return this.d10HelloCookieManager;
                }
                this.managerLock.lock();
                try {
                    if (this.d10HelloCookieManager == null) {
                        this.d10HelloCookieManager = new D10HelloCookieManager(this.secureRandom);
                    }
                }
                finally {
                    this.managerLock.unlock();
                }
                return this.d10HelloCookieManager;
            }
            if (protocolVersion.useTLS13PlusSpec()) {
                if (this.t13HelloCookieManager != null) {
                    return this.t13HelloCookieManager;
                }
                this.managerLock.lock();
                try {
                    if (this.t13HelloCookieManager == null) {
                        this.t13HelloCookieManager = new T13HelloCookieManager(this.secureRandom);
                    }
                }
                finally {
                    this.managerLock.unlock();
                }
                return this.t13HelloCookieManager;
            }
            return null;
        }
    }
}

