/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.DHKeyExchange;
import com.tencent.kona.sun.security.ssl.ECDHKeyExchange;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.JsseJce;
import com.tencent.kona.sun.security.ssl.NamedGroupPossession;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.util.CurveDB;
import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.crypto.spec.DHParameterSpec;

enum NamedGroup {
    SECT163_K1(1, "sect163k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect163k1")),
    SECT163_R1(2, "sect163r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect163r1")),
    SECT163_R2(3, "sect163r2", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect163r2")),
    SECT193_R1(4, "sect193r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect193r1")),
    SECT193_R2(5, "sect193r2", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect193r2")),
    SECT233_K1(6, "sect233k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect233k1")),
    SECT233_R1(7, "sect233r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect233r1")),
    SECT239_K1(8, "sect239k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect239k1")),
    SECT283_K1(9, "sect283k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect283k1")),
    SECT283_R1(10, "sect283r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect283r1")),
    SECT409_K1(11, "sect409k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect409k1")),
    SECT409_R1(12, "sect409r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect409r1")),
    SECT571_K1(13, "sect571k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect571k1")),
    SECT571_R1(14, "sect571r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"sect571r1")),
    SECP160_K1(15, "secp160k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp160k1")),
    SECP160_R1(16, "secp160r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp160r1")),
    SECP160_R2(17, "secp160r2", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp160r2")),
    SECP192_K1(18, "secp192k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp192k1")),
    SECP192_R1(19, "secp192r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp192r1")),
    SECP224_K1(20, "secp224k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp224k1")),
    SECP224_R1(21, "secp224r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp224r1")),
    SECP256_K1(22, "secp256k1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_12, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp256k1")),
    SECP256_R1(23, "secp256r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_13, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp256r1")),
    SECP384_R1(24, "secp384r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_13, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp384r1")),
    SECP521_R1(25, "secp521r1", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_TO_13, (AlgorithmParameterSpec)CurveDB.lookup((String)"secp521r1")),
    CURVESM2(41, "curvesm2", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.addTLCP(ProtocolVersion.PROTOCOLS_TO_13), (AlgorithmParameterSpec)CurveDB.lookup((String)"curvesm2")),
    SM2P256V1(249, "curvesm2", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_OF_TLCP, (AlgorithmParameterSpec)CurveDB.lookup((String)"curvesm2")),
    TA_SM2CURVE(0, "curvesm2", NamedGroupSpec.NAMED_GROUP_ECDHE, ProtocolVersion.PROTOCOLS_OF_TLCP, (AlgorithmParameterSpec)CurveDB.lookup((String)"curvesm2")),
    ARBITRARY_PRIME(65281, "arbitrary_explicit_prime_curves", NamedGroupSpec.NAMED_GROUP_ARBITRARY, ProtocolVersion.PROTOCOLS_TO_12, null),
    ARBITRARY_CHAR2(65282, "arbitrary_explicit_char2_curves", NamedGroupSpec.NAMED_GROUP_ARBITRARY, ProtocolVersion.PROTOCOLS_TO_12, null);

    final int id;
    final String name;
    final NamedGroupSpec spec;
    final ProtocolVersion[] supportedProtocols;
    final String algorithm;
    final AlgorithmParameterSpec keAlgParamSpec;
    final AlgorithmParameters keAlgParams;
    final boolean isAvailable;
    private static final Set<CryptoPrimitive> KEY_AGREEMENT_PRIMITIVE_SET;

    private NamedGroup(int id, String name, NamedGroupSpec namedGroupSpec, ProtocolVersion[] supportedProtocols, AlgorithmParameterSpec keAlgParamSpec) {
        boolean mediator;
        AlgorithmParameters algParams;
        block6: {
            this.id = id;
            this.name = name;
            this.spec = namedGroupSpec;
            this.algorithm = namedGroupSpec.algorithm;
            this.supportedProtocols = supportedProtocols;
            this.keAlgParamSpec = keAlgParamSpec;
            algParams = null;
            boolean bl = mediator = keAlgParamSpec != null;
            if (mediator && namedGroupSpec == NamedGroupSpec.NAMED_GROUP_ECDHE) {
                mediator = JsseJce.isEcAvailable();
            }
            if (mediator) {
                try {
                    algParams = CryptoInsts.getAlgorithmParameters((String)namedGroupSpec.algorithm);
                    algParams.init(keAlgParamSpec);
                }
                catch (NoSuchAlgorithmException | InvalidParameterSpecException exp) {
                    algParams = null;
                    try {
                        CryptoInsts.getKeyAgreement((String)name);
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        mediator = false;
                        if (!SSLLogger.isOn || !SSLLogger.isOn((String)"ssl,handshake")) break block6;
                        SSLLogger.warning((String)("No AlgorithmParameters for " + name), (Object[])new Object[]{nsae});
                    }
                }
            }
        }
        this.isAvailable = mediator;
        this.keAlgParams = mediator ? algParams : null;
    }

    static NamedGroup valueOf(int id) {
        for (NamedGroup group : NamedGroup.values()) {
            if (group.id != id) continue;
            return group;
        }
        return null;
    }

    static NamedGroup valueOf(ECParameterSpec params) {
        for (NamedGroup ng : NamedGroup.values()) {
            if (ng.spec != NamedGroupSpec.NAMED_GROUP_ECDHE || params != ng.keAlgParamSpec && ng.keAlgParamSpec != CurveDB.lookup((ECParameterSpec)params)) continue;
            return ng;
        }
        return null;
    }

    static NamedGroup valueOf(DHParameterSpec params) {
        for (NamedGroup ng : NamedGroup.values()) {
            DHParameterSpec ngParams;
            if (ng.spec != NamedGroupSpec.NAMED_GROUP_FFDHE || !(ngParams = (DHParameterSpec)ng.keAlgParamSpec).getP().equals(params.getP()) || !ngParams.getG().equals(params.getG())) continue;
            return ng;
        }
        return null;
    }

    static NamedGroup nameOf(String name) {
        for (NamedGroup group : NamedGroup.values()) {
            if (!group.name.equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    static String nameOf(int id) {
        for (NamedGroup group : NamedGroup.values()) {
            if (group.id != id) continue;
            return group.name;
        }
        return "UNDEFINED-NAMED-GROUP(" + id + ")";
    }

    boolean isAvailable(List<ProtocolVersion> protocolVersions) {
        if (this.isAvailable) {
            for (ProtocolVersion pv : this.supportedProtocols) {
                if (!protocolVersions.contains((Object)pv)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAvailable(ProtocolVersion protocolVersion) {
        if (this.isAvailable) {
            for (ProtocolVersion pv : this.supportedProtocols) {
                if (protocolVersion != pv) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSupported(List<CipherSuite> cipherSuites) {
        for (CipherSuite cs : cipherSuites) {
            boolean isMatch = this.isAvailable(cs.supportedProtocols);
            if (!isMatch || cs.keyExchange != null && !NamedGroupSpec.arrayContains(cs.keyExchange.groupTypes, this.spec)) continue;
            return true;
        }
        return false;
    }

    boolean isPermitted(AlgorithmConstraints constraints) {
        return constraints.permits(KEY_AGREEMENT_PRIMITIVE_SET, this.name, null) && constraints.permits(KEY_AGREEMENT_PRIMITIVE_SET, this.algorithm, this.keAlgParams);
    }

    byte[] encodePossessionPublicKey(NamedGroupPossession namedGroupPossession) {
        return this.spec.encodePossessionPublicKey(namedGroupPossession);
    }

    SSLCredentials decodeCredentials(byte[] encoded) throws IOException, GeneralSecurityException {
        return this.spec.decodeCredentials(this, encoded);
    }

    SSLPossession createPossession(SecureRandom random) {
        return this.spec.createPossession(this, random);
    }

    SSLKeyDerivation createKeyDerivation(HandshakeContext hc) throws IOException {
        return this.spec.createKeyDerivation(hc);
    }

    static {
        KEY_AGREEMENT_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT));
    }

    private static class ECDHEScheme
    implements NamedGroupScheme {
        private static final ECDHEScheme instance = new ECDHEScheme();

        private ECDHEScheme() {
        }

        @Override
        public byte[] encodePossessionPublicKey(NamedGroupPossession namedGroupPossession) {
            return ((ECDHKeyExchange.ECDHEPossession)namedGroupPossession).encode();
        }

        @Override
        public SSLCredentials decodeCredentials(NamedGroup ng, byte[] encoded) throws IOException, GeneralSecurityException {
            return ECDHKeyExchange.ECDHECredentials.valueOf(ng, encoded);
        }

        @Override
        public SSLPossession createPossession(NamedGroup ng, SecureRandom random) {
            return new ECDHKeyExchange.ECDHEPossession(ng, random);
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext hc) throws IOException {
            return ECDHKeyExchange.ecdheKAGenerator.createKeyDerivation(hc);
        }

        static /* synthetic */ ECDHEScheme access$100() {
            return instance;
        }
    }

    private static class FFDHEScheme
    implements NamedGroupScheme {
        private static final FFDHEScheme instance = new FFDHEScheme();

        private FFDHEScheme() {
        }

        @Override
        public byte[] encodePossessionPublicKey(NamedGroupPossession namedGroupPossession) {
            return namedGroupPossession.encode();
        }

        @Override
        public SSLCredentials decodeCredentials(NamedGroup ng, byte[] encoded) throws IOException, GeneralSecurityException {
            return DHKeyExchange.DHECredentials.valueOf(ng, encoded);
        }

        @Override
        public SSLPossession createPossession(NamedGroup ng, SecureRandom random) {
            return new DHKeyExchange.DHEPossession(ng, random);
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext hc) throws IOException {
            return DHKeyExchange.kaGenerator.createKeyDerivation(hc);
        }

        static /* synthetic */ FFDHEScheme access$200() {
            return instance;
        }
    }

    static enum NamedGroupSpec implements NamedGroupScheme
    {
        NAMED_GROUP_ECDHE("EC", ECDHEScheme.access$100()),
        NAMED_GROUP_FFDHE("DiffieHellman", FFDHEScheme.access$200()),
        NAMED_GROUP_ARBITRARY("EC", null),
        NAMED_GROUP_NONE("", null);

        private final String algorithm;
        private final NamedGroupScheme scheme;

        private NamedGroupSpec(String algorithm, NamedGroupScheme scheme) {
            this.algorithm = algorithm;
            this.scheme = scheme;
        }

        boolean isSupported(List<CipherSuite> cipherSuites) {
            for (CipherSuite cs : cipherSuites) {
                if (cs.keyExchange != null && !NamedGroupSpec.arrayContains(cs.keyExchange.groupTypes, this)) continue;
                return true;
            }
            return false;
        }

        static boolean arrayContains(NamedGroupSpec[] namedGroupTypes, NamedGroupSpec namedGroupType) {
            for (NamedGroupSpec ng : namedGroupTypes) {
                if (ng != namedGroupType) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte[] encodePossessionPublicKey(NamedGroupPossession namedGroupPossession) {
            if (this.scheme != null) {
                return this.scheme.encodePossessionPublicKey(namedGroupPossession);
            }
            return null;
        }

        @Override
        public SSLCredentials decodeCredentials(NamedGroup ng, byte[] encoded) throws IOException, GeneralSecurityException {
            if (this.scheme != null) {
                return this.scheme.decodeCredentials(ng, encoded);
            }
            return null;
        }

        @Override
        public SSLPossession createPossession(NamedGroup ng, SecureRandom random) {
            if (this.scheme != null) {
                return this.scheme.createPossession(ng, random);
            }
            return null;
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext hc) throws IOException {
            if (this.scheme != null) {
                return this.scheme.createKeyDerivation(hc);
            }
            return null;
        }
    }

    private static interface NamedGroupScheme {
        public byte[] encodePossessionPublicKey(NamedGroupPossession var1);

        public SSLCredentials decodeCredentials(NamedGroup var1, byte[] var2) throws IOException, GeneralSecurityException;

        public SSLPossession createPossession(NamedGroup var1, SecureRandom var2);

        public SSLKeyDerivation createKeyDerivation(HandshakeContext var1) throws IOException;
    }
}

