/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SM2KeyExchange;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLTrafficKeyDerivation;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;

final class SM2ClientKeyExchange {
    static final SSLConsumer sm2HandshakeConsumer = new SM2ClientKeyExchangeConsumer();
    static final HandshakeProducer sm2HandshakeProducer = new SM2ClientKeyExchangeProducer();

    SM2ClientKeyExchange() {
    }

    private static final class SM2ClientKeyExchangeConsumer
    implements SSLConsumer {
        private SM2ClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                break;
            }
            if (tlcpPossession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 possessions negotiated for client key exchange");
            }
            PrivateKey privateKey = tlcpPossession.popEncPrivateKey;
            if (!privateKey.getAlgorithm().equals("EC")) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not SM2 private key for client key exchange");
            }
            SM2ClientKeyExchangeMessage ckem = new SM2ClientKeyExchangeMessage(shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Consuming SM2 ClientKeyExchange handshake message", (Object[])new Object[]{ckem});
            }
            try {
                SM2KeyExchange.SM2PremasterSecret premaster = SM2KeyExchange.SM2PremasterSecret.decode(shc, privateKey, ckem.encrypted);
                shc.handshakeCredentials.add(premaster);
            }
            catch (GeneralSecurityException gse) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot decode SM2 premaster secret", gse);
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class SM2ClientKeyExchangeProducer
    implements HandshakeProducer {
        private SM2ClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            SM2ClientKeyExchangeMessage ckem;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials credential : chc.handshakeCredentials) {
                if (!(credential instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)credential;
                break;
            }
            if (tlcpCredentials == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for client key exchange");
            }
            ECPublicKey publicKey = (ECPublicKey)tlcpCredentials.popEncPublicKey;
            if (!publicKey.getAlgorithm().equals("EC") || publicKey.getParams() instanceof SM2ParameterSpec) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not SM2 public key for client key exchange");
            }
            try {
                SM2KeyExchange.SM2PremasterSecret premaster = SM2KeyExchange.SM2PremasterSecret.createPremasterSecret(chc);
                chc.handshakePossessions.add(premaster);
                ckem = new SM2ClientKeyExchangeMessage(chc, premaster, publicKey);
            }
            catch (GeneralSecurityException gse) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot generate SM2 premaster secret", gse);
            }
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced SM2 ClientKeyExchange handshake message", (Object[])new Object[]{ckem});
            }
            ckem.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class SM2ClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        final int protocolVersion;
        final byte[] encrypted;

        SM2ClientKeyExchangeMessage(HandshakeContext context, SM2KeyExchange.SM2PremasterSecret premaster, PublicKey publicKey) throws GeneralSecurityException {
            super(context);
            this.protocolVersion = context.clientHelloVersion;
            this.encrypted = premaster.getEncoded(publicKey, context.sslContext.getSecureRandom());
        }

        SM2ClientKeyExchangeMessage(HandshakeContext context, ByteBuffer m) throws IOException {
            super(context);
            if (m.remaining() < 2) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ClientKeyExchange message: insufficient data");
            }
            this.protocolVersion = context.clientHelloVersion;
            this.encrypted = Record.getBytes16(m);
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            return this.encrypted.length + 2;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putBytes16(this.encrypted);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"SM2 ClientKeyExchange\": '{'\n  \"client_version\":  {0}\n  \"encncrypted\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{ProtocolVersion.nameOf(this.protocolVersion), Utilities.indent((String)hexEncoder.encodeBuffer(this.encrypted), (String)"    ")};
            return messageFormat.format(messageFields);
        }
    }
}

