/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.spec.SM2SignatureParameterSpec;
import com.tencent.kona.crypto.util.Constants;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.RSASignature;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SM2EKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.SupportedGroupsExtension;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class SM2EServerKeyExchange {
    static final SSLConsumer sm2eHandshakeConsumer = new SM2EServerKeyExchangeConsumer();
    static final HandshakeProducer sm2eHandshakeProducer = new SM2EServerKeyExchangeProducer();

    private static final class SM2EServerKeyExchangeConsumer
    implements SSLConsumer {
        private SM2EServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SM2EServerKeyExchangeMessage skem = new SM2EServerKeyExchangeMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Consuming SM2 ServerKeyExchange handshake message", (Object[])new Object[]{skem});
            }
            chc.handshakeCredentials.add(skem.sslCredentials);
        }
    }

    private static final class SM2EServerKeyExchangeProducer
    implements HandshakeProducer {
        private SM2EServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SM2EServerKeyExchangeMessage skem = new SM2EServerKeyExchangeMessage(shc);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced SM2 ServerKeyExchange handshake message", (Object[])new Object[]{skem});
            }
            skem.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class SM2EServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final NamedGroup namedGroup;
        private final byte[] publicPoint;
        private final byte[] paramsSignature;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;
        private SSLCredentials sslCredentials;

        SM2EServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            byte[] signature;
            Signature signer;
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            SM2EKeyExchange.SM2EPossession sm2ePossession = null;
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (possession instanceof SM2EKeyExchange.SM2EPossession) {
                    sm2ePossession = (SM2EKeyExchange.SM2EPossession)possession;
                    if (tlcpPossession == null) continue;
                    break;
                }
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                if (sm2ePossession == null) continue;
                break;
            }
            if (sm2ePossession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No SM2 credentials negotiated for server key exchange");
            }
            ECParameterSpec params = sm2ePossession.popEncPublicKey.getParams();
            NamedGroup namedGroup = this.namedGroup = params != null ? NamedGroup.valueOf(params) : null;
            if (this.namedGroup == null || !this.namedGroup.isAvailable || this.namedGroup != NamedGroup.CURVESM2) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing or improper named group: " + (Object)((Object)this.namedGroup));
            }
            ECPoint ecPoint = sm2ePossession.popEncPublicKey.getW();
            if (ecPoint == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing public point for named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = CryptoUtils.pubKey((ECPoint)sm2ePossession.ephemeralPublicKey.getW());
            this.useExplicitSigAlgorithm = shc.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                Map.Entry<SignatureScheme, Signature> schemeAndSigner = SignatureScheme.getSignerOfPreferableAlgorithm(shc.algorithmConstraints, shc.peerRequestedSignatureSchemes, sm2ePossession.popEncPrivateKey, tlcpPossession.popSignPublicKey, sm2ePossession.popEncPublicKey.getParams(), shc.negotiatedProtocol);
                if (schemeAndSigner == null) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + sm2ePossession.popEncPrivateKey.getAlgorithm() + "  key");
                }
                this.signatureScheme = schemeAndSigner.getKey();
                signer = schemeAndSigner.getValue();
            } else {
                this.signatureScheme = null;
                try {
                    signer = CryptoInsts.getSignature((String)SignatureScheme.SM2SIG_SM3.algorithm);
                    signer.setParameter((AlgorithmParameterSpec)new SM2SignatureParameterSpec(Constants.defaultId(), (ECPublicKey)tlcpPossession.popSignPublicKey));
                    signer.initSign(tlcpPossession.popSignPrivateKey);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + sm2ePossession.popEncPrivateKey.getAlgorithm(), e);
                }
            }
            try {
                SM2EServerKeyExchangeMessage.updateSignature(signer, shc.clientHelloRandom.randomBytes, shc.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                signature = signer.sign();
            }
            catch (SignatureException ex) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ecdhe parameters: " + sm2ePossession.popEncPrivateKey.getAlgorithm(), ex);
            }
            this.paramsSignature = signature;
        }

        SM2EServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            Signature signer;
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            byte curveType = (byte)Record.getInt8(m);
            if (curveType != 3) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported ECCurveType: " + curveType);
            }
            int namedGroupId = Record.getInt16(m);
            this.namedGroup = NamedGroup.valueOf(namedGroupId);
            if (this.namedGroup == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unknown named group ID: " + namedGroupId);
            }
            if (!SupportedGroupsExtension.SupportedGroups.isSupported(this.namedGroup)) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = Record.getBytes8(m);
            if (this.publicPoint.length == 0) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Insufficient Point data: " + (Object)((Object)this.namedGroup));
            }
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)cd;
                break;
            }
            this.sslCredentials = new SM2EKeyExchange.SM2ECredentials((ECPublicKey)new SM2PublicKey(this.publicPoint), this.namedGroup);
            if (tlcpCredentials == null) {
                if (m.hasRemaining()) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.signatureScheme = null;
                this.paramsSignature = null;
                this.useExplicitSigAlgorithm = false;
                return;
            }
            this.useExplicitSigAlgorithm = chc.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                int ssid = Record.getInt16(m);
                this.signatureScheme = SignatureScheme.valueOf(ssid);
                if (this.signatureScheme == null) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + ssid + ") used in SM2 ServerKeyExchange handshake message");
                }
                if (!chc.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in SM2 ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(m);
            if (this.useExplicitSigAlgorithm) {
                try {
                    signer = this.signatureScheme.getVerifier(tlcpCredentials.popSignPublicKey);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException nsae) {
                    throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + this.signatureScheme.name, nsae);
                }
            }
            try {
                signer = CryptoInsts.getSignature((String)SignatureScheme.SM2SIG_SM3.algorithm);
                signer.setParameter((AlgorithmParameterSpec)new SM2SignatureParameterSpec(Constants.defaultId(), (ECPublicKey)tlcpCredentials.popSignPublicKey));
                signer.initVerify(tlcpCredentials.popSignPublicKey);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + tlcpCredentials.popSignPublicKey.getAlgorithm(), e);
            }
            try {
                SM2EServerKeyExchangeMessage.updateSignature(signer, chc.clientHelloRandom.randomBytes, chc.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                if (!signer.verify(this.paramsSignature)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid SM2 ServerKeyExchange signature");
                }
            }
            catch (SignatureException ex) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify SM2 ServerKeyExchange signature", ex);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int sigLen = 0;
            if (this.paramsSignature != null) {
                sigLen = 2 + this.paramsSignature.length;
                if (this.useExplicitSigAlgorithm) {
                    sigLen += SignatureScheme.sizeInRecord();
                }
            }
            return 4 + this.publicPoint.length + sigLen;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putInt8(3);
            hos.putInt16(this.namedGroup.id);
            hos.putBytes8(this.publicPoint);
            if (this.paramsSignature != null) {
                if (this.useExplicitSigAlgorithm) {
                    hos.putInt16(this.signatureScheme.id);
                }
                hos.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{2}\"\n    \"signature\": '{'\n{3}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent((String)hexEncoder.encodeBuffer(this.publicPoint), (String)"      "), this.signatureScheme.name, Utilities.indent((String)hexEncoder.encodeBuffer(this.paramsSignature), (String)"      ")};
                return messageFormat.format(messageFields);
            }
            if (this.paramsSignature != null) {
                MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"signature\": '{'\n{2}\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent((String)hexEncoder.encodeBuffer(this.publicPoint), (String)"      "), Utilities.indent((String)hexEncoder.encodeBuffer(this.paramsSignature), (String)"    ")};
                return messageFormat.format(messageFields);
            }
            MessageFormat messageFormat = new MessageFormat("\"SM2 ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent((String)hexEncoder.encodeBuffer(this.publicPoint), (String)"      ")};
            return messageFormat.format(messageFields);
        }

        private static Signature getSignature(String keyAlgorithm, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
            Signature signer;
            switch (keyAlgorithm) {
                case "EC": {
                    signer = CryptoInsts.getSignature((String)"SHA1withECDSA");
                    break;
                }
                case "EdDSA": {
                    signer = CryptoInsts.getSignature((String)"EdDSA");
                    break;
                }
                case "RSA": {
                    signer = RSASignature.getInstance();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("neither an RSA or a EC key : " + keyAlgorithm);
                }
            }
            if (signer != null) {
                if (key instanceof PublicKey) {
                    signer.initVerify((PublicKey)key);
                } else {
                    signer.initSign((PrivateKey)key);
                }
            }
            return signer;
        }

        private static void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce, int namedGroupId, byte[] publicPoint) throws SignatureException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            sig.update((byte)3);
            sig.update((byte)(namedGroupId >> 8 & 0xFF));
            sig.update((byte)(namedGroupId & 0xFF));
            sig.update((byte)publicPoint.length);
            sig.update(publicPoint);
        }
    }
}

