/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.ssl.SSLInsts;
import com.tencent.kona.sun.security.internal.spec.TlcpSM2PremasterSecretParameterSpec;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLKeyAgreementGenerator;
import com.tencent.kona.sun.security.ssl.SSLKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLMasterKeyDerivation;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLPossessionGenerator;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.util.KeyUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;

final class SM2KeyExchange {
    static final SSLPossessionGenerator sm2PoGenerator = new SM2PossessionGenerator();
    static final SSLKeyAgreementGenerator sm2KAGenerator = new SM2KAGenerator();

    SM2KeyExchange() {
    }

    private static final class SM2KAGenerator
    implements SSLKeyAgreementGenerator {
        private SM2KAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            SM2PremasterSecret premaster = null;
            if (context instanceof ClientHandshakeContext) {
                for (SSLPossession possession : context.handshakePossessions) {
                    if (!(possession instanceof SM2PremasterSecret)) continue;
                    premaster = (SM2PremasterSecret)possession;
                    break;
                }
            } else {
                for (SSLCredentials credential : context.handshakeCredentials) {
                    if (!(credential instanceof SM2PremasterSecret)) continue;
                    premaster = (SM2PremasterSecret)credential;
                    break;
                }
            }
            if (premaster == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient SM2 key agreement parameters negotiated");
            }
            return new SM2KAKeyDerivation(context, premaster.premasterSecret);
        }

        private static final class SM2KAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final SecretKey preMasterSecret;

            SM2KAKeyDerivation(HandshakeContext context, SecretKey preMasterSecret) {
                this.context = context;
                this.preMasterSecret = preMasterSecret;
            }

            @Override
            public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
                SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (mskd == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, this.preMasterSecret);
                return kd.deriveKey("MasterSecret", params);
            }
        }
    }

    static final class SM2PremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final SecretKey premasterSecret;

        SM2PremasterSecret(SecretKey premasterSecret) {
            this.premasterSecret = premasterSecret;
        }

        byte[] getEncoded(PublicKey publicKey, SecureRandom secureRandom) throws GeneralSecurityException {
            Cipher cipher = CryptoInsts.getCipher((String)"SM2");
            cipher.init(3, (Key)publicKey, secureRandom);
            return cipher.wrap(this.premasterSecret);
        }

        static SM2PremasterSecret createPremasterSecret(ClientHandshakeContext chc) throws GeneralSecurityException {
            String algorithm = "TlcpSM2PremasterSecret";
            KeyGenerator kg = SSLInsts.getKeyGenerator(algorithm);
            TlcpSM2PremasterSecretParameterSpec spec = new TlcpSM2PremasterSecretParameterSpec(chc.clientHelloVersion, chc.negotiatedProtocol.id);
            kg.init(spec, chc.sslContext.getSecureRandom());
            return new SM2PremasterSecret(kg.generateKey());
        }

        static SM2PremasterSecret decode(ServerHandshakeContext shc, PrivateKey privateKey, byte[] encrypted) throws GeneralSecurityException {
            SecretKey preMaster;
            byte[] encoded = null;
            boolean needFailover = false;
            Cipher cipher = CryptoInsts.getCipher((String)"SM2");
            try {
                cipher.init(4, (Key)privateKey, new TlcpSM2PremasterSecretParameterSpec(shc.clientHelloVersion, shc.negotiatedProtocol.id), shc.sslContext.getSecureRandom());
            }
            catch (UnsupportedOperationException | InvalidKeyException iue) {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.warning((String)("The Cipher provider " + SM2PremasterSecret.safeProviderName(cipher) + " caused exception: " + iue.getMessage()), (Object[])new Object[0]);
                }
                needFailover = true;
            }
            if (needFailover) {
                cipher = CryptoInsts.getCipher((String)"SM2");
                cipher.init(2, privateKey);
                boolean failed = false;
                try {
                    encoded = cipher.doFinal(encrypted);
                }
                catch (BadPaddingException bpe) {
                    failed = true;
                }
                encoded = KeyUtil.checkTlsPreMasterSecretKey((int)shc.clientHelloVersion, (int)shc.negotiatedProtocol.id, (SecureRandom)shc.sslContext.getSecureRandom(), (byte[])encoded, (boolean)failed);
                preMaster = SM2PremasterSecret.generatePremasterSecret(shc.clientHelloVersion, shc.negotiatedProtocol.id, encoded, shc.sslContext.getSecureRandom());
            } else {
                preMaster = (SecretKey)cipher.unwrap(encrypted, "TlcpSM2PremasterSecret", 3);
            }
            return new SM2PremasterSecret(preMaster);
        }

        private static String safeProviderName(Cipher cipher) {
            try {
                return cipher.getProvider().toString();
            }
            catch (Exception e) {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.fine((String)"Retrieving The Cipher provider name caused exception ", (Object[])new Object[]{e});
                }
                try {
                    return ((Object)cipher).toString() + " (provider name not available)";
                }
                catch (Exception e2) {
                    if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                        SSLLogger.fine((String)"Retrieving The Cipher name caused exception ", (Object[])new Object[]{e2});
                    }
                    return "(cipher/provider names not available)";
                }
            }
        }

        private static SecretKey generatePremasterSecret(int clientVersion, int serverVersion, byte[] encodedSecret, SecureRandom generator) throws GeneralSecurityException {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Generating a premaster secret", (Object[])new Object[0]);
            }
            try {
                String s = clientVersion == ProtocolVersion.TLCP11.id ? "Tlcp11PremasterSecret" : (clientVersion >= ProtocolVersion.TLS12.id ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret");
                KeyGenerator kg = CryptoInsts.getKeyGenerator((String)s);
                kg.init(new TlcpSM2PremasterSecretParameterSpec(clientVersion, serverVersion, encodedSecret), generator);
                return kg.generateKey();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException iae) {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.fine((String)"ECC premaster secret generation error:", (Object[])new Object[0]);
                    iae.printStackTrace(System.out);
                }
                throw new GeneralSecurityException("Could not generate premaster secret", iae);
            }
        }
    }

    private static final class SM2PossessionGenerator
    implements SSLPossessionGenerator {
        private SM2PossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            return null;
        }
    }
}

