/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.action.GetLongAction;
import com.tencent.kona.sun.security.ssl.CertificateMessage;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.SSLAlgorithmDecomposer;
import com.tencent.kona.sun.security.ssl.SSLContextImpl;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.StatusResponseManager;
import com.tencent.kona.sun.security.ssl.TransportContext;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.AlgorithmDecomposer;
import com.tencent.kona.sun.security.util.LegacyAlgorithmConstraints;
import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmConstraints;

class ServerHandshakeContext
extends HandshakeContext {
    static final boolean rejectClientInitiatedRenego = Utilities.getBooleanProperty((String)"com.tencent.kona.ssl.rejectClientInitiatedRenegotiation", (boolean)false);
    static final AlgorithmConstraints legacyAlgorithmConstraints = new LegacyAlgorithmConstraints("jdk.tls.legacyAlgorithms", (AlgorithmDecomposer)new SSLAlgorithmDecomposer());
    SSLPossession interimAuthn;
    StatusResponseManager.StaplingParameters stapleParams;
    CertificateMessage.CertificateEntry currentCertEntry;
    private static final long DEFAULT_STATUS_RESP_DELAY = 5000L;
    final long statusRespTimeout;

    ServerHandshakeContext(SSLContextImpl sslContext, TransportContext conContext) throws IOException {
        super(sslContext, conContext);
        long respTimeOut = (Long)AccessController.doPrivileged(new GetLongAction("com.tencent.kona.ssl.stapling.responseTimeout", 5000L));
        this.statusRespTimeout = respTimeOut >= 0L ? respTimeOut : 5000L;
        this.handshakeConsumers.put(SSLHandshake.CLIENT_HELLO.id, SSLHandshake.CLIENT_HELLO);
    }

    @Override
    void kickstart() throws IOException {
        if (!this.conContext.isNegotiated || this.kickstartMessageDelivered) {
            return;
        }
        SSLHandshake.kickstart(this);
        this.kickstartMessageDelivered = true;
    }
}

