/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.pkix.PKIXUtils;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NamedGroup;
import com.tencent.kona.sun.security.ssl.SSLAuthentication;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.SupportedGroupsExtension;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.X509ExtendedKeyManager;

final class TLCPAuthentication
implements SSLAuthentication {
    static final TLCPAuthentication SM2 = new TLCPAuthentication("EC", "EC");
    static final TLCPAuthentication SM2E = new TLCPAuthentication("EC", "EC");
    final String keyAlgorithm;
    final String[] keyTypes;

    TLCPAuthentication(String keyAlgorithm, String ... keyTypes) {
        this.keyAlgorithm = keyAlgorithm;
        this.keyTypes = keyTypes;
    }

    static TLCPAuthentication valueOf(SignatureScheme signatureScheme) {
        if (signatureScheme == SignatureScheme.SM2SIG_SM3) {
            return SM2;
        }
        return null;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return TLCPAuthentication.createPossession(handshakeContext, this.keyTypes);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        if (handshakeContext.negotiatedProtocol.isTLCP11()) {
            return new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_REQUEST};
        }
        return new SSLHandshake[0];
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        if (handshakeContext.negotiatedProtocol.isTLCP11()) {
            return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLHandshake>(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE)};
        }
        return new Map.Entry[0];
    }

    public static SSLPossession createPossession(HandshakeContext context, String[] keyTypes) {
        if (context.sslConfig.isClientMode) {
            return TLCPAuthentication.createClientPossession((ClientHandshakeContext)context, keyTypes);
        }
        return TLCPAuthentication.createServerPossession((ServerHandshakeContext)context, keyTypes);
    }

    private static SSLPossession createClientPossession(ClientHandshakeContext chc, String[] keyTypes) {
        X509ExtendedKeyManager km = chc.sslContext.getX509KeyManager();
        for (String keyType : keyTypes) {
            TLCPPossession tlcpPossession;
            String[] clientAliases = km.getClientAliases(keyType, chc.peerSupportedAuthorities == null ? null : (Principal[])chc.peerSupportedAuthorities.clone());
            if (clientAliases == null || clientAliases.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                    SSLLogger.finest((String)("No X.509 cert selected for " + Arrays.toString(keyTypes)), (Object[])new Object[0]);
                }
                return null;
            }
            PossessionEntry signPossEntry = null;
            PossessionEntry encPossEntry = null;
            for (String clientAlias : clientAliases) {
                PossessionEntry bufPossEntry = TLCPAuthentication.clientPossEntry(chc, keyType, km, clientAlias);
                if (bufPossEntry == null) continue;
                if (signPossEntry == null && PKIXUtils.isSignCert((X509Certificate)bufPossEntry.popCert)) {
                    signPossEntry = bufPossEntry;
                    continue;
                }
                if (!PKIXUtils.isEncCert((X509Certificate)bufPossEntry.popCert)) continue;
                encPossEntry = bufPossEntry;
                break;
            }
            if ((tlcpPossession = TLCPAuthentication.createPossession(signPossEntry, encPossEntry)) == null) continue;
            return tlcpPossession;
        }
        return null;
    }

    private static PossessionEntry clientPossEntry(ClientHandshakeContext chc, String keyType, X509ExtendedKeyManager km, String clientAlias) {
        PrivateKey clientPrivateKey = km.getPrivateKey(clientAlias);
        if (clientPrivateKey == null) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.finest((String)(clientAlias + " is not a private key entry"), (Object[])new Object[0]);
            }
            return null;
        }
        X509Certificate[] clientCerts = km.getCertificateChain(clientAlias);
        if (clientCerts == null || clientCerts.length == 0) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.finest((String)(clientAlias + " is a private key entry with no cert chain stored"), (Object[])new Object[0]);
            }
            return null;
        }
        String privateKeyAlgorithm = clientPrivateKey.getAlgorithm();
        if (!Arrays.asList(keyType).contains(privateKeyAlgorithm)) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.fine((String)(clientAlias + " private key algorithm " + privateKeyAlgorithm + " not in request list"), (Object[])new Object[0]);
            }
            return null;
        }
        PublicKey clientPublicKey = clientCerts[0].getPublicKey();
        String publicKeyAlgorithm = clientPublicKey.getAlgorithm();
        if (!privateKeyAlgorithm.equals(publicKeyAlgorithm)) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.fine((String)(clientAlias + " private or public key is not of same algorithm: " + privateKeyAlgorithm + " vs " + publicKeyAlgorithm), (Object[])new Object[0]);
            }
            return null;
        }
        if (!TLCPAuthentication.checkPublicKey(clientAlias, clientPublicKey, chc)) {
            return null;
        }
        return new PossessionEntry(clientPrivateKey, clientCerts);
    }

    private static SSLPossession createServerPossession(ServerHandshakeContext shc, String[] keyTypes) {
        X509ExtendedKeyManager km = shc.sslContext.getX509KeyManager();
        for (String keyType : keyTypes) {
            TLCPPossession tlcpPossession;
            String[] serverAliases = km.getServerAliases(keyType, shc.peerSupportedAuthorities == null ? null : (Principal[])shc.peerSupportedAuthorities.clone());
            if (serverAliases == null || serverAliases.length == 0) {
                if (!SSLLogger.isOn || !SSLLogger.isOn((String)"ssl")) continue;
                SSLLogger.finest((String)("No X.509 cert selected for " + keyType), (Object[])new Object[0]);
                continue;
            }
            PossessionEntry signPossEntry = null;
            PossessionEntry encPossEntry = null;
            for (String serverAlias : serverAliases) {
                PossessionEntry bufPossEntry = TLCPAuthentication.serverPossEntry(shc, keyType, km, serverAlias);
                if (bufPossEntry == null) continue;
                if (signPossEntry == null && PKIXUtils.isSignCert((X509Certificate)bufPossEntry.popCert)) {
                    signPossEntry = bufPossEntry;
                    continue;
                }
                if (!PKIXUtils.isEncCert((X509Certificate)bufPossEntry.popCert)) continue;
                encPossEntry = bufPossEntry;
                break;
            }
            if ((tlcpPossession = TLCPAuthentication.createPossession(signPossEntry, encPossEntry)) == null) continue;
            return tlcpPossession;
        }
        return null;
    }

    private static TLCPPossession createPossession(PossessionEntry signPossEntry, PossessionEntry encPossEntry) {
        if (signPossEntry == null) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.warning((String)"No X.509 sign cert selected", (Object[])new Object[0]);
            }
            return null;
        }
        if (encPossEntry == null && PKIXUtils.isEncCert((X509Certificate)signPossEntry.popCert)) {
            encPossEntry = signPossEntry;
        }
        if (encPossEntry == null) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.warning((String)"No X.509 enc cert selected", (Object[])new Object[0]);
            }
            return null;
        }
        return new TLCPPossession(signPossEntry, encPossEntry);
    }

    private static PossessionEntry serverPossEntry(ServerHandshakeContext shc, String keyType, X509ExtendedKeyManager km, String serverAlias) {
        PrivateKey serverPrivateKey = km.getPrivateKey(serverAlias);
        if (serverPrivateKey == null) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.finest((String)(serverAlias + " is not a private key entry"), (Object[])new Object[0]);
            }
            return null;
        }
        X509Certificate[] serverCerts = km.getCertificateChain(serverAlias);
        if (serverCerts == null || serverCerts.length == 0) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.finest((String)(serverAlias + " is not a certificate entry"), (Object[])new Object[0]);
            }
            return null;
        }
        PublicKey serverPublicKey = serverCerts[0].getPublicKey();
        if (!serverPrivateKey.getAlgorithm().equals(keyType) || !serverPublicKey.getAlgorithm().equals(keyType)) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.fine((String)(serverAlias + " private or public key is not of " + keyType + " algorithm"), (Object[])new Object[0]);
            }
            return null;
        }
        if (!shc.negotiatedProtocol.useTLS13PlusSpec() && keyType.equals("EC") && !TLCPAuthentication.checkPublicKey(serverAlias, serverPublicKey, shc)) {
            return null;
        }
        return new PossessionEntry(serverPrivateKey, serverCerts);
    }

    private static boolean checkPublicKey(String alias, PublicKey publicKey, HandshakeContext hc) {
        if (!(publicKey instanceof ECPublicKey)) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.warning((String)(alias + " public key is not an instance of ECPublicKey"), (Object[])new Object[0]);
            }
            return false;
        }
        ECParameterSpec params = ((ECPublicKey)publicKey).getParams();
        NamedGroup namedGroup = NamedGroup.valueOf(params);
        if (namedGroup != NamedGroup.CURVESM2 || !SupportedGroupsExtension.SupportedGroups.isSupported(namedGroup) || hc.clientRequestedNamedGroups != null && !hc.clientRequestedNamedGroups.contains((Object)namedGroup)) {
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl")) {
                SSLLogger.warning((String)("Unsupported named group (" + (Object)((Object)namedGroup) + ") used in the " + alias + " certificate"), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    static final class TLCPCredentials
    implements SSLCredentials {
        final PublicKey popSignPublicKey;
        final X509Certificate[] popSignCerts;
        final X509Certificate popSignCert;
        final PublicKey popEncPublicKey;
        final X509Certificate[] popEncCerts;
        final X509Certificate popEncCert;

        TLCPCredentials(PublicKey popSignPublicKey, X509Certificate[] popSignCerts, PublicKey popEncPublicKey, X509Certificate[] popEncCerts) {
            this.popSignPublicKey = popSignPublicKey;
            this.popSignCerts = popSignCerts;
            this.popSignCert = popSignCerts[0];
            this.popEncPublicKey = popEncPublicKey;
            this.popEncCerts = popEncCerts;
            this.popEncCert = popEncCerts[0];
        }
    }

    static final class PossessionEntry {
        final PrivateKey popPrivateKey;
        final X509Certificate[] popCerts;
        final X509Certificate popCert;
        final PublicKey popPublicKey;

        PossessionEntry(PrivateKey popPrivateKey, X509Certificate[] popCerts) {
            this.popPrivateKey = popPrivateKey;
            this.popCerts = popCerts;
            this.popCert = popCerts[0];
            this.popPublicKey = this.popCert.getPublicKey();
        }
    }

    static final class TLCPPossession
    implements SSLPossession {
        final PrivateKey popSignPrivateKey;
        final X509Certificate[] popSignCerts;
        final X509Certificate popSignCert;
        final PublicKey popSignPublicKey;
        final PrivateKey popEncPrivateKey;
        final X509Certificate[] popEncCerts;
        final X509Certificate popEncCert;
        final PublicKey popEncPublicKey;

        TLCPPossession(PrivateKey popSignPrivateKey, X509Certificate[] popSignCerts, PrivateKey popEncPrivateKey, X509Certificate[] popEncCerts) {
            this.popSignPrivateKey = popSignPrivateKey;
            this.popSignCerts = popSignCerts;
            if (popSignCerts != null && popSignCerts.length > 0) {
                this.popSignCert = popSignCerts[0];
                this.popSignPublicKey = this.popSignCert.getPublicKey();
            } else {
                this.popSignCert = null;
                this.popSignPublicKey = null;
            }
            this.popEncPrivateKey = popEncPrivateKey;
            this.popEncCerts = popEncCerts;
            if (popEncCerts != null && popEncCerts.length > 0) {
                this.popEncCert = popEncCerts[0];
                this.popEncPublicKey = this.popEncCert.getPublicKey();
            } else {
                this.popEncCert = null;
                this.popEncPublicKey = null;
            }
        }

        TLCPPossession(PossessionEntry signPossEntry, PossessionEntry encPossEntry) {
            this.popSignPrivateKey = signPossEntry.popPrivateKey;
            this.popSignCerts = signPossEntry.popCerts;
            this.popSignCert = signPossEntry.popCert;
            this.popSignPublicKey = signPossEntry.popPublicKey;
            this.popEncPrivateKey = encPossEntry.popPrivateKey;
            this.popEncCerts = encPossEntry.popCerts;
            this.popEncCert = encPossEntry.popCert;
            this.popEncPublicKey = encPossEntry.popPublicKey;
        }

        ECParameterSpec getECParameterSpec() {
            return this.getECParameterSpec(this.popSignPrivateKey, this.popSignCerts);
        }

        ECParameterSpec getECParameterSpec(PrivateKey popPrivateKey, X509Certificate[] popCerts) {
            PublicKey publicKey;
            if (popPrivateKey == null || !"EC".equals(popPrivateKey.getAlgorithm())) {
                return null;
            }
            if (popPrivateKey instanceof ECKey) {
                return ((ECKey)((Object)popPrivateKey)).getParams();
            }
            if (popCerts != null && popCerts.length != 0 && (publicKey = popCerts[0].getPublicKey()) instanceof ECKey) {
                return ((ECKey)((Object)publicKey)).getParams();
            }
            return null;
        }
    }
}

