/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Authenticator;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;

final class TLCPAuthenticator {
    TLCPAuthenticator() {
    }

    static final long toLong(byte[] recordEnS) {
        if (recordEnS != null && recordEnS.length == 8) {
            return ((long)recordEnS[0] & 0xFFL) << 56 | ((long)recordEnS[1] & 0xFFL) << 48 | ((long)recordEnS[2] & 0xFFL) << 40 | ((long)recordEnS[3] & 0xFFL) << 32 | ((long)recordEnS[4] & 0xFFL) << 24 | ((long)recordEnS[5] & 0xFFL) << 16 | ((long)recordEnS[6] & 0xFFL) << 8 | (long)recordEnS[7] & 0xFFL;
        }
        return -1L;
    }

    static final class TLCP11Mac
    extends TLCP11Authenticator
    implements Authenticator.MAC {
        private final Authenticator.MacImpl macImpl;

        TLCP11Mac(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
            super(protocolVersion);
            this.macImpl = new Authenticator.MacImpl(this, protocolVersion, macAlg, key);
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte type, ByteBuffer bb, byte[] sequence, boolean isSimulated) {
            return this.macImpl.compute(type, bb, sequence, isSimulated);
        }
    }

    static class TLCP11Authenticator
    extends Authenticator.SSLAuthenticator {
        private static final int BLOCK_SIZE = 13;

        TLCP11Authenticator(ProtocolVersion protocolVersion) {
            super(new byte[13]);
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        }

        @Override
        byte[] acquireAuthenticationBytes(byte type, int length, byte[] sequence) {
            byte[] ad = (byte[])this.block.clone();
            if (sequence != null) {
                if (sequence.length != 8) {
                    throw new RuntimeException("Insufficient explicit sequence number bytes");
                }
                System.arraycopy(sequence, 0, ad, 0, sequence.length);
            } else {
                this.increaseSequenceNumber();
            }
            ad[8] = type;
            ad[11] = (byte)(length >> 8);
            ad[12] = (byte)length;
            return ad;
        }
    }
}

