/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.pkix.PKIXInsts;
import com.tencent.kona.pkix.PKIXUtils;
import com.tencent.kona.ssl.SSLUtils;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ClientAuthType;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConfiguration;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

final class TLCPCertificate {
    static final SSLConsumer tlcpHandshakeConsumer = new TLCPCertificateConsumer();
    static final HandshakeProducer tlcpHandshakeProducer = new TLCPCertificateProducer();
    static final CertListFormat DEF_CERT_LIST_FORMAT = CertListFormat.format(SSLUtils.getPropCertListFormat());

    TLCPCertificate() {
    }

    private static X509Certificate[] mergeCertChains(X509Certificate[] signCertChain, X509Certificate[] encCertChain) {
        if (signCertChain == null || signCertChain.length == 0 || encCertChain == null || encCertChain.length == 0) {
            return new X509Certificate[0];
        }
        X509Certificate[] mergedCerts = new X509Certificate[signCertChain.length + 1];
        if (DEF_CERT_LIST_FORMAT == CertListFormat.SIGN_CA_ENC) {
            System.arraycopy(signCertChain, 0, mergedCerts, 0, signCertChain.length);
            mergedCerts[mergedCerts.length - 1] = encCertChain[0];
        } else {
            mergedCerts[0] = signCertChain[0];
            mergedCerts[1] = encCertChain[0];
            if (signCertChain.length > 1) {
                System.arraycopy(signCertChain, 1, mergedCerts, 2, signCertChain.length - 1);
            }
        }
        return mergedCerts;
    }

    static final class TLCPCertificateConsumer
    implements SSLConsumer {
        TLCPCertificateConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            HandshakeContext hc = (HandshakeContext)context;
            hc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE.id);
            TLCPCertificateMessage cm = new TLCPCertificateMessage(hc, message);
            if (hc.sslConfig.isClientMode) {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.fine((String)"Consuming server Certificate handshake message", (Object[])new Object[]{cm});
                }
                this.onCertificate((ClientHandshakeContext)context, cm);
            } else {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.fine((String)"Consuming client Certificate handshake message", (Object[])new Object[]{cm});
                }
                this.onCertificate((ServerHandshakeContext)context, cm);
            }
        }

        private void onCertificate(ServerHandshakeContext shc, TLCPCertificateMessage certificateMessage) throws IOException {
            List encodedCerts = certificateMessage.encodedCertChain;
            if (encodedCerts == null || encodedCerts.isEmpty()) {
                shc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
                if (shc.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_REQUESTED) {
                    throw shc.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty server certificate chain");
                }
                return;
            }
            X509Certificate[] x509Certs = new X509Certificate[encodedCerts.size()];
            try {
                CertificateFactory cf = PKIXInsts.getCertificateFactory((String)"X.509");
                int i = 0;
                for (byte[] encodedCert : encodedCerts) {
                    x509Certs[i++] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encodedCert));
                }
            }
            catch (CertificateException ce) {
                throw shc.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", ce);
            }
            TLCPCertificateConsumer.checkClientCerts(shc, x509Certs);
            shc.handshakeCredentials.add(TLCPCertificateConsumer.createCredentials(x509Certs, shc));
            shc.handshakeSession.setPeerCertificates(x509Certs);
        }

        private void onCertificate(ClientHandshakeContext chc, TLCPCertificateMessage certificateMessage) throws IOException {
            String identityAlg;
            List encodedCerts = certificateMessage.encodedCertChain;
            if (encodedCerts == null || encodedCerts.isEmpty()) {
                throw chc.conContext.fatal(Alert.BAD_CERTIFICATE, "Empty server certificate chain");
            }
            X509Certificate[] x509Certs = new X509Certificate[encodedCerts.size()];
            if (x509Certs.length < 2) {
                throw chc.conContext.fatal(Alert.BAD_CERTIFICATE, "Server must send at least two certificates");
            }
            try {
                CertificateFactory cf = PKIXInsts.getCertificateFactory((String)"X.509");
                int i = 0;
                for (byte[] encodedCert : encodedCerts) {
                    x509Certs[i++] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encodedCert));
                }
            }
            catch (CertificateException ce) {
                throw chc.conContext.fatal(Alert.BAD_CERTIFICATE, "Failed to parse server certificates", ce);
            }
            if (!(chc.reservedServerCerts == null || chc.handshakeSession.useExtendedMasterSecret || (identityAlg = chc.sslConfig.identificationProtocol) != null && !identityAlg.isEmpty() || TLCPCertificateConsumer.isIdentityEquivalent(x509Certs[0], chc.reservedServerCerts[0]))) {
                throw chc.conContext.fatal(Alert.BAD_CERTIFICATE, "server certificate change is restricted during renegotiation");
            }
            if (chc.staplingActive) {
                chc.deferredCerts = x509Certs;
            } else {
                TLCPCertificateConsumer.checkServerCerts(chc, x509Certs);
            }
            chc.handshakeCredentials.add(TLCPCertificateConsumer.createCredentials(x509Certs, chc));
            chc.handshakeSession.setPeerCertificates(x509Certs);
        }

        private static TLCPAuthentication.TLCPCredentials createCredentials(X509Certificate[] certs, HandshakeContext hc) throws SSLException {
            X509Certificate signCert = null;
            X509Certificate encCert = null;
            X509Certificate[] signCertChain = null;
            X509Certificate[] encCertChain = null;
            if (certs.length == 1) {
                signCert = certs[0];
                encCert = certs[0];
                signCertChain = new X509Certificate[]{signCert};
                encCertChain = new X509Certificate[]{encCert};
            } else if (certs.length == 2) {
                signCert = certs[0];
                encCert = certs[1];
                signCertChain = new X509Certificate[]{signCert};
                encCertChain = new X509Certificate[]{encCert};
            } else if (certs.length > 2) {
                CertListFormat format = null;
                format = PKIXUtils.isCA((X509Certificate)certs[certs.length - 1]) ? CertListFormat.SIGN_ENC_CA : (PKIXUtils.isCA((X509Certificate)certs[1]) ? CertListFormat.SIGN_CA_ENC : DEF_CERT_LIST_FORMAT);
                signCertChain = new X509Certificate[certs.length - 1];
                encCertChain = new X509Certificate[certs.length - 1];
                if (format == CertListFormat.SIGN_CA_ENC) {
                    signCert = certs[0];
                    System.arraycopy(certs, 0, signCertChain, 0, certs.length - 1);
                    encCertChain[0] = encCert = certs[certs.length - 1];
                    System.arraycopy(certs, 1, encCertChain, 1, certs.length - 2);
                } else {
                    signCertChain[0] = signCert = certs[0];
                    System.arraycopy(certs, 2, signCertChain, 1, certs.length - 2);
                    encCertChain[0] = encCert = certs[1];
                    System.arraycopy(certs, 2, encCertChain, 1, certs.length - 2);
                }
            }
            if (!PKIXUtils.isSignCert((X509Certificate)signCert)) {
                throw hc.conContext.fatal(Alert.BAD_CERTIFICATE, "The sign cert doesn't contain key usage digitalSignature");
            }
            if (!PKIXUtils.isEncCert((X509Certificate)encCert)) {
                throw hc.conContext.fatal(Alert.BAD_CERTIFICATE, "The enc cert doesn't contain key usages in keyEncipherment, dataEncipherment and keyAgreement.");
            }
            return new TLCPAuthentication.TLCPCredentials(signCert.getPublicKey(), signCertChain, encCert.getPublicKey(), encCertChain);
        }

        private static boolean isIdentityEquivalent(X509Certificate thisCert, X509Certificate prevCert) {
            Collection<List<?>> prevSubjectAltNames;
            Collection<List<?>> thisSubjectAltNames;
            block9: {
                block8: {
                    if (thisCert.equals(prevCert)) {
                        return true;
                    }
                    thisSubjectAltNames = null;
                    try {
                        thisSubjectAltNames = thisCert.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException cpe) {
                        if (!SSLLogger.isOn || !SSLLogger.isOn((String)"handshake")) break block8;
                        SSLLogger.fine((String)"Attempt to obtain subjectAltNames extension failed!", (Object[])new Object[0]);
                    }
                }
                prevSubjectAltNames = null;
                try {
                    prevSubjectAltNames = prevCert.getSubjectAlternativeNames();
                }
                catch (CertificateParsingException cpe) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn((String)"handshake")) break block9;
                    SSLLogger.fine((String)"Attempt to obtain subjectAltNames extension failed!", (Object[])new Object[0]);
                }
            }
            if (thisSubjectAltNames != null && prevSubjectAltNames != null) {
                Collection<String> thisSubAltIPAddrs = TLCPCertificateConsumer.getSubjectAltNames(thisSubjectAltNames, 7);
                Collection<String> prevSubAltIPAddrs = TLCPCertificateConsumer.getSubjectAltNames(prevSubjectAltNames, 7);
                if (thisSubAltIPAddrs != null && prevSubAltIPAddrs != null && TLCPCertificateConsumer.isEquivalent(thisSubAltIPAddrs, prevSubAltIPAddrs)) {
                    return true;
                }
                Collection<String> thisSubAltDnsNames = TLCPCertificateConsumer.getSubjectAltNames(thisSubjectAltNames, 2);
                Collection<String> prevSubAltDnsNames = TLCPCertificateConsumer.getSubjectAltNames(prevSubjectAltNames, 2);
                if (thisSubAltDnsNames != null && prevSubAltDnsNames != null && TLCPCertificateConsumer.isEquivalent(thisSubAltDnsNames, prevSubAltDnsNames)) {
                    return true;
                }
            }
            X500Principal thisSubject = thisCert.getSubjectX500Principal();
            X500Principal prevSubject = prevCert.getSubjectX500Principal();
            X500Principal thisIssuer = thisCert.getIssuerX500Principal();
            X500Principal prevIssuer = prevCert.getIssuerX500Principal();
            return !thisSubject.getName().isEmpty() && !prevSubject.getName().isEmpty() && thisSubject.equals(prevSubject) && thisIssuer.equals(prevIssuer);
        }

        private static Collection<String> getSubjectAltNames(Collection<List<?>> subjectAltNames, int type) {
            HashSet<String> subAltDnsNames = null;
            for (List<?> subjectAltName : subjectAltNames) {
                String subAltDnsName;
                int subjectAltNameType = (Integer)subjectAltName.get(0);
                if (subjectAltNameType != type || (subAltDnsName = (String)subjectAltName.get(1)) == null || subAltDnsName.isEmpty()) continue;
                if (subAltDnsNames == null) {
                    subAltDnsNames = new HashSet<String>(subjectAltNames.size());
                }
                subAltDnsNames.add(subAltDnsName);
            }
            return subAltDnsNames;
        }

        private static boolean isEquivalent(Collection<String> thisSubAltNames, Collection<String> prevSubAltNames) {
            for (String thisSubAltName : thisSubAltNames) {
                for (String prevSubAltName : prevSubAltNames) {
                    if (!thisSubAltName.equalsIgnoreCase(prevSubAltName)) continue;
                    return true;
                }
            }
            return false;
        }

        static void checkServerCerts(ClientHandshakeContext chc, X509Certificate[] certs) throws IOException {
            X509TrustManager tm = chc.sslContext.getX509TrustManager();
            String keyExchangeString = chc.negotiatedCipherSuite.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT || chc.negotiatedCipherSuite.keyExchange == CipherSuite.KeyExchange.K_DHE_RSA_EXPORT ? CipherSuite.KeyExchange.K_RSA.name : chc.negotiatedCipherSuite.keyExchange.name;
            try {
                if (tm instanceof X509ExtendedTrustManager) {
                    if (chc.conContext.transport instanceof SSLEngine) {
                        SSLEngine engine = (SSLEngine)((Object)chc.conContext.transport);
                        ((X509ExtendedTrustManager)tm).checkServerTrusted((X509Certificate[])certs.clone(), keyExchangeString, engine);
                    } else {
                        SSLSocket socket = (SSLSocket)((Object)chc.conContext.transport);
                        ((X509ExtendedTrustManager)tm).checkServerTrusted((X509Certificate[])certs.clone(), keyExchangeString, socket);
                    }
                } else {
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                chc.handshakeSession.setPeerCertificates(certs);
            }
            catch (CertificateException ce) {
                throw chc.conContext.fatal(TLCPCertificateConsumer.getCertificateAlert(chc, ce), ce);
            }
        }

        private static void checkClientCerts(ServerHandshakeContext shc, X509Certificate[] certs) throws IOException {
            block14: {
                String authType;
                String keyAlgorithm;
                X509TrustManager tm = shc.sslContext.getX509TrustManager();
                PublicKey key = certs[0].getPublicKey();
                switch (keyAlgorithm = key.getAlgorithm()) {
                    case "RSA": 
                    case "DSA": 
                    case "EC": 
                    case "RSASSA-PSS": {
                        authType = keyAlgorithm;
                        break;
                    }
                    default: {
                        authType = "UNKNOWN";
                    }
                }
                try {
                    if (tm instanceof X509ExtendedTrustManager) {
                        if (shc.conContext.transport instanceof SSLEngine) {
                            SSLEngine engine = (SSLEngine)((Object)shc.conContext.transport);
                            ((X509ExtendedTrustManager)tm).checkClientTrusted((X509Certificate[])certs.clone(), authType, engine);
                        } else {
                            SSLSocket socket = (SSLSocket)((Object)shc.conContext.transport);
                            ((X509ExtendedTrustManager)tm).checkClientTrusted((X509Certificate[])certs.clone(), authType, socket);
                        }
                        break block14;
                    }
                    throw new CertificateException("Improper X509TrustManager implementation");
                }
                catch (CertificateException ce) {
                    throw shc.conContext.fatal(Alert.CERTIFICATE_UNKNOWN, ce);
                }
            }
        }

        private static Alert getCertificateAlert(ClientHandshakeContext chc, CertificateException cexc) {
            Alert alert = Alert.CERTIFICATE_UNKNOWN;
            Throwable baseCause = cexc.getCause();
            if (baseCause instanceof CertPathValidatorException) {
                CertPathValidatorException cpve = (CertPathValidatorException)baseCause;
                CertPathValidatorException.Reason reason = cpve.getReason();
                if (reason == CertPathValidatorException.BasicReason.REVOKED) {
                    alert = chc.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_REVOKED;
                } else if (reason == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
                    alert = chc.staplingActive ? Alert.BAD_CERT_STATUS_RESPONSE : Alert.CERTIFICATE_UNKNOWN;
                } else if (reason == CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED) {
                    alert = Alert.UNSUPPORTED_CERTIFICATE;
                } else if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                    alert = Alert.CERTIFICATE_EXPIRED;
                } else if (reason == CertPathValidatorException.BasicReason.INVALID_SIGNATURE || reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                    alert = Alert.BAD_CERTIFICATE;
                }
            }
            return alert;
        }
    }

    static final class TLCPCertificateProducer
    implements HandshakeProducer {
        TLCPCertificateProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            HandshakeContext hc = (HandshakeContext)context;
            if (hc.sslConfig.isClientMode) {
                return this.onProduceCertificate((ClientHandshakeContext)context, message);
            }
            return this.onProduceCertificate((ServerHandshakeContext)context, message);
        }

        private byte[] onProduceCertificate(ServerHandshakeContext shc, SSLHandshake.HandshakeMessage message) throws IOException {
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                break;
            }
            if (tlcpPossession == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No expected X.509 certificate for server authentication");
            }
            shc.handshakeSession.setLocalPrivateKey(tlcpPossession.popSignPrivateKey);
            X509Certificate[] certs = TLCPCertificate.mergeCertChains(tlcpPossession.popSignCerts, tlcpPossession.popEncCerts);
            shc.handshakeSession.setLocalCertificates(certs);
            TLCPCertificateMessage cm = new TLCPCertificateMessage((HandshakeContext)shc, certs);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced server Certificate handshake message", (Object[])new Object[]{cm});
            }
            cm.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }

        private byte[] onProduceCertificate(ClientHandshakeContext chc, SSLHandshake.HandshakeMessage message) throws IOException {
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : chc.handshakePossessions) {
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                break;
            }
            if (tlcpPossession == null) {
                if (chc.negotiatedProtocol.isTLCP11() || chc.negotiatedProtocol.useTLS10PlusSpec()) {
                    if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                        SSLLogger.fine((String)"No X.509 certificate for client authentication, use empty Certificate message instead", (Object[])new Object[0]);
                    }
                    tlcpPossession = new TLCPAuthentication.TLCPPossession(null, new X509Certificate[0], null, new X509Certificate[0]);
                } else {
                    if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                        SSLLogger.fine((String)"No X.509 certificate for client authentication, send a no_certificate alert", (Object[])new Object[0]);
                    }
                    chc.conContext.warning(Alert.NO_CERTIFICATE);
                    return null;
                }
            }
            chc.handshakeSession.setLocalPrivateKey(tlcpPossession.popSignPrivateKey);
            X509Certificate[] certs = TLCPCertificate.mergeCertChains(tlcpPossession.popSignCerts, tlcpPossession.popEncCerts);
            if (certs != null && certs.length != 0) {
                chc.handshakeSession.setLocalCertificates(certs);
            } else {
                chc.handshakeSession.setLocalCertificates(null);
            }
            TLCPCertificateMessage cm = new TLCPCertificateMessage((HandshakeContext)chc, certs);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced client Certificate handshake message", (Object[])new Object[]{cm});
            }
            cm.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class TLCPCertificateMessage
    extends SSLHandshake.HandshakeMessage {
        private final List<byte[]> encodedCertChain;

        TLCPCertificateMessage(HandshakeContext handshakeContext, X509Certificate[] certChain) throws SSLException {
            super(handshakeContext);
            ArrayList<byte[]> encodedCerts = new ArrayList<byte[]>(certChain.length);
            for (X509Certificate cert : certChain) {
                try {
                    encodedCerts.add(cert.getEncoded());
                }
                catch (CertificateEncodingException cee) {
                    throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Could not encode certificate (" + cert.getSubjectX500Principal() + ")", cee);
                }
            }
            this.encodedCertChain = encodedCerts;
        }

        TLCPCertificateMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            int listLen;
            if (listLen > m.remaining()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Error parsing certificate message: no sufficient data");
            }
            if (listLen > 0) {
                byte[] encodedCert;
                LinkedList<byte[]> encodedCerts = new LinkedList<byte[]>();
                for (listLen = Record.getInt24(m); listLen > 0; listLen -= 3 + encodedCert.length) {
                    encodedCert = Record.getBytes24(m);
                    encodedCerts.add(encodedCert);
                    if (encodedCerts.size() <= SSLConfiguration.maxCertificateChainLength) continue;
                    throw new SSLProtocolException("The certificate chain length (" + encodedCerts.size() + ") exceeds the maximum allowed length (" + SSLConfiguration.maxCertificateChainLength + ")");
                }
                this.encodedCertChain = encodedCerts;
            } else {
                this.encodedCertChain = Collections.emptyList();
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE;
        }

        @Override
        public int messageLength() {
            int msgLen = 3;
            for (byte[] encodedCert : this.encodedCertChain) {
                msgLen += encodedCert.length + 3;
            }
            return msgLen;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            int listLen = 0;
            for (byte[] encodedCert : this.encodedCertChain) {
                listLen += encodedCert.length + 3;
            }
            hos.putInt24(listLen);
            for (byte[] encodedCert : this.encodedCertChain) {
                hos.putBytes24(encodedCert);
            }
        }

        public String toString() {
            int i;
            if (this.encodedCertChain.isEmpty()) {
                return "\"Certificates\": <empty list>";
            }
            Object[] x509Certs = new Object[this.encodedCertChain.size()];
            try {
                CertificateFactory cf = PKIXInsts.getCertificateFactory((String)"X.509");
                i = 0;
                for (byte[] encodedCert : this.encodedCertChain) {
                    Object obj;
                    try {
                        obj = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encodedCert));
                    }
                    catch (CertificateException ce) {
                        obj = encodedCert;
                    }
                    x509Certs[i++] = obj;
                }
            }
            catch (CertificateException ce) {
                i = 0;
                for (byte[] encodedCert : this.encodedCertChain) {
                    x509Certs[i++] = encodedCert;
                }
            }
            MessageFormat messageFormat = new MessageFormat("\"Certificates\": [\n{0}\n]", Locale.ENGLISH);
            Object[] messageFields = new Object[]{SSLLogger.toString((Object[])x509Certs)};
            return messageFormat.format(messageFields);
        }
    }

    static enum CertListFormat {
        SIGN_ENC_CA("SIGN|ENC|CA"),
        SIGN_CA_ENC("SIGN|CA|ENC");

        String format;

        private CertListFormat(String format) {
            this.format = format;
        }

        static CertListFormat format(String format) {
            return CertListFormat.SIGN_CA_ENC.format.equalsIgnoreCase(format) ? SIGN_CA_ENC : SIGN_ENC_CA;
        }
    }
}

