/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.CertificateRequest;
import com.tencent.kona.sun.security.ssl.CertificateStatus;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.X509Authentication;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;

final class TLCPCertificateRequest {
    static final SSLConsumer tlcpHandshakeConsumer = new TLCPCertificateRequestConsumer();
    static final HandshakeProducer tlcpHandshakeProducer = new TLCPCertificateRequestProducer();

    TLCPCertificateRequest() {
    }

    private static final class TLCPCertificateRequestConsumer
    implements SSLConsumer {
        private TLCPCertificateRequestConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            SSLPossession pos;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            chc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_REQUEST.id);
            chc.receivedCertReq = true;
            if (chc.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE.id)) {
                throw chc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateRequest handshake message");
            }
            SSLConsumer certStatCons = (SSLConsumer)chc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
            if (certStatCons != null) {
                CertificateStatus.handshakeAbsence.absent(context, null);
            }
            TLCPCertificateRequestMessage crm = new TLCPCertificateRequestMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Consuming CertificateRequest handshake message", (Object[])new Object[]{crm});
            }
            chc.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            if (chc.negotiatedProtocol.isTLS12()) {
                List<SignatureScheme> sss = SignatureScheme.getSupportedAlgorithms(chc.sslConfig, chc.algorithmConstraints, chc.negotiatedProtocol, crm.algorithmIds);
                if (sss.isEmpty()) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No supported signature algorithm");
                }
                chc.peerRequestedSignatureSchemes = sss;
                chc.peerRequestedCertSignSchemes = sss;
                chc.handshakeSession.setPeerSupportedSignatureAlgorithms(sss);
            }
            chc.peerSupportedAuthorities = crm.getAuthorities();
            SSLPossession sSLPossession = pos = chc.negotiatedProtocol.isTLCP11() ? TLCPCertificateRequestConsumer.choosePossession4TLCP(chc) : TLCPCertificateRequestConsumer.choosePossession(chc, crm);
            if (pos == null) {
                return;
            }
            chc.handshakePossessions.add(pos);
            chc.handshakeProducers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
        }

        private static SSLPossession choosePossession4TLCP(HandshakeContext hc) {
            return TLCPAuthentication.createPossession(hc, new String[]{"EC"});
        }

        private static SSLPossession choosePossession(HandshakeContext hc, TLCPCertificateRequestMessage crm) throws IOException {
            String[] supportedKeyTypes;
            SSLPossession pos;
            if (hc.peerRequestedCertSignSchemes == null || hc.peerRequestedCertSignSchemes.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.warning((String)"No signature and hash algorithms in CertificateRequest", (Object[])new Object[0]);
                }
                return null;
            }
            ArrayList<String> crKeyTypes = new ArrayList<String>(Arrays.asList(crm.getKeyTypes()));
            if (crKeyTypes.contains("RSA")) {
                crKeyTypes.add("RSASSA-PSS");
            }
            if ((pos = X509Authentication.createPossession(hc, supportedKeyTypes = (String[])hc.peerRequestedCertSignSchemes.stream().map(ss -> ss.keyAlgorithm).distinct().filter(ka -> SignatureScheme.getPreferableAlgorithm(hc.algorithmConstraints, hc.peerRequestedSignatureSchemes, ka, hc.negotiatedProtocol) != null || SSLLogger.logWarning((String)"ssl,handshake", (String)("Unable to produce CertificateVerify for key algorithm: " + ka))).filter(ka -> {
                X509Authentication xa = X509Authentication.valueOfKeyAlgorithm(ka);
                return xa != null && !Collections.disjoint(crKeyTypes, Arrays.asList(xa.keyTypes)) || SSLLogger.logWarning((String)"ssl,handshake", (String)("Unsupported key algorithm: " + ka));
            }).toArray(String[]::new))) == null && SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.warning((String)"No available authentication scheme", (Object[])new Object[0]);
            }
            return pos;
        }
    }

    private static final class TLCPCertificateRequestProducer
    implements HandshakeProducer {
        private TLCPCertificateRequestProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            List localSupportedSignAlgs = null;
            if (shc.negotiatedProtocol.isTLS12()) {
                if (shc.localSupportedSignAlgs == null) {
                    shc.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(shc.sslConfig, shc.algorithmConstraints, shc.activeProtocols);
                }
                if (shc.localSupportedSignAlgs.isEmpty()) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No supported signature algorithm");
                }
                localSupportedSignAlgs = shc.localSupportedSignAlgs;
            }
            X509Certificate[] caCerts = shc.sslContext.getX509TrustManager().getAcceptedIssuers();
            TLCPCertificateRequestMessage crm = new TLCPCertificateRequestMessage(shc, caCerts, shc.negotiatedCipherSuite.keyExchange, localSupportedSignAlgs);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced CertificateRequest handshake message", (Object[])new Object[]{crm});
            }
            crm.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            shc.handshakeConsumers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
            shc.handshakeConsumers.put(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            return null;
        }
    }

    private static final class TLCPCertificateRequestMessage
    extends SSLHandshake.HandshakeMessage {
        final byte[] types;
        final int[] algorithmIds;
        final List<byte[]> authorities;

        TLCPCertificateRequestMessage(HandshakeContext handshakeContext, X509Certificate[] trustedCerts, CipherSuite.KeyExchange keyExchange, List<SignatureScheme> signatureSchemes) throws IOException {
            super(handshakeContext);
            this.types = new byte[]{CertificateRequest.ClientCertificateType.ECDSA_SIGN.id, CertificateRequest.ClientCertificateType.RSA_SIGN.id};
            if (handshakeContext.negotiatedProtocol.isTLS12()) {
                if (signatureSchemes == null || signatureSchemes.isEmpty()) {
                    throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No signature algorithms specified for CertificateRequest hanshake message");
                }
                this.algorithmIds = new int[signatureSchemes.size()];
                int i = 0;
                for (SignatureScheme scheme : signatureSchemes) {
                    this.algorithmIds[i++] = scheme.id;
                }
            } else {
                this.algorithmIds = new int[0];
            }
            this.authorities = new ArrayList<byte[]>(trustedCerts.length);
            for (X509Certificate cert : trustedCerts) {
                X500Principal x500Principal = cert.getSubjectX500Principal();
                this.authorities.add(x500Principal.getEncoded());
            }
        }

        TLCPCertificateRequestMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            int minLen;
            int n = minLen = handshakeContext.negotiatedProtocol.isTLCP11() ? 4 : 8;
            if (m.remaining() < minLen) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            this.types = Record.getBytes8(m);
            if (handshakeContext.negotiatedProtocol.isTLS12()) {
                if (m.remaining() < 6) {
                    throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
                }
                byte[] algs = Record.getBytes16(m);
                if (algs.length == 0 || (algs.length & 1) != 0) {
                    throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: incomplete signature algorithms");
                }
                this.algorithmIds = new int[algs.length >> 1];
                int i = 0;
                int j = 0;
                while (i < algs.length) {
                    byte hash = algs[i++];
                    byte sign = algs[i++];
                    this.algorithmIds[j++] = (hash & 0xFF) << 8 | sign & 0xFF;
                }
            } else {
                this.algorithmIds = new int[0];
            }
            if (m.remaining() < 2) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest handshake message: no sufficient data");
            }
            int listLen = Record.getInt16(m);
            if (listLen > m.remaining()) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateRequest message: no sufficient data");
            }
            if (listLen > 0) {
                this.authorities = new LinkedList<byte[]>();
                while (listLen > 0) {
                    byte[] encoded = Record.getBytes16(m);
                    listLen -= 2 + encoded.length;
                    this.authorities.add(encoded);
                }
            } else {
                this.authorities = Collections.emptyList();
            }
        }

        String[] getKeyTypes() {
            return CertificateRequest.ClientCertificateType.getKeyTypes(this.types);
        }

        X500Principal[] getAuthorities() {
            X500Principal[] principals = new X500Principal[this.authorities.size()];
            int i = 0;
            for (byte[] encoded : this.authorities) {
                principals[i++] = new X500Principal(encoded);
            }
            return principals;
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_REQUEST;
        }

        @Override
        public int messageLength() {
            int len = 1 + this.types.length + 2;
            if (this.algorithmIds.length > 0) {
                len += (this.algorithmIds.length << 1) + 2;
            }
            for (byte[] encoded : this.authorities) {
                len += encoded.length + 2;
            }
            return len;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putBytes8(this.types);
            int listLen = 0;
            for (byte[] encoded : this.authorities) {
                listLen += encoded.length + 2;
            }
            hos.putInt16(listLen);
            for (byte[] encoded : this.authorities) {
                hos.putBytes16(encoded);
            }
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var6_10;
            MessageFormat messageFormat = new MessageFormat("\"CertificateRequest\": '{'\n  \"certificate types\": {0}\n  \"supported signature algorithms\": {1}\n  \"certificate authorities\": {2}\n'}'", Locale.ENGLISH);
            ArrayList<String> typeNames = new ArrayList<String>(this.types.length);
            for (byte by : this.types) {
                typeNames.add(CertificateRequest.ClientCertificateType.nameOf(by));
            }
            ArrayList<String> algorithmNames = new ArrayList<String>(this.algorithmIds.length);
            int[] nArray = this.algorithmIds;
            int n = nArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                int algorithmId = nArray[var6_10];
                algorithmNames.add(SignatureScheme.nameOf(algorithmId));
                ++var6_10;
            }
            ArrayList<String> authorityNames = new ArrayList<String>(this.authorities.size());
            for (byte[] byArray : this.authorities) {
                X500Principal principal = new X500Principal(byArray);
                authorityNames.add(principal.toString());
            }
            Object[] messageFields = new Object[]{typeNames, algorithmNames, authorityNames};
            return messageFormat.format(messageFields);
        }
    }
}

