/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.spec.SM2SignatureParameterSpec;
import com.tencent.kona.crypto.util.Constants;
import com.tencent.kona.pkix.PKIXUtils;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.Record;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLCredentials;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.TLCPAuthentication;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.text.MessageFormat;
import java.util.Locale;

final class TLCPCertificateVerify {
    static final SSLConsumer tlcpHandshakeConsumer = new TLCPCertificateVerifyConsumer();
    static final HandshakeProducer tlcpHandshakeProducer = new TLCPCertificateVerifyProducer();

    TLCPCertificateVerify() {
    }

    private static final class TLCPCertificateVerifyConsumer
    implements SSLConsumer {
        private TLCPCertificateVerifyConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            shc.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_VERIFY.id);
            if (shc.handshakeConsumers.containsKey(SSLHandshake.CLIENT_KEY_EXCHANGE.id)) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected CertificateVerify handshake message");
            }
            TLCPCertificateVerifyMessage cvm = new TLCPCertificateVerifyMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Consuming CertificateVerify handshake message", (Object[])new Object[]{cvm});
            }
        }
    }

    private static final class TLCPCertificateVerifyProducer
    implements HandshakeProducer {
        private TLCPCertificateVerifyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            TLCPAuthentication.TLCPPossession tlcpPossession = null;
            for (SSLPossession possession : chc.handshakePossessions) {
                if (!(possession instanceof TLCPAuthentication.TLCPPossession)) continue;
                tlcpPossession = (TLCPAuthentication.TLCPPossession)possession;
                break;
            }
            if (tlcpPossession == null || tlcpPossession.popSignPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.fine((String)"No X.509 credentials negotiated for CertificateVerify", (Object[])new Object[0]);
                }
                return null;
            }
            TLCPCertificateVerifyMessage cvm = new TLCPCertificateVerifyMessage((HandshakeContext)chc, tlcpPossession);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced CertificateVerify handshake message", (Object[])new Object[]{cvm});
            }
            cvm.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class TLCPCertificateVerifyMessage
    extends SSLHandshake.HandshakeMessage {
        private final SignatureScheme signatureScheme;
        private final byte[] signature;

        TLCPCertificateVerifyMessage(HandshakeContext context, TLCPAuthentication.TLCPPossession tlcpPossession) throws IOException {
            super(context);
            byte[] temporary;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            this.signatureScheme = chc.negotiatedProtocol.isTLS12() ? SignatureScheme.SM2SIG_SM3 : null;
            try {
                Signature signer = SignatureScheme.SM2SIG_SM3.getSigner(tlcpPossession.popSignPrivateKey, new SM2SignatureParameterSpec(Constants.defaultId(), (ECPublicKey)tlcpPossession.popSignPublicKey));
                signer.update(chc.handshakeHash.digest());
                temporary = signer.sign();
            }
            catch (SignatureException se) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot produce CertificateVerify signature", se);
            }
            this.signature = temporary;
        }

        TLCPCertificateVerifyMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            int minLen;
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            int n = minLen = shc.negotiatedProtocol.isTLS12() ? 4 : 2;
            if (m.remaining() < 4) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid CertificateVerify message: no sufficient data");
            }
            if (shc.negotiatedProtocol.isTLS12()) {
                int ssid = Record.getInt16(m);
                this.signatureScheme = SignatureScheme.valueOf(ssid);
                if (this.signatureScheme == null) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + ssid + ") used in CertificateVerify handshake message");
                }
                if (!shc.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in CertificateVerify handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            TLCPAuthentication.TLCPCredentials tlcpCredentials = null;
            for (SSLCredentials cd : shc.handshakeCredentials) {
                if (!(cd instanceof TLCPAuthentication.TLCPCredentials)) continue;
                tlcpCredentials = (TLCPAuthentication.TLCPCredentials)cd;
                break;
            }
            if (tlcpCredentials == null || tlcpCredentials.popSignPublicKey == null) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No X509 credentials negotiated for CertificateVerify");
            }
            this.signature = Record.getBytes16(m);
            if (!PKIXUtils.isSMCert((X509Certificate)tlcpCredentials.popSignCert)) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Only support SM certificate");
            }
            try {
                Signature signer = SignatureScheme.SM2SIG_SM3.getVerifier(tlcpCredentials.popSignPublicKey, new SM2SignatureParameterSpec(Constants.defaultId(), (ECPublicKey)tlcpCredentials.popSignPublicKey));
                signer.update(shc.handshakeHash.digest());
                if (!signer.verify(this.signature)) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid CertificateVerify signature");
                }
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException nsae) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in CertificateVerify handshake message", nsae);
            }
            catch (InvalidKeyException | SignatureException ikse) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify CertificateVerify signature", ikse);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_VERIFY;
        }

        @Override
        public int messageLength() {
            if (this.signatureScheme != null) {
                return 4 + this.signature.length;
            }
            return 2 + this.signature.length;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            if (this.signatureScheme != null) {
                hos.putInt16(this.signatureScheme.id);
            }
            hos.putBytes16(this.signature);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"CertificateVerify\": '{'\n  \"signature algorithm\": {0}\n  \"signature\": '{'\n{1}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{this.signatureScheme != null ? this.signatureScheme.name : "", Utilities.indent((String)hexEncoder.encodeBuffer(this.signature), (String)"    ")};
            return messageFormat.format(messageFields);
        }
    }
}

