/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.ssl.Authenticator;
import com.tencent.kona.sun.security.ssl.Plaintext;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLCipher;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

final class TLCPCipher {
    TLCPCipher() {
    }

    static final class TLCPGcmWriteCipherGenerator
    implements SSLCipher.WriteCipherGenerator {
        TLCPGcmWriteCipherGenerator() {
        }

        @Override
        public SSLCipher.SSLWriteCipher createCipher(SSLCipher sslCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
            return new GcmWriteCipher(authenticator, protocolVersion, sslCipher, algorithm, key, params, random);
        }

        private static final class GcmWriteCipher
        extends SSLCipher.SSLWriteCipher {
            private final Cipher cipher;
            private final int tagSize;
            private final Key key;
            private final byte[] fixedIv;
            private final int recordIvSize;
            private final SecureRandom random;

            GcmWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sslCipher, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = CryptoInsts.getCipher((String)algorithm);
                this.tagSize = sslCipher.tagSize;
                this.key = key;
                this.fixedIv = ((IvParameterSpec)params).getIV();
                this.recordIvSize = sslCipher.ivSize - sslCipher.fixedIvSize;
                this.random = random;
            }

            @Override
            public int encrypt(byte contentType, ByteBuffer bb) {
                int len;
                ByteBuffer dup;
                int outputSize;
                byte[] nonce = this.authenticator.sequenceNumber();
                byte[] iv = Arrays.copyOf(this.fixedIv, this.fixedIv.length + nonce.length);
                System.arraycopy(nonce, 0, iv, this.fixedIv.length, nonce.length);
                GCMParameterSpec spec = new GCMParameterSpec(this.tagSize * 8, iv);
                try {
                    this.cipher.init(1, this.key, spec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException ikae) {
                    throw new RuntimeException("invalid key or spec in GCM mode", ikae);
                }
                byte[] aad = this.authenticator.acquireAuthenticationBytes(contentType, bb.remaining(), null);
                this.cipher.updateAAD(aad);
                bb.position(bb.position() - nonce.length);
                bb.put(nonce);
                int pos = bb.position();
                if (SSLLogger.isOn && SSLLogger.isOn((String)"plaintext")) {
                    SSLLogger.fine((String)"Plaintext before ENCRYPTION", (Object[])new Object[]{bb.duplicate()});
                }
                if ((outputSize = this.cipher.getOutputSize((dup = bb.duplicate()).remaining())) > bb.remaining()) {
                    bb.limit(pos + outputSize);
                }
                try {
                    len = this.cipher.doFinal(dup, bb);
                }
                catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException ibse) {
                    throw new RuntimeException("Cipher error in AEAD mode in JCE provider " + this.cipher.getProvider().getName(), ibse);
                }
                if (len != outputSize) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName());
                }
                return len + nonce.length;
            }

            @Override
            int getExplicitNonceSize() {
                return this.recordIvSize;
            }

            @Override
            int calculateFragmentSize(int packetLimit, int headerSize) {
                return packetLimit - headerSize - this.recordIvSize - this.tagSize;
            }

            @Override
            int calculatePacketSize(int fragmentSize, int headerSize) {
                return fragmentSize + headerSize + this.recordIvSize + this.tagSize;
            }
        }
    }

    static final class TLCPGcmReadCipherGenerator
    implements SSLCipher.ReadCipherGenerator {
        TLCPGcmReadCipherGenerator() {
        }

        @Override
        public SSLCipher.SSLReadCipher createCipher(SSLCipher sslCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
            return new GcmReadCipher(authenticator, protocolVersion, sslCipher, algorithm, key, params, random);
        }

        static final class GcmReadCipher
        extends SSLCipher.SSLReadCipher {
            private final Cipher cipher;
            private final int tagSize;
            private final Key key;
            private final byte[] fixedIv;
            private final int recordIvSize;
            private final SecureRandom random;

            GcmReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sslCipher, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = CryptoInsts.getCipher((String)algorithm);
                this.tagSize = sslCipher.tagSize;
                this.key = key;
                this.fixedIv = ((IvParameterSpec)params).getIV();
                this.recordIvSize = sslCipher.ivSize - sslCipher.fixedIvSize;
                this.random = random;
            }

            @Override
            public Plaintext decrypt(byte contentType, ByteBuffer bb, byte[] sequence) throws GeneralSecurityException {
                int len;
                int pos;
                ByteBuffer pt;
                if (bb.remaining() < this.recordIvSize + this.tagSize) {
                    throw new BadPaddingException("Insufficient buffer remaining for AEAD cipher fragment (" + bb.remaining() + "). Needs to be more than or equal to IV size (" + this.recordIvSize + ") + tag size (" + this.tagSize + ")");
                }
                byte[] iv = Arrays.copyOf(this.fixedIv, this.fixedIv.length + this.recordIvSize);
                bb.get(iv, this.fixedIv.length, this.recordIvSize);
                GCMParameterSpec spec = new GCMParameterSpec(this.tagSize * 8, iv);
                try {
                    this.cipher.init(2, this.key, spec, this.random);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException ikae) {
                    throw new RuntimeException("invalid key or spec in GCM mode", ikae);
                }
                byte[] aad = this.authenticator.acquireAuthenticationBytes(contentType, bb.remaining() - this.tagSize, sequence);
                this.cipher.updateAAD(aad);
                if (!bb.isReadOnly()) {
                    pt = bb.duplicate();
                    pos = bb.position();
                } else {
                    pt = ByteBuffer.allocate(bb.remaining());
                    pos = 0;
                }
                try {
                    len = this.cipher.doFinal(bb, pt);
                }
                catch (IllegalBlockSizeException ibse) {
                    throw new RuntimeException("Cipher error in AEAD mode \"" + ibse.getMessage() + " \"in JCE provider " + this.cipher.getProvider().getName());
                }
                catch (ShortBufferException sbe) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), sbe);
                }
                pt.position(pos);
                pt.limit(pos + len);
                if (SSLLogger.isOn && SSLLogger.isOn((String)"plaintext")) {
                    SSLLogger.fine((String)"Plaintext after DECRYPTION", (Object[])new Object[]{pt.duplicate()});
                }
                return new Plaintext(contentType, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, pt.slice());
            }

            @Override
            int estimateFragmentSize(int packetSize, int headerSize) {
                return packetSize - headerSize - this.recordIvSize - this.tagSize;
            }
        }
    }

    static final class TLCPBlockWriteCipherGenerator
    implements SSLCipher.WriteCipherGenerator {
        TLCPBlockWriteCipherGenerator() {
        }

        @Override
        public SSLCipher.SSLWriteCipher createCipher(SSLCipher sslCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
            return new BlockWriteCipher(authenticator, protocolVersion, sslCipher, algorithm, key, params, random);
        }

        static final class BlockWriteCipher
        extends SSLCipher.SSLWriteCipher {
            private final Cipher cipher;
            private final SecureRandom random;

            BlockWriteCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sslCipher, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = CryptoInsts.getCipher((String)algorithm);
                this.random = random;
                if (params == null) {
                    params = new IvParameterSpec(new byte[sslCipher.ivSize]);
                }
                this.cipher.init(1, key, params, random);
            }

            @Override
            public int encrypt(byte contentType, ByteBuffer bb) {
                int pos = bb.position();
                Authenticator.MAC signer = (Authenticator.MAC)((Object)this.authenticator);
                if (signer.macAlg().size != 0) {
                    SSLCipher.addMac(signer, bb, contentType);
                } else {
                    this.authenticator.increaseSequenceNumber();
                }
                byte[] nonce = new byte[this.cipher.getBlockSize()];
                this.random.nextBytes(nonce);
                bb.position(pos -= nonce.length);
                bb.put(nonce);
                bb.position(pos);
                int blockSize = this.cipher.getBlockSize();
                int len = SSLCipher.addPadding(bb, blockSize);
                bb.position(pos);
                if (SSLLogger.isOn && SSLLogger.isOn((String)"plaintext")) {
                    SSLLogger.fine((String)"Padded plaintext before ENCRYPTION", (Object[])new Object[]{bb.duplicate()});
                }
                ByteBuffer dup = bb.duplicate();
                try {
                    if (len != this.cipher.update(dup, bb)) {
                        throw new RuntimeException("Unexpected number of plaintext bytes");
                    }
                    if (bb.position() != dup.position()) {
                        throw new RuntimeException("Unexpected ByteBuffer position");
                    }
                }
                catch (ShortBufferException sbe) {
                    throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), sbe);
                }
                return len;
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int getExplicitNonceSize() {
                return this.cipher.getBlockSize();
            }

            @Override
            int calculateFragmentSize(int packetLimit, int headerSize) {
                int macLen = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int blockSize = this.cipher.getBlockSize();
                int fragLen = packetLimit - headerSize - blockSize;
                fragLen -= fragLen % blockSize;
                --fragLen;
                return fragLen -= macLen;
            }

            @Override
            int calculatePacketSize(int fragmentSize, int headerSize) {
                int macLen = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int paddedLen = fragmentSize + macLen + 1;
                int blockSize = this.cipher.getBlockSize();
                if (paddedLen % blockSize != 0) {
                    paddedLen += blockSize - 1;
                    paddedLen -= paddedLen % blockSize;
                }
                return headerSize + blockSize + paddedLen;
            }

            @Override
            boolean isCBCMode() {
                return true;
            }
        }
    }

    static final class TLCPBlockReadCipherGenerator
    implements SSLCipher.ReadCipherGenerator {
        TLCPBlockReadCipherGenerator() {
        }

        @Override
        public SSLCipher.SSLReadCipher createCipher(SSLCipher sslCipher, Authenticator authenticator, ProtocolVersion protocolVersion, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
            return new BlockReadCipher(authenticator, protocolVersion, sslCipher, algorithm, key, params, random);
        }

        static final class BlockReadCipher
        extends SSLCipher.SSLReadCipher {
            private final Cipher cipher;

            BlockReadCipher(Authenticator authenticator, ProtocolVersion protocolVersion, SSLCipher sslCipher, String algorithm, Key key, AlgorithmParameterSpec params, SecureRandom random) throws GeneralSecurityException {
                super(authenticator, protocolVersion);
                this.cipher = CryptoInsts.getCipher((String)algorithm);
                if (params == null) {
                    params = new IvParameterSpec(new byte[sslCipher.ivSize]);
                }
                this.cipher.init(2, key, params, random);
            }

            @Override
            public Plaintext decrypt(byte contentType, ByteBuffer bb, byte[] sequence) throws GeneralSecurityException {
                ByteBuffer pt;
                BadPaddingException reservedBPE;
                block15: {
                    int tagLen;
                    int cipheredLength;
                    Authenticator.MAC signer;
                    block14: {
                        int pos;
                        reservedBPE = null;
                        signer = (Authenticator.MAC)((Object)this.authenticator);
                        cipheredLength = bb.remaining();
                        tagLen = signer.macAlg().size;
                        if (tagLen != 0 && !this.sanityCheck(tagLen, cipheredLength)) {
                            reservedBPE = new BadPaddingException("ciphertext sanity check failed");
                        }
                        if (!bb.isReadOnly()) {
                            pt = bb.duplicate();
                            pos = bb.position();
                        } else {
                            pt = ByteBuffer.allocate(cipheredLength);
                            pos = 0;
                        }
                        try {
                            if (cipheredLength != this.cipher.update(bb, pt)) {
                                throw new RuntimeException("Unexpected number of plaintext bytes");
                            }
                        }
                        catch (ShortBufferException sbe) {
                            throw new RuntimeException("Cipher buffering error in JCE provider " + this.cipher.getProvider().getName(), sbe);
                        }
                        if (SSLLogger.isOn && SSLLogger.isOn((String)"plaintext")) {
                            SSLLogger.fine((String)"Padded plaintext after DECRYPTION", (Object[])new Object[]{pt.duplicate().position(pos)});
                        }
                        int blockSize = this.cipher.getBlockSize();
                        pt.position(pos += blockSize);
                        try {
                            SSLCipher.removePadding(pt, tagLen, blockSize, this.protocolVersion);
                        }
                        catch (BadPaddingException bpe) {
                            if (reservedBPE != null) break block14;
                            reservedBPE = bpe;
                        }
                    }
                    try {
                        if (tagLen != 0) {
                            SSLCipher.checkCBCMac(signer, pt, contentType, cipheredLength, sequence);
                        } else {
                            this.authenticator.increaseSequenceNumber();
                        }
                    }
                    catch (BadPaddingException bpe) {
                        if (reservedBPE != null) break block15;
                        reservedBPE = bpe;
                    }
                }
                if (reservedBPE != null) {
                    throw reservedBPE;
                }
                return new Plaintext(contentType, ProtocolVersion.NONE.major, ProtocolVersion.NONE.minor, -1, -1L, pt.slice());
            }

            @Override
            void dispose() {
                if (this.cipher != null) {
                    try {
                        this.cipher.doFinal();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            int estimateFragmentSize(int packetSize, int headerSize) {
                int macLen = ((Authenticator.MAC)((Object)this.authenticator)).macAlg().size;
                int nonceSize = this.cipher.getBlockSize();
                return packetSize - headerSize - nonceSize - macLen - 1;
            }

            private boolean sanityCheck(int tagLen, int fragmentLen) {
                int blockSize = this.cipher.getBlockSize();
                if (fragmentLen % blockSize == 0) {
                    int minimal = tagLen + 1;
                    minimal = Math.max(minimal, blockSize);
                    return fragmentLen >= (minimal += blockSize);
                }
                return false;
            }
        }
    }
}

