/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ClientAuthType;
import com.tencent.kona.sun.security.ssl.ClientHello;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.HandshakeConsumer;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLExtension;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLSessionContextImpl;
import com.tencent.kona.sun.security.ssl.SSLSessionImpl;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import java.io.IOException;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;

final class TLCPClientHello {
    static final HandshakeConsumer tlcpHandshakeConsumer = new TLCPClientHelloConsumer();

    TLCPClientHello() {
    }

    private static final class TLCPClientHelloConsumer
    implements HandshakeConsumer {
        private TLCPClientHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            SSLHandshake[] probableHandshakeMessages;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            ClientHello.ClientHelloMessage clientHello = (ClientHello.ClientHelloMessage)message;
            if (shc.conContext.isNegotiated) {
                if (!shc.conContext.secureRenegotiation && !HandshakeContext.allowUnsafeRenegotiation) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsafe renegotiation is not allowed");
                }
                if (ServerHandshakeContext.rejectClientInitiatedRenego && !shc.kickstartMessageDelivered) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Client initiated renegotiation is not allowed");
                }
            }
            SSLExtension[] ext = new SSLExtension[]{SSLExtension.CH_SESSION_TICKET};
            clientHello.extensions.consumeOnLoad(shc, ext);
            if (clientHello.sessionId.length() != 0 || shc.statelessResumption) {
                String sessionIdentityAlg;
                CipherSuite suite;
                boolean resumingSession;
                SSLSessionImpl previous;
                block17: {
                    ProtocolVersion sessionProtocol;
                    SSLSessionContextImpl cache = (SSLSessionContextImpl)shc.sslContext.engineGetServerSessionContext();
                    previous = shc.statelessResumption ? shc.resumingSession : cache.get(clientHello.sessionId.getId());
                    boolean bl = resumingSession = previous != null && previous.isRejoinable();
                    if (!resumingSession && SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake,verbose")) {
                        SSLLogger.finest((String)"Can't resume, the existing session is not rejoinable", (Object[])new Object[0]);
                    }
                    if (resumingSession && (sessionProtocol = previous.getProtocolVersion()) != shc.negotiatedProtocol) {
                        resumingSession = false;
                        if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake,verbose")) {
                            SSLLogger.finest((String)"Can't resume, not the same protocol version", (Object[])new Object[0]);
                        }
                    }
                    if (resumingSession && shc.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED) {
                        try {
                            previous.getPeerPrincipal();
                        }
                        catch (SSLPeerUnverifiedException e) {
                            resumingSession = false;
                            if (!SSLLogger.isOn || !SSLLogger.isOn((String)"ssl,handshake,verbose")) break block17;
                            SSLLogger.finest((String)"Can't resume, client authentication is required", (Object[])new Object[0]);
                        }
                    }
                }
                if (!(!resumingSession || shc.isNegotiable(suite = previous.getSuite()) && clientHello.cipherSuites.contains((Object)suite))) {
                    resumingSession = false;
                    if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake,verbose")) {
                        SSLLogger.finest((String)"Can't resume, the session cipher suite is absent", (Object[])new Object[0]);
                    }
                }
                String identityAlg = shc.sslConfig.identificationProtocol;
                if (resumingSession && identityAlg != null && !identityAlg.equalsIgnoreCase(sessionIdentityAlg = previous.getIdentificationProtocol())) {
                    if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake,verbose")) {
                        SSLLogger.finest((String)("Can't resume, endpoint id algorithm does not match, requested: " + identityAlg + ", cached: " + sessionIdentityAlg), (Object[])new Object[0]);
                    }
                    resumingSession = false;
                }
                shc.isResumption = resumingSession;
                SSLSessionImpl sSLSessionImpl = shc.resumingSession = resumingSession ? previous : null;
                if (!resumingSession && SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.fine((String)"Session not resumed.", (Object[])new Object[0]);
                }
            }
            shc.clientHelloRandom = clientHello.clientRandom;
            SSLExtension[] extTypes = shc.sslConfig.getExclusiveExtensions(SSLHandshake.CLIENT_HELLO, Arrays.asList(SSLExtension.CH_SESSION_TICKET));
            clientHello.extensions.consumeOnLoad(shc, extTypes);
            if (!shc.conContext.isNegotiated) {
                shc.conContext.protocolVersion = shc.negotiatedProtocol;
                shc.conContext.outputRecord.setVersion(shc.negotiatedProtocol);
            }
            shc.handshakeProducers.put(SSLHandshake.SERVER_HELLO.id, SSLHandshake.SERVER_HELLO);
            for (SSLHandshake hs : probableHandshakeMessages = new SSLHandshake[]{SSLHandshake.SERVER_HELLO, SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_STATUS, SSLHandshake.SERVER_KEY_EXCHANGE, SSLHandshake.CERTIFICATE_REQUEST, SSLHandshake.SERVER_HELLO_DONE, SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)shc.handshakeProducers.remove(hs.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(context, clientHello);
            }
        }
    }
}

