/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.internal.spec.TlsPrfParameterSpec;
import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.ContentType;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeHash;
import com.tencent.kona.sun.security.ssl.HandshakeOutStream;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.NewSessionTicket;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.SSLConsumer;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLSessionContextImpl;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.TLCPChangeCipherSpec;
import com.tencent.kona.sun.security.ssl.Utilities;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.ProviderException;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

final class TLCPFinished {
    static final SSLConsumer tlcpHandshakeConsumer = new TLCPFinishedConsumer();
    static final HandshakeProducer tlcpHandshakeProducer = new TLCPFinishedProducer();

    TLCPFinished() {
    }

    static final class TLCPFinishedProducer
    implements HandshakeProducer {
        private TLCPFinishedProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            HandshakeContext hc = (HandshakeContext)context;
            if (hc.sslConfig.isClientMode) {
                return this.onProduceFinished((ClientHandshakeContext)context, message);
            }
            return this.onProduceFinished((ServerHandshakeContext)context, message);
        }

        private byte[] onProduceFinished(ClientHandshakeContext chc, SSLHandshake.HandshakeMessage message) throws IOException {
            chc.handshakeHash.update();
            FinishedMessage fm = new FinishedMessage(chc);
            TLCPChangeCipherSpec.tlcpProducer.produce(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced client Finished handshake message", (Object[])new Object[]{fm});
            }
            fm.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            if (chc.conContext.secureRenegotiation) {
                chc.conContext.clientVerifyData = fm.verifyData;
            }
            if (chc.statelessResumption) {
                chc.handshakeConsumers.put(SSLHandshake.NEW_SESSION_TICKET.id, SSLHandshake.NEW_SESSION_TICKET);
            }
            if (!chc.isResumption) {
                chc.conContext.consumers.put(ContentType.CHANGE_CIPHER_SPEC.id, TLCPChangeCipherSpec.tlcpConsumer);
                chc.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
                chc.conContext.inputRecord.expectingFinishFlight();
            } else {
                if (chc.handshakeSession.isRejoinable()) {
                    ((SSLSessionContextImpl)chc.sslContext.engineGetClientSessionContext()).put(chc.handshakeSession);
                }
                chc.conContext.conSession = chc.handshakeSession.finish();
                chc.conContext.protocolVersion = chc.negotiatedProtocol;
                chc.handshakeFinished = true;
                if (!chc.sslContext.isDTLS()) {
                    chc.conContext.finishHandshake();
                }
            }
            return null;
        }

        private byte[] onProduceFinished(ServerHandshakeContext shc, SSLHandshake.HandshakeMessage message) throws IOException {
            if (shc.statelessResumption) {
                NewSessionTicket.handshake12Producer.produce(shc, message);
            }
            shc.handshakeHash.update();
            FinishedMessage fm = new FinishedMessage(shc);
            TLCPChangeCipherSpec.tlcpProducer.produce(shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced server Finished handshake message", (Object[])new Object[]{fm});
            }
            fm.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            if (shc.conContext.secureRenegotiation) {
                shc.conContext.serverVerifyData = fm.verifyData;
            }
            if (shc.isResumption) {
                shc.conContext.consumers.put(ContentType.CHANGE_CIPHER_SPEC.id, TLCPChangeCipherSpec.tlcpConsumer);
                shc.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
                shc.conContext.inputRecord.expectingFinishFlight();
            } else {
                if (shc.statelessResumption && shc.handshakeSession.isStatelessable()) {
                    shc.handshakeSession.setContext((SSLSessionContextImpl)shc.sslContext.engineGetServerSessionContext());
                } else if (shc.handshakeSession.isRejoinable()) {
                    ((SSLSessionContextImpl)shc.sslContext.engineGetServerSessionContext()).put(shc.handshakeSession);
                }
                shc.conContext.conSession = shc.handshakeSession.finish();
                shc.conContext.protocolVersion = shc.negotiatedProtocol;
                shc.handshakeFinished = true;
                if (!shc.sslContext.isDTLS()) {
                    shc.conContext.finishHandshake();
                }
            }
            return null;
        }
    }

    static final class TLCPFinishedConsumer
    implements SSLConsumer {
        private TLCPFinishedConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            HandshakeContext hc = (HandshakeContext)context;
            hc.handshakeConsumers.remove(SSLHandshake.FINISHED.id);
            if (hc.conContext.consumers.containsKey(ContentType.CHANGE_CIPHER_SPEC.id)) {
                throw hc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Missing ChangeCipherSpec message");
            }
            if (hc.sslConfig.isClientMode) {
                this.onConsumeFinished((ClientHandshakeContext)context, message);
            } else {
                this.onConsumeFinished((ServerHandshakeContext)context, message);
            }
        }

        private void onConsumeFinished(ClientHandshakeContext chc, ByteBuffer message) throws IOException {
            SSLHandshake[] probableHandshakeMessages;
            FinishedMessage fm = new FinishedMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Consuming server Finished handshake message", (Object[])new Object[]{fm});
            }
            if (chc.conContext.secureRenegotiation) {
                chc.conContext.serverVerifyData = fm.verifyData;
            }
            if (!chc.isResumption) {
                if (chc.handshakeSession.isRejoinable()) {
                    ((SSLSessionContextImpl)chc.sslContext.engineGetClientSessionContext()).put(chc.handshakeSession);
                }
                chc.conContext.conSession = chc.handshakeSession.finish();
                chc.conContext.protocolVersion = chc.negotiatedProtocol;
                chc.handshakeFinished = true;
                if (!chc.sslContext.isDTLS()) {
                    chc.conContext.finishHandshake();
                }
            } else {
                chc.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            }
            for (SSLHandshake hs : probableHandshakeMessages = new SSLHandshake[]{SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)chc.handshakeProducers.remove(hs.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(chc, fm);
            }
        }

        private void onConsumeFinished(ServerHandshakeContext shc, ByteBuffer message) throws IOException {
            SSLHandshake[] probableHandshakeMessages;
            if (!shc.isResumption && shc.handshakeConsumers.containsKey(SSLHandshake.CERTIFICATE_VERIFY.id)) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected Finished handshake message");
            }
            FinishedMessage fm = new FinishedMessage(shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Consuming client Finished handshake message", (Object[])new Object[]{fm});
            }
            if (shc.conContext.secureRenegotiation) {
                shc.conContext.clientVerifyData = fm.verifyData;
            }
            if (shc.isResumption) {
                if (shc.handshakeSession.isRejoinable() && !shc.statelessResumption) {
                    ((SSLSessionContextImpl)shc.sslContext.engineGetServerSessionContext()).put(shc.handshakeSession);
                }
                shc.conContext.conSession = shc.handshakeSession.finish();
                shc.conContext.protocolVersion = shc.negotiatedProtocol;
                shc.handshakeFinished = true;
                if (!shc.sslContext.isDTLS()) {
                    shc.conContext.finishHandshake();
                }
            } else {
                shc.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            }
            for (SSLHandshake hs : probableHandshakeMessages = new SSLHandshake[]{SSLHandshake.FINISHED}) {
                HandshakeProducer handshakeProducer = (HandshakeProducer)shc.handshakeProducers.remove(hs.id);
                if (handshakeProducer == null) continue;
                handshakeProducer.produce(shc, fm);
            }
        }
    }

    private static final class TLCP11VerifyDataGenerator
    implements VerifyDataGenerator {
        private TLCP11VerifyDataGenerator() {
        }

        @Override
        public byte[] createVerifyData(HandshakeContext context, boolean isValidation) throws IOException {
            HandshakeHash handshakeHash = context.handshakeHash;
            SecretKey masterSecretKey = context.handshakeSession.getMasterSecret();
            boolean useClientLabel = context.sslConfig.isClientMode && !isValidation || !context.sslConfig.isClientMode && isValidation;
            String tlcpLabel = useClientLabel ? "client finished" : "server finished";
            try {
                byte[] seed = handshakeHash.digest();
                String prfAlg = "TlcpPrf";
                CipherSuite.HashAlg hashAlg = CipherSuite.HashAlg.H_SM3;
                TlsPrfParameterSpec spec = new TlsPrfParameterSpec(masterSecretKey, tlcpLabel, seed, 12, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
                KeyGenerator kg = CryptoInsts.getKeyGenerator((String)prfAlg);
                kg.init(spec);
                SecretKey prfKey = kg.generateKey();
                if (!"RAW".equals(prfKey.getFormat())) {
                    throw new ProviderException("Invalid PRF output, format must be RAW. Format received: " + prfKey.getFormat());
                }
                return prfKey.getEncoded();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("PRF failed", e);
            }
        }
    }

    static enum VerifyDataScheme {
        TLCP11("kdf_tlcp11", new TLCP11VerifyDataGenerator());

        final String name;
        final VerifyDataGenerator generator;

        private VerifyDataScheme(String name, VerifyDataGenerator verifyDataGenerator) {
            this.name = name;
            this.generator = verifyDataGenerator;
        }

        static VerifyDataScheme valueOf(ProtocolVersion protocolVersion) {
            switch (protocolVersion) {
                case TLCP11: {
                    return TLCP11;
                }
            }
            return null;
        }

        public byte[] createVerifyData(HandshakeContext context, boolean isValidation) throws IOException {
            if (this.generator != null) {
                return this.generator.createVerifyData(context, isValidation);
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static interface VerifyDataGenerator {
        public byte[] createVerifyData(HandshakeContext var1, boolean var2) throws IOException;
    }

    private static final class FinishedMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] verifyData;

        FinishedMessage(HandshakeContext context) throws IOException {
            super(context);
            byte[] vd;
            VerifyDataScheme vds = VerifyDataScheme.valueOf(context.negotiatedProtocol);
            try {
                vd = vds.createVerifyData(context, false);
            }
            catch (IOException ioe) {
                throw context.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Failed to generate verify_data", ioe);
            }
            this.verifyData = vd;
        }

        FinishedMessage(HandshakeContext context, ByteBuffer m) throws IOException {
            super(context);
            byte[] myVerifyData;
            int verifyDataLen = 12;
            if (context.negotiatedProtocol == ProtocolVersion.SSL30) {
                verifyDataLen = 36;
            } else if (context.negotiatedProtocol.useTLS13PlusSpec()) {
                verifyDataLen = context.negotiatedCipherSuite.hashAlg.hashLength;
            }
            if (m.remaining() != verifyDataLen) {
                throw context.conContext.fatal(Alert.DECODE_ERROR, "Inappropriate finished message: need " + verifyDataLen + " but remaining " + m.remaining() + " bytes verify_data");
            }
            this.verifyData = new byte[verifyDataLen];
            m.get(this.verifyData);
            VerifyDataScheme vd = VerifyDataScheme.valueOf(context.negotiatedProtocol);
            try {
                myVerifyData = vd.createVerifyData(context, true);
            }
            catch (IOException ioe) {
                throw context.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Failed to generate verify_data", ioe);
            }
            if (!MessageDigest.isEqual(myVerifyData, this.verifyData)) {
                throw context.conContext.fatal(Alert.DECRYPT_ERROR, "The Finished message cannot be verified.");
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.FINISHED;
        }

        @Override
        public int messageLength() {
            return this.verifyData.length;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.write(this.verifyData);
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"Finished\": '{'\n  \"verify data\": '{'\n{0}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent((String)hexEncoder.encode(this.verifyData), (String)"    ")};
            return messageFormat.format(messageFields);
        }
    }
}

