/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.ssl.HandshakeHash;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class TLCPHandshakeHash
implements HandshakeHash.TranscriptHash {
    private final HandshakeHash.TranscriptHash transcriptHash;
    private final ByteArrayOutputStream baos;

    TLCPHandshakeHash() {
        MessageDigest md = null;
        try {
            md = CryptoInsts.getMessageDigest((String)"SM3");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SM3 is not supported", e);
        }
        if (md instanceof Cloneable) {
            this.transcriptHash = new HandshakeHash.CloneableHash(md);
            this.baos = new ByteArrayOutputStream();
        } else {
            this.transcriptHash = new HandshakeHash.NonCloneableHash(md);
            this.baos = null;
        }
    }

    @Override
    public void update(byte[] input, int offset, int length) {
        this.transcriptHash.update(input, offset, length);
        if (this.baos != null) {
            this.baos.write(input, offset, length);
        }
    }

    @Override
    public byte[] digest() {
        return this.transcriptHash.digest();
    }

    @Override
    public byte[] archived() {
        if (this.baos != null) {
            return this.baos.toByteArray();
        }
        return this.transcriptHash.archived();
    }
}

