/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ssl;

import com.tencent.kona.sun.security.ssl.Alert;
import com.tencent.kona.sun.security.ssl.CipherSuite;
import com.tencent.kona.sun.security.ssl.ClientAuthType;
import com.tencent.kona.sun.security.ssl.ClientHandshakeContext;
import com.tencent.kona.sun.security.ssl.ClientHello;
import com.tencent.kona.sun.security.ssl.ConnectionContext;
import com.tencent.kona.sun.security.ssl.ContentType;
import com.tencent.kona.sun.security.ssl.HandshakeConsumer;
import com.tencent.kona.sun.security.ssl.HandshakeContext;
import com.tencent.kona.sun.security.ssl.HandshakeProducer;
import com.tencent.kona.sun.security.ssl.ProtocolVersion;
import com.tencent.kona.sun.security.ssl.RandomCookie;
import com.tencent.kona.sun.security.ssl.SSLExtension;
import com.tencent.kona.sun.security.ssl.SSLHandshake;
import com.tencent.kona.sun.security.ssl.SSLKeyExchange;
import com.tencent.kona.sun.security.ssl.SSLLogger;
import com.tencent.kona.sun.security.ssl.SSLPossession;
import com.tencent.kona.sun.security.ssl.SSLSessionImpl;
import com.tencent.kona.sun.security.ssl.SSLTrafficKeyDerivation;
import com.tencent.kona.sun.security.ssl.ServerHandshakeContext;
import com.tencent.kona.sun.security.ssl.ServerHello;
import com.tencent.kona.sun.security.ssl.SessionId;
import com.tencent.kona.sun.security.ssl.SignatureScheme;
import com.tencent.kona.sun.security.ssl.StatusResponseManager;
import com.tencent.kona.sun.security.ssl.TLCPChangeCipherSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;

final class TLCPServerHello {
    static final HandshakeProducer tlcpHandshakeProducer = new TLCPServerHelloProducer();
    static final HandshakeConsumer tlcpHandshakeConsumer = new TLCPServerHelloConsumer();

    TLCPServerHello() {
    }

    private static final class TLCPServerHelloConsumer
    implements HandshakeConsumer {
        private TLCPServerHelloConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            ServerHello.ServerHelloMessage serverHello = (ServerHello.ServerHelloMessage)message;
            if (!chc.isNegotiable(serverHello.serverVersion)) {
                throw chc.conContext.fatal(Alert.PROTOCOL_VERSION, "Server chose " + (Object)((Object)serverHello.serverVersion) + ", but that protocol version is not enabled or not supported by the client.");
            }
            chc.negotiatedCipherSuite = serverHello.cipherSuite;
            chc.handshakeHash.determine(chc.negotiatedProtocol, chc.negotiatedCipherSuite);
            chc.serverHelloRandom = serverHello.serverRandom;
            if (chc.negotiatedCipherSuite.keyExchange == null) {
                throw chc.conContext.fatal(Alert.PROTOCOL_VERSION, "TLCP does not support the server cipher suite: " + chc.negotiatedCipherSuite.name);
            }
            SSLExtension[] extTypes = new SSLExtension[]{SSLExtension.SH_RENEGOTIATION_INFO};
            serverHello.extensions.consumeOnLoad(chc, extTypes);
            if (chc.resumingSession != null) {
                if (serverHello.sessionId.equals(chc.resumingSession.getSessionId())) {
                    CipherSuite sessionSuite = chc.resumingSession.getSuite();
                    if (chc.negotiatedCipherSuite != sessionSuite) {
                        throw chc.conContext.fatal(Alert.PROTOCOL_VERSION, "Server returned wrong cipher suite for session");
                    }
                    ProtocolVersion sessionVersion = chc.resumingSession.getProtocolVersion();
                    if (chc.negotiatedProtocol != sessionVersion) {
                        throw chc.conContext.fatal(Alert.PROTOCOL_VERSION, "Server resumed with wrong protocol version");
                    }
                    chc.isResumption = true;
                    chc.resumingSession.setAsSessionResumption(true);
                    chc.handshakeSession = chc.resumingSession;
                } else {
                    chc.resumingSession.invalidate();
                    chc.resumingSession = null;
                    chc.isResumption = false;
                    if (!chc.sslConfig.enableSessionCreation) {
                        throw chc.conContext.fatal(Alert.PROTOCOL_VERSION, "New session creation is disabled");
                    }
                }
            }
            extTypes = chc.sslConfig.getEnabledExtensions(SSLHandshake.SERVER_HELLO);
            serverHello.extensions.consumeOnLoad(chc, extTypes);
            if (!chc.isResumption) {
                if (chc.resumingSession != null) {
                    chc.resumingSession.invalidate();
                    chc.resumingSession = null;
                }
                if (!chc.sslConfig.enableSessionCreation) {
                    throw chc.conContext.fatal(Alert.PROTOCOL_VERSION, "New session creation is disabled");
                }
                if (serverHello.sessionId.length() == 0 && chc.statelessResumption) {
                    SessionId newId = new SessionId(true, chc.sslContext.getSecureRandom());
                    chc.handshakeSession = new SSLSessionImpl(chc, chc.negotiatedCipherSuite, newId);
                    if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                        SSLLogger.fine((String)("Locally assigned Session Id: " + newId.toString()), (Object[])new Object[0]);
                    }
                } else {
                    chc.handshakeSession = new SSLSessionImpl(chc, chc.negotiatedCipherSuite, serverHello.sessionId);
                }
                chc.handshakeSession.setMaximumPacketSize(chc.sslConfig.maximumPacketSize);
            }
            serverHello.extensions.consumeOnTrade(chc, extTypes);
            if (chc.isResumption) {
                SSLTrafficKeyDerivation kdg = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
                if (kdg == null) {
                    throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
                }
                chc.handshakeKeyDerivation = kdg.createKeyDerivation(chc, chc.resumingSession.getMasterSecret());
                if (chc.statelessResumption) {
                    chc.handshakeConsumers.putIfAbsent(SSLHandshake.NEW_SESSION_TICKET.id, SSLHandshake.NEW_SESSION_TICKET);
                }
                chc.conContext.consumers.putIfAbsent(ContentType.CHANGE_CIPHER_SPEC.id, TLCPChangeCipherSpec.tlcpConsumer);
                chc.handshakeConsumers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            } else {
                SSLKeyExchange ke;
                chc.handshakeKeyExchange = ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
                if (ke != null) {
                    for (SSLHandshake handshake : ke.getRelatedHandshakers(chc)) {
                        chc.handshakeConsumers.put(handshake.id, handshake);
                    }
                }
                chc.handshakeConsumers.put(SSLHandshake.SERVER_HELLO_DONE.id, SSLHandshake.SERVER_HELLO_DONE);
            }
        }
    }

    private static final class TLCPServerHelloProducer
    implements HandshakeProducer {
        private TLCPServerHelloProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            ClientHello.ClientHelloMessage clientHello = (ClientHello.ClientHelloMessage)message;
            if (!shc.isResumption || shc.resumingSession == null) {
                if (!shc.sslConfig.enableSessionCreation) {
                    throw new SSLException("Not resumption, and no new session is allowed");
                }
                if (shc.localSupportedSignAlgs == null) {
                    shc.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(shc.sslConfig, shc.algorithmConstraints, shc.activeProtocols);
                }
                SSLSessionImpl session = new SSLSessionImpl((HandshakeContext)shc, CipherSuite.C_NULL);
                session.setMaximumPacketSize(shc.sslConfig.maximumPacketSize);
                shc.handshakeSession = session;
                SSLExtension[] enabledExtensions = shc.sslConfig.getEnabledExtensions(SSLHandshake.CLIENT_HELLO, shc.negotiatedProtocol);
                clientHello.extensions.consumeOnTrade(shc, enabledExtensions);
                KeyExchangeProperties credentials = TLCPServerHelloProducer.chooseCipherSuite(shc, clientHello);
                if (credentials == null) {
                    throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "no cipher suites in common");
                }
                shc.negotiatedCipherSuite = credentials.cipherSuite;
                shc.handshakeKeyExchange = credentials.keyExchange;
                shc.handshakeSession.setSuite(credentials.cipherSuite);
                shc.handshakePossessions.addAll(Arrays.asList(credentials.possessions));
                shc.handshakeHash.determine(shc.negotiatedProtocol, shc.negotiatedCipherSuite);
                shc.stapleParams = StatusResponseManager.processStapling(shc);
                shc.staplingActive = shc.stapleParams != null;
                SSLKeyExchange ke = credentials.keyExchange;
                if (ke != null) {
                    for (Map.Entry<Byte, HandshakeProducer> me : ke.getHandshakeProducers(shc)) {
                        shc.handshakeProducers.put(me.getKey(), me.getValue());
                    }
                }
                if (!(ke == null || shc.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_NONE && shc.negotiatedCipherSuite != CipherSuite.TLCP_ECDHE_SM4_GCM_SM3 && shc.negotiatedCipherSuite != CipherSuite.TLCP_ECDHE_SM4_CBC_SM3 || shc.negotiatedCipherSuite.isAnonymous())) {
                    for (SSLHandshake hs : ke.getRelatedHandshakers(shc)) {
                        if (hs != SSLHandshake.CERTIFICATE) continue;
                        shc.handshakeProducers.put(SSLHandshake.CERTIFICATE_REQUEST.id, SSLHandshake.CERTIFICATE_REQUEST);
                        break;
                    }
                }
                shc.handshakeProducers.put(SSLHandshake.SERVER_HELLO_DONE.id, SSLHandshake.SERVER_HELLO_DONE);
            } else {
                if (shc.statelessResumption) {
                    shc.resumingSession = new SSLSessionImpl(shc.resumingSession, clientHello.sessionId.length() == 0 ? new SessionId(true, shc.sslContext.getSecureRandom()) : new SessionId(clientHello.sessionId.getId()));
                }
                shc.handshakeSession = shc.resumingSession;
                shc.negotiatedProtocol = shc.resumingSession.getProtocolVersion();
                shc.negotiatedCipherSuite = shc.resumingSession.getSuite();
                shc.handshakeHash.determine(shc.negotiatedProtocol, shc.negotiatedCipherSuite);
            }
            ServerHello.ServerHelloMessage shm = new ServerHello.ServerHelloMessage(shc, shc.negotiatedProtocol, shc.handshakeSession.getSessionId(), shc.negotiatedCipherSuite, new RandomCookie(shc), clientHello);
            shc.serverHelloRandom = shm.serverRandom;
            SSLExtension[] serverHelloExtensions = shc.sslConfig.getEnabledExtensions(SSLHandshake.SERVER_HELLO, shc.negotiatedProtocol);
            shm.extensions.produce(shc, serverHelloExtensions);
            if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                SSLLogger.fine((String)"Produced ServerHello handshake message", (Object[])new Object[]{shm});
            }
            shm.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            if (shc.isResumption && shc.resumingSession != null) {
                SSLTrafficKeyDerivation kdg = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
                if (kdg == null) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
                }
                shc.handshakeKeyDerivation = kdg.createKeyDerivation(shc, shc.resumingSession.getMasterSecret());
                shc.handshakeProducers.put(SSLHandshake.FINISHED.id, SSLHandshake.FINISHED);
            }
            return null;
        }

        private static KeyExchangeProperties chooseCipherSuite(ServerHandshakeContext shc, ClientHello.ClientHelloMessage clientHello) throws IOException {
            List proposed;
            List<CipherSuite> preferred;
            if (shc.sslConfig.preferLocalCipherSuites) {
                preferred = shc.activeCipherSuites;
                proposed = clientHello.cipherSuites;
            } else {
                preferred = clientHello.cipherSuites;
                proposed = shc.activeCipherSuites;
            }
            for (CipherSuite cs : preferred) {
                SSLPossession[] hcds;
                SSLKeyExchange ke;
                if (!HandshakeContext.isNegotiable(proposed, shc.negotiatedProtocol, cs) || shc.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED && (cs.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || cs.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) || (ke = SSLKeyExchange.valueOf(cs.keyExchange, shc.negotiatedProtocol)) == null || (hcds = ke.createPossessions(shc)) == null || hcds.length == 0) continue;
                if (SSLLogger.isOn && SSLLogger.isOn((String)"ssl,handshake")) {
                    SSLLogger.fine((String)("use cipher suite " + cs.name), (Object[])new Object[0]);
                }
                return new KeyExchangeProperties(cs, ke, hcds);
            }
            throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "no cipher suites in common");
        }

        private static final class KeyExchangeProperties {
            final CipherSuite cipherSuite;
            final SSLKeyExchange keyExchange;
            final SSLPossession[] possessions;

            private KeyExchangeProperties(CipherSuite cipherSuite, SSLKeyExchange keyExchange, SSLPossession[] possessions) {
                this.cipherSuite = cipherSuite;
                this.keyExchange = keyExchange;
                this.possessions = possessions;
            }
        }
    }
}

