/*
 * Decompiled with CFR 0.152.
 */
package cn.code.boxes.credits.sdk.utils;

import cn.code.boxes.credits.sdk.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.security.MessageDigest;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignTool {
    private static final Logger LOG = LoggerFactory.getLogger(SignTool.class);

    public static JSONObject fillBasicParamsAndSign(Object obj, String appKey, String appSecret) {
        JSONObject paramJson = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        paramJson.fluentPut("appKey", (Object)appKey).fluentPut("appSecret", (Object)appSecret).fluentPut("timestamp", (Object)String.valueOf(System.currentTimeMillis()));
        paramJson.put("sign", (Object)SignTool.generateMD5Sign(paramJson));
        paramJson.remove((Object)"appSecret");
        return paramJson;
    }

    public static boolean signVerify(Object obj, String appKey, String appSecret, String timestamp, String sign) {
        if (StringUtil.isEmpty(sign)) {
            return false;
        }
        JSONObject paramJson = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        paramJson.fluentPut("appKey", (Object)appKey).fluentPut("appSecret", (Object)appSecret).fluentPut("timestamp", (Object)timestamp);
        String newSign = SignTool.generateMD5Sign(paramJson);
        return sign.equals(newSign);
    }

    private static String generateMD5Sign(JSONObject jsonObject) {
        try {
            TreeMap<String, Object> sortedParams = new TreeMap<String, Object>();
            jsonObject.forEach((key, value) -> {
                if (value instanceof JSONObject || value instanceof JSONArray) {
                    sortedParams.put((String)key, JSONObject.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}));
                } else if (!"domain".equals(key)) {
                    sortedParams.put((String)key, value);
                }
            });
            StringBuilder signatureBuilder = new StringBuilder();
            sortedParams.forEach((key, value) -> signatureBuilder.append(value));
            String signatureStr = signatureBuilder.toString();
            System.out.println("MD5 signatureStr: " + signatureStr);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = digest.digest(signatureStr.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            LOG.warn("generate md5 sign fail...", (Throwable)e);
            return null;
        }
    }
}

