/*
 * Decompiled with CFR 0.152.
 */
package cn.code.boxes.credits.sdk.core;

import cn.code.boxes.credits.sdk.core.GlobalConfig;
import cn.code.boxes.credits.sdk.core.SupplierOpClient;
import cn.code.boxes.credits.sdk.core.SupplierOpClientHolder;
import cn.code.boxes.credits.sdk.core.SupplierOpConfig;
import cn.code.boxes.credits.sdk.core.SupplierOpRequestExecutor;
import cn.code.boxes.credits.sdk.core.SupplierOpResponse;
import cn.code.boxes.credits.sdk.core.SupplierOpResponseWrapper;
import cn.code.boxes.credits.sdk.core.http.HttpMethod;
import cn.code.boxes.credits.sdk.exception.SupplierOpException;
import cn.code.boxes.credits.sdk.utils.StringUtil;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SupplierOpRequest<R>
implements SupplierOpRequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SupplierOpRequest.class);
    private SupplierOpClient client = SupplierOpClientHolder.getClient();
    private SupplierOpConfig config = GlobalConfig.getGlobalConfig();
    private R param;

    public abstract String getUrlPath();

    public abstract HttpMethod getHttpMethod();

    public SupplierOpRequest() {
        Class<?> paramClass = this.getSuperClassParameterClass(this.getClass());
        try {
            this.param = paramClass.newInstance();
        }
        catch (Exception e) {
            throw new SupplierOpException(SupplierOpException.Code.INIT_REQUEST_PARAM_ERROR, e);
        }
    }

    public abstract Class<? extends SupplierOpResponse<?>> getResponseClass();

    public <T> T execute() {
        long now = System.currentTimeMillis();
        SupplierOpResponseWrapper ret = this.client.request(this);
        LOG.info("request total cost: {}, response:{}", (Object)(System.currentTimeMillis() - now), ret.getResponse());
        return ret.getResponse();
    }

    public <T> Future<T> asyncExecute() {
        Future wrapperFuture = this.client.asyncRequest(this);
        return new FutureAdapter(wrapperFuture);
    }

    private Class<?> getSuperClassParameterClass(Class<?> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new SupplierOpException(e);
        }
    }

    private void resetOpenUrl() {
        String openUrl = System.getProperty("cloud.open.url");
        if (StringUtil.isNotEmpty(openUrl)) {
            this.getConfig().setOpenRequestUrl(openUrl);
        }
        if (StringUtil.isNotEmpty(openUrl = System.getenv("cloud.open.url"))) {
            this.getConfig().setOpenRequestUrl(openUrl);
        }
    }

    public SupplierOpClient getClient() {
        return this.client;
    }

    public SupplierOpConfig getConfig() {
        return this.config;
    }

    public void setConfig(SupplierOpConfig config) {
        this.config = config;
    }

    public void setClient(SupplierOpClient client) {
        this.client = client;
    }

    public R getParam() {
        return this.param;
    }

    public void setParam(R param) {
        this.param = param;
    }

    static class FutureAdapter<T>
    implements Future<T> {
        private Future<SupplierOpResponseWrapper<T>> future;

        FutureAdapter(Future<SupplierOpResponseWrapper<T>> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.future.get().getResponse();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit).getResponse();
        }
    }
}

