/*
 * Decompiled with CFR 0.152.
 */
package cn.code.boxes.credits.sdk.core.http;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private String url;
    private Map<String, String> headerMap;
    private String body;
    private byte[] bodyBytes;
    static ImmutableSet<String> BASIC_PARAM_SET = ImmutableSet.of((Object)"appKey", (Object)"timestamp", (Object)"sign");
    private int connectTimeout = 5000;
    private int readTimeout = 5000;

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    public static HttpRequest build(String url) {
        return new HttpRequest(url);
    }

    public static String buildGetUrl(String urlPar, JSONObject params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (!str.toString().endsWith("?")) {
            if (str.toString().contains("?")) {
                str.append("&");
            } else {
                str.append("?");
            }
        }
        for (Map.Entry entry : params.entrySet()) {
            try {
                if (entry.getValue() == null) {
                    str.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append((String)entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "utf-8")).append("&");
            }
            catch (Exception exception) {}
        }
        return str.toString();
    }

    public static String buildGetUrlGbk(String urlPar, JSONObject params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (!str.toString().endsWith("?")) {
            if (str.toString().contains("?")) {
                str.append("&");
            } else {
                str.append("?");
            }
        }
        for (Map.Entry entry : params.entrySet()) {
            try {
                if (entry.getValue() == null) {
                    str.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append((String)entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "gbk")).append("&");
            }
            catch (Exception exception) {}
        }
        return str.toString();
    }

    public static String buildPostUrl(String urlPar, JSONObject params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (!str.toString().endsWith("?")) {
            if (str.toString().contains("?")) {
                str.append("&");
            } else {
                str.append("?");
            }
        }
        for (Map.Entry entry : params.entrySet()) {
            if (!BASIC_PARAM_SET.contains(entry.getKey())) continue;
            try {
                if (entry.getValue() == null) {
                    str.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
                    continue;
                }
                str.append((String)entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "utf-8")).append("&");
            }
            catch (Exception exception) {}
        }
        return str.toString();
    }

    public static HttpRequest build(String url, String body) {
        HttpRequest request = new HttpRequest(url);
        request.setBody(body);
        return request;
    }

    public static HttpRequest build(String url, byte[] body) {
        HttpRequest request = new HttpRequest(url);
        request.setBodyBytes(body);
        return request;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public HttpRequest(String url) {
        this.url = url;
        this.headerMap = new HashMap<String, String>();
    }

    public void addHeader(String key, String value) {
        this.headerMap.put(key, value);
    }

    public void addHeader(Map<String, String> headerMap) {
        this.headerMap.putAll(headerMap);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

