/*
 * Decompiled with CFR 0.152.
 */
package cn.code.boxes.credits.sdk.core;

import cn.code.boxes.credits.sdk.core.ParameterChecker;
import cn.code.boxes.credits.sdk.core.SupplierOpClient;
import cn.code.boxes.credits.sdk.core.SupplierOpRequest;
import cn.code.boxes.credits.sdk.core.SupplierOpResponse;
import cn.code.boxes.credits.sdk.core.SupplierOpResponseWrapper;
import cn.code.boxes.credits.sdk.core.http.DefaultHttpClient;
import cn.code.boxes.credits.sdk.core.http.HttpClient;
import cn.code.boxes.credits.sdk.core.http.HttpMethod;
import cn.code.boxes.credits.sdk.core.http.HttpRequest;
import cn.code.boxes.credits.sdk.core.http.HttpResponse;
import cn.code.boxes.credits.sdk.core.threadpool.SupplierOpThreadPool;
import cn.code.boxes.credits.sdk.exception.SupplierOpException;
import cn.code.boxes.credits.sdk.utils.SignTool;
import cn.code.boxes.credits.sdk.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSupplierOpClient
implements SupplierOpClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSupplierOpClient.class);
    private static final DefaultSupplierOpClient DEFAULT_Supplier_OP_CLIENT = new DefaultSupplierOpClient();
    private HttpClient httpClient = DefaultHttpClient.getDefaultClient();

    @Override
    public <T, R> SupplierOpResponseWrapper<T> request(SupplierOpRequest<R> request) {
        if (request.getHttpMethod() != HttpMethod.GET && request.getHttpMethod() != HttpMethod.POST) {
            throw new SupplierOpException(SupplierOpException.Code.UNSUPPORTED_HTTP_METHOD, "method name -> " + request.getHttpMethod().name());
        }
        return this.doRequest(request);
    }

    private <T, R> SupplierOpResponseWrapper<T> doRequest(SupplierOpRequest<R> request) {
        HttpResponse httpResponse;
        ParameterChecker.check(request.getParam());
        String appKey = request.getConfig().getAppKey();
        JSONObject paramJson = SignTool.fillBasicParamsAndSign(request.getParam(), appKey, request.getConfig().getAppSecret());
        String openRequestUrl = request.getConfig().getOpenRequestUrl();
        if (StringUtil.isNotEmpty(paramJson.getString("domain"))) {
            openRequestUrl = paramJson.getString("domain");
        }
        String requestUrl = openRequestUrl + request.getUrlPath();
        LOG.info("supplier sdk request, url:{}, params:{}", (Object)requestUrl, (Object)JSON.toJSONString((Object)paramJson));
        if (request.getHttpMethod() == HttpMethod.GET) {
            String url = HttpRequest.buildGetUrl(requestUrl, paramJson);
            HttpRequest httpRequest = new HttpRequest(url);
            httpResponse = this.httpClient.get(httpRequest);
        } else {
            requestUrl = HttpRequest.buildPostUrl(requestUrl, paramJson);
            HttpRequest httpRequest = HttpRequest.build(requestUrl, JSON.toJSONString(request.getParam()));
            httpResponse = this.httpClient.post(httpRequest);
        }
        if (httpResponse.getStatusCode() != 200) {
            throw new SupplierOpException(SupplierOpException.Code.HTTP_RESPONSE_STATUS_CODE_NOT_2XX);
        }
        String httpBody = httpResponse.getBody();
        LOG.info("supplier sdk response, url:{}, resp:{}", (Object)requestUrl, (Object)httpBody);
        if (httpBody == null || "".equals(httpBody)) {
            httpBody = "{}";
        }
        try {
            SupplierOpResponse response = (SupplierOpResponse)JSON.parseObject((String)httpBody, request.getResponseClass());
            SupplierOpResponseWrapper<SupplierOpResponse> responseWrapper = new SupplierOpResponseWrapper<SupplierOpResponse>();
            responseWrapper.setResponse(response);
            return responseWrapper;
        }
        catch (Exception e) {
            throw new SupplierOpException(SupplierOpException.Code.JSON_ERROR, e);
        }
    }

    @Override
    public <T, R> Future<SupplierOpResponseWrapper<T>> asyncRequest(final SupplierOpRequest<R> request) {
        return SupplierOpThreadPool.getInstance().submit(new Callable<SupplierOpResponseWrapper<T>>(){

            @Override
            public SupplierOpResponseWrapper<T> call() throws Exception {
                return DefaultSupplierOpClient.this.request(request);
            }
        });
    }

    public static DefaultSupplierOpClient getDefaultClient() {
        return DEFAULT_Supplier_OP_CLIENT;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

