/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.gradle.ExtraDirectoryParameters;
import com.google.cloud.tools.jib.gradle.GradleHelpfulSuggestions;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.GradleRawConfiguration;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidCreationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidFilesModificationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidPlatformException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildTarTask
extends DefaultTask
implements JibTask {
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Building image tarball failed";
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @InputFiles
    public FileCollection getInputFiles() {
        List<Path> extraDirectories = ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getExtraDirectories().getPaths().stream().map(ExtraDirectoryParameters::getFrom).collect(Collectors.toList());
        return GradleProjectProperties.getInputFiles(this.getProject(), extraDirectories);
    }

    @OutputFile
    public String getOutputFile() {
        return ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getOutputPaths().getTarPath().toString();
    }

    @TaskAction
    public void buildTar() throws BuildStepsExecutionException, IOException, CacheDirectoryCreationException, MainClassInferenceException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        TaskCommon.disableHttpLogging();
        TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();
        GradleProjectProperties projectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), tempDirectoryProvider);
        Future<Optional<String>> updateCheckFuture = TaskCommon.newUpdateChecker(projectProperties, this.getLogger());
        try {
            PluginConfigurationProcessor.createJibBuildRunnerForTarImage(new GradleRawConfiguration(this.jibExtension), ignored -> Optional.empty(), projectProperties, new GradleHelpfulSuggestions(HELPFUL_SUGGESTIONS_PREFIX)).runBuild();
        }
        catch (InvalidAppRootException ex) {
            throw new GradleException("container.appRoot is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Throwable)ex);
        }
        catch (InvalidContainerizingModeException ex) {
            throw new GradleException("invalid value for containerizingMode: " + ex.getInvalidContainerizingMode(), (Throwable)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new GradleException("container.workingDirectory is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Throwable)ex);
        }
        catch (InvalidPlatformException ex) {
            throw new GradleException("from.platforms contains a platform configuration that is missing required values or has invalid values: " + ex.getMessage() + ": " + ex.getInvalidPlatform(), (Throwable)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new GradleException("container.volumes is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Throwable)ex);
        }
        catch (InvalidFilesModificationTimeException ex) {
            throw new GradleException("container.filesModificationTime should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or special keyword \"EPOCH_PLUS_SECOND\": " + ex.getInvalidFilesModificationTime(), (Throwable)ex);
        }
        catch (InvalidCreationTimeException ex) {
            throw new GradleException("container.creationTime should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or a special keyword (\"EPOCH\", \"USE_CURRENT_TIMESTAMP\"): " + ex.getInvalidCreationTime(), (Throwable)ex);
        }
        catch (JibPluginExtensionException ex) {
            String extensionName = ex.getExtensionClass().getName();
            throw new GradleException("error running extension '" + extensionName + "': " + ex.getMessage(), (Throwable)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new GradleException(HelpfulSuggestions.forIncompatibleBaseImageJavaVersionForGradle(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Throwable)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new GradleException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Throwable)ex);
        }
        finally {
            tempDirectoryProvider.close();
            TaskCommon.finishUpdateChecker(projectProperties, updateCheckFuture);
            projectProperties.waitForLoggingThread();
        }
    }

    @Override
    public BuildTarTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

