/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ConfigurationPropertyValidator {
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(?<name>[^=]+)=(?<value>.*)");

    public static Optional<Credential> getImageCredential(Consumer<LogEvent> logger, String usernameProperty, String passwordProperty, AuthProperty auth, RawConfiguration rawConfiguration) {
        String commandlineUsername = rawConfiguration.getProperty(usernameProperty).orElse("");
        String commandlinePassword = rawConfiguration.getProperty(passwordProperty).orElse("");
        if (!commandlineUsername.isEmpty() && !commandlinePassword.isEmpty()) {
            return Optional.of(Credential.from(commandlineUsername, commandlinePassword));
        }
        String missingProperty = "%s system property is set, but %s is not; attempting other authentication methods.";
        if (!commandlinePassword.isEmpty()) {
            logger.accept(LogEvent.warn(String.format(missingProperty, passwordProperty, usernameProperty)));
        }
        if (!commandlineUsername.isEmpty()) {
            logger.accept(LogEvent.warn(String.format(missingProperty, usernameProperty, passwordProperty)));
        }
        if (!Strings.isNullOrEmpty((String)auth.getUsername()) && !Strings.isNullOrEmpty((String)auth.getPassword())) {
            return Optional.of(Credential.from(auth.getUsername(), auth.getPassword()));
        }
        String missingConfig = "%s is missing from build configuration; ignoring auth section.";
        if (!Strings.isNullOrEmpty((String)auth.getPassword())) {
            logger.accept(LogEvent.warn(String.format(missingConfig, auth.getUsernameDescriptor())));
        }
        if (!Strings.isNullOrEmpty((String)auth.getUsername())) {
            logger.accept(LogEvent.warn(String.format(missingConfig, auth.getPasswordDescriptor())));
        }
        return Optional.empty();
    }

    public static ImageReference getGeneratedTargetDockerTag(@Nullable String targetImage, ProjectProperties projectProperties, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException {
        String generatedTag;
        String generatedName = projectProperties.getName();
        String string = generatedTag = projectProperties.getVersion().equals("unspecified") ? "latest" : projectProperties.getVersion();
        if (Strings.isNullOrEmpty((String)targetImage)) {
            projectProperties.log(LogEvent.lifecycle(helpfulSuggestions.forGeneratedTag(generatedName, generatedTag)));
            ImageReference.parse(generatedName + ":" + generatedTag);
            return ImageReference.of(null, generatedName, generatedTag);
        }
        return ImageReference.parse(targetImage);
    }

    public static Map<String, String> parseMapProperty(String property) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<String> entries = ConfigurationPropertyValidator.parseListProperty(property);
        for (String entry : entries) {
            Matcher matcher = KEY_VALUE_PATTERN.matcher(entry);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("'" + entry + "' is not a valid key-value pair");
            }
            result.put(matcher.group("name"), matcher.group("value"));
        }
        return result;
    }

    public static List<String> parseListProperty(String property) {
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        for (int endIndex = 0; endIndex < property.length(); ++endIndex) {
            if (property.charAt(endIndex) == ',') {
                items.add(property.substring(startIndex, endIndex));
                startIndex = endIndex + 1;
                continue;
            }
            if (property.charAt(endIndex) != '\\') continue;
            ++endIndex;
        }
        items.add(property.substring(startIndex));
        return items;
    }

    private ConfigurationPropertyValidator() {
    }
}

