/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.buildplan.FileEntry;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class LayerEntriesSelector {
    @VisibleForTesting
    static List<LayerEntryTemplate> toSortedJsonTemplates(List<FileEntry> layerEntries) throws IOException {
        ArrayList<LayerEntryTemplate> jsonTemplates = new ArrayList<LayerEntryTemplate>();
        for (FileEntry entry : layerEntries) {
            jsonTemplates.add(new LayerEntryTemplate(entry));
        }
        Collections.sort(jsonTemplates);
        return jsonTemplates;
    }

    static DescriptorDigest generateSelector(ImmutableList<FileEntry> layerEntries) throws IOException {
        return Digests.computeJsonDigest(LayerEntriesSelector.toSortedJsonTemplates(layerEntries));
    }

    private LayerEntriesSelector() {
    }

    @VisibleForTesting
    static class LayerEntryTemplate
    implements JsonTemplate,
    Comparable<LayerEntryTemplate> {
        private final String sourceFile;
        private final String extractionPath;
        private final Instant sourceModificationTime;
        private final Instant targetModificationTime;
        private final String permissions;
        private final String ownership;

        @VisibleForTesting
        LayerEntryTemplate(FileEntry layerEntry) throws IOException {
            this.sourceFile = layerEntry.getSourceFile().toAbsolutePath().toString();
            this.extractionPath = layerEntry.getExtractionPath().toString();
            this.sourceModificationTime = Files.getLastModifiedTime(layerEntry.getSourceFile(), new LinkOption[0]).toInstant();
            this.targetModificationTime = layerEntry.getModificationTime();
            this.permissions = layerEntry.getPermissions().toOctalString();
            this.ownership = layerEntry.getOwnership();
        }

        @Override
        public int compareTo(LayerEntryTemplate otherLayerEntryTemplate) {
            int sourceFileComparison = this.sourceFile.compareTo(otherLayerEntryTemplate.sourceFile);
            if (sourceFileComparison != 0) {
                return sourceFileComparison;
            }
            int extractionPathComparison = this.extractionPath.compareTo(otherLayerEntryTemplate.extractionPath);
            if (extractionPathComparison != 0) {
                return extractionPathComparison;
            }
            int sourceModificationTimeComparison = this.sourceModificationTime.compareTo(otherLayerEntryTemplate.sourceModificationTime);
            if (sourceModificationTimeComparison != 0) {
                return sourceModificationTimeComparison;
            }
            int targetModificationTimeComparison = this.targetModificationTime.compareTo(otherLayerEntryTemplate.targetModificationTime);
            if (targetModificationTimeComparison != 0) {
                return targetModificationTimeComparison;
            }
            int permissionsComparison = this.permissions.compareTo(otherLayerEntryTemplate.permissions);
            if (permissionsComparison != 0) {
                return permissionsComparison;
            }
            return this.ownership.compareTo(otherLayerEntryTemplate.ownership);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LayerEntryTemplate)) {
                return false;
            }
            LayerEntryTemplate otherLayerEntryTemplate = (LayerEntryTemplate)other;
            return this.sourceFile.equals(otherLayerEntryTemplate.sourceFile) && this.extractionPath.equals(otherLayerEntryTemplate.extractionPath) && this.sourceModificationTime.equals(otherLayerEntryTemplate.sourceModificationTime) && this.targetModificationTime.equals(otherLayerEntryTemplate.targetModificationTime) && this.permissions.equals(otherLayerEntryTemplate.permissions) && this.ownership.equals(otherLayerEntryTemplate.ownership);
        }

        public int hashCode() {
            return Objects.hash(this.sourceFile, this.extractionPath, this.sourceModificationTime, this.targetModificationTime, this.permissions, this.ownership);
        }
    }
}

