/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.gradle.ExtraDirectoryParameters;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GradleRawConfiguration
implements RawConfiguration {
    private final JibExtension jibExtension;

    public GradleRawConfiguration(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
    }

    @Override
    public Optional<String> getFromImage() {
        return Optional.ofNullable(this.jibExtension.getFrom().getImage());
    }

    @Override
    public AuthProperty getFromAuth() {
        return this.jibExtension.getFrom().getAuth();
    }

    @Override
    public RawConfiguration.CredHelperConfiguration getFromCredHelper() {
        return this.jibExtension.getFrom().getCredHelper();
    }

    @Override
    public Optional<String> getToImage() {
        return Optional.ofNullable(this.jibExtension.getTo().getImage());
    }

    @Override
    public AuthProperty getToAuth() {
        return this.jibExtension.getTo().getAuth();
    }

    @Override
    public RawConfiguration.CredHelperConfiguration getToCredHelper() {
        return this.jibExtension.getTo().getCredHelper();
    }

    @Override
    public Set<String> getToTags() {
        return this.jibExtension.getTo().getTags();
    }

    @Override
    public Optional<List<String>> getEntrypoint() {
        return Optional.ofNullable(this.jibExtension.getContainer().getEntrypoint());
    }

    @Override
    public Optional<List<String>> getProgramArguments() {
        return Optional.ofNullable(this.jibExtension.getContainer().getArgs());
    }

    @Override
    public List<String> getExtraClasspath() {
        return this.jibExtension.getContainer().getExtraClasspath();
    }

    @Override
    public boolean getExpandClasspathDependencies() {
        return this.jibExtension.getContainer().getExpandClasspathDependencies();
    }

    @Override
    public Optional<String> getMainClass() {
        return Optional.ofNullable(this.jibExtension.getContainer().getMainClass());
    }

    @Override
    public List<String> getJvmFlags() {
        return this.jibExtension.getContainer().getJvmFlags();
    }

    @Override
    public String getAppRoot() {
        return this.jibExtension.getContainer().getAppRoot();
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.jibExtension.getContainer().getEnvironment();
    }

    @Override
    public Map<String, String> getLabels() {
        return (Map)this.jibExtension.getContainer().getLabels().get();
    }

    @Override
    public List<String> getVolumes() {
        return this.jibExtension.getContainer().getVolumes();
    }

    @Override
    public List<String> getPorts() {
        return this.jibExtension.getContainer().getPorts();
    }

    @Override
    public Optional<String> getUser() {
        return Optional.ofNullable(this.jibExtension.getContainer().getUser());
    }

    @Override
    public Optional<String> getWorkingDirectory() {
        return Optional.ofNullable(this.jibExtension.getContainer().getWorkingDirectory());
    }

    @Override
    public boolean getAllowInsecureRegistries() {
        return this.jibExtension.getAllowInsecureRegistries();
    }

    @Override
    public ImageFormat getImageFormat() {
        return this.jibExtension.getContainer().getFormat();
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(System.getProperty(propertyName));
    }

    @Override
    public String getFilesModificationTime() {
        return this.jibExtension.getContainer().getFilesModificationTime();
    }

    @Override
    public String getCreationTime() {
        return this.jibExtension.getContainer().getCreationTime();
    }

    @Override
    public List<? extends RawConfiguration.ExtraDirectoriesConfiguration> getExtraDirectories() {
        for (ExtraDirectoryParameters path : this.jibExtension.getExtraDirectories().getPaths()) {
            if (!path.getFrom().equals(Paths.get("", new String[0]))) continue;
            throw new IllegalArgumentException("Incomplete extraDirectories.paths configuration; source directory must be set");
        }
        return this.jibExtension.getExtraDirectories().getPaths();
    }

    @Override
    public Map<String, FilePermissions> getExtraDirectoryPermissions() {
        return TaskCommon.convertPermissionsMap(this.jibExtension.getExtraDirectories().getPermissions());
    }

    @Override
    public Optional<Path> getDockerExecutable() {
        return Optional.ofNullable(this.jibExtension.getDockerClient().getExecutablePath());
    }

    @Override
    public Map<String, String> getDockerEnvironment() {
        return this.jibExtension.getDockerClient().getEnvironment();
    }

    @Override
    public String getContainerizingMode() {
        return this.jibExtension.getContainerizingMode();
    }

    @Override
    public Path getTarOutputPath() {
        return this.jibExtension.getOutputPaths().getTarPath();
    }

    @Override
    public Path getDigestOutputPath() {
        return this.jibExtension.getOutputPaths().getDigestPath();
    }

    @Override
    public Path getImageIdOutputPath() {
        return this.jibExtension.getOutputPaths().getImageIdPath();
    }

    @Override
    public Path getImageJsonOutputPath() {
        return this.jibExtension.getOutputPaths().getImageJsonPath();
    }

    @Override
    public List<? extends RawConfiguration.ExtensionConfiguration> getPluginExtensions() {
        return (List)this.jibExtension.getPluginExtensions().get();
    }

    @Override
    public List<? extends RawConfiguration.PlatformConfiguration> getPlatforms() {
        return (List)this.jibExtension.getFrom().getPlatforms().get();
    }
}

