/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.lifecycle.api;

import com.google.common.base.Optional;
import io.elasticjob.lite.lifecycle.api.JobOperateAPI;
import io.elasticjob.lite.lifecycle.api.JobSettingsAPI;
import io.elasticjob.lite.lifecycle.api.JobStatisticsAPI;
import io.elasticjob.lite.lifecycle.api.ServerStatisticsAPI;
import io.elasticjob.lite.lifecycle.api.ShardingOperateAPI;
import io.elasticjob.lite.lifecycle.api.ShardingStatisticsAPI;
import io.elasticjob.lite.lifecycle.internal.operate.JobOperateAPIImpl;
import io.elasticjob.lite.lifecycle.internal.operate.ShardingOperateAPIImpl;
import io.elasticjob.lite.lifecycle.internal.reg.RegistryCenterFactory;
import io.elasticjob.lite.lifecycle.internal.settings.JobSettingsAPIImpl;
import io.elasticjob.lite.lifecycle.internal.statistics.JobStatisticsAPIImpl;
import io.elasticjob.lite.lifecycle.internal.statistics.ServerStatisticsAPIImpl;
import io.elasticjob.lite.lifecycle.internal.statistics.ShardingStatisticsAPIImpl;

public final class JobAPIFactory {
    public static JobSettingsAPI createJobSettingsAPI(String connectString, String namespace, Optional<String> digest) {
        return new JobSettingsAPIImpl(RegistryCenterFactory.createCoordinatorRegistryCenter(connectString, namespace, digest));
    }

    public static JobOperateAPI createJobOperateAPI(String connectString, String namespace, Optional<String> digest) {
        return new JobOperateAPIImpl(RegistryCenterFactory.createCoordinatorRegistryCenter(connectString, namespace, digest));
    }

    public static ShardingOperateAPI createShardingOperateAPI(String connectString, String namespace, Optional<String> digest) {
        return new ShardingOperateAPIImpl(RegistryCenterFactory.createCoordinatorRegistryCenter(connectString, namespace, digest));
    }

    public static JobStatisticsAPI createJobStatisticsAPI(String connectString, String namespace, Optional<String> digest) {
        return new JobStatisticsAPIImpl(RegistryCenterFactory.createCoordinatorRegistryCenter(connectString, namespace, digest));
    }

    public static ServerStatisticsAPI createServerStatisticsAPI(String connectString, String namespace, Optional<String> digest) {
        return new ServerStatisticsAPIImpl(RegistryCenterFactory.createCoordinatorRegistryCenter(connectString, namespace, digest));
    }

    public static ShardingStatisticsAPI createShardingStatisticsAPI(String connectString, String namespace, Optional<String> digest) {
        return new ShardingStatisticsAPIImpl(RegistryCenterFactory.createCoordinatorRegistryCenter(connectString, namespace, digest));
    }

    private JobAPIFactory() {
    }
}

