/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.lifecycle.internal.operate;

import io.elasticjob.lite.internal.storage.JobNodePath;
import io.elasticjob.lite.lifecycle.api.ShardingOperateAPI;
import io.elasticjob.lite.reg.base.CoordinatorRegistryCenter;

public final class ShardingOperateAPIImpl
implements ShardingOperateAPI {
    private final CoordinatorRegistryCenter regCenter;

    public ShardingOperateAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }

    @Override
    public void disable(String jobName, String item) {
        this.disableOrEnableJobs(jobName, item, true);
    }

    @Override
    public void enable(String jobName, String item) {
        this.disableOrEnableJobs(jobName, item, false);
    }

    private void disableOrEnableJobs(String jobName, String item, boolean disabled) {
        JobNodePath jobNodePath = new JobNodePath(jobName);
        String shardingDisabledNodePath = jobNodePath.getShardingNodePath(item, "disabled");
        if (disabled) {
            this.regCenter.persist(shardingDisabledNodePath, "");
        } else {
            this.regCenter.remove(shardingDisabledNodePath);
        }
    }
}

