/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.lifecycle.internal.reg;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.elasticjob.lite.reg.base.CoordinatorRegistryCenter;
import io.elasticjob.lite.reg.zookeeper.ZookeeperConfiguration;
import io.elasticjob.lite.reg.zookeeper.ZookeeperRegistryCenter;
import java.util.concurrent.ConcurrentHashMap;

public final class RegistryCenterFactory {
    private static final ConcurrentHashMap<HashCode, CoordinatorRegistryCenter> REG_CENTER_REGISTRY = new ConcurrentHashMap();

    public static CoordinatorRegistryCenter createCoordinatorRegistryCenter(String connectString, String namespace, Optional<String> digest) {
        HashCode hashCode;
        CoordinatorRegistryCenter result;
        Hasher hasher = Hashing.md5().newHasher().putString((CharSequence)connectString, Charsets.UTF_8).putString((CharSequence)namespace, Charsets.UTF_8);
        if (digest.isPresent()) {
            hasher.putString((CharSequence)digest.get(), Charsets.UTF_8);
        }
        if (null != (result = REG_CENTER_REGISTRY.get(hashCode = hasher.hash()))) {
            return result;
        }
        ZookeeperConfiguration zkConfig = new ZookeeperConfiguration(connectString, namespace);
        if (digest.isPresent()) {
            zkConfig.setDigest((String)digest.get());
        }
        result = new ZookeeperRegistryCenter(zkConfig);
        result.init();
        REG_CENTER_REGISTRY.put(hashCode, result);
        return result;
    }

    private RegistryCenterFactory() {
    }
}

