/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.lifecycle.internal.settings;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.elasticjob.lite.api.JobType;
import io.elasticjob.lite.config.LiteJobConfiguration;
import io.elasticjob.lite.config.dataflow.DataflowJobConfiguration;
import io.elasticjob.lite.config.script.ScriptJobConfiguration;
import io.elasticjob.lite.executor.handler.JobProperties;
import io.elasticjob.lite.internal.config.LiteJobConfigurationGsonFactory;
import io.elasticjob.lite.internal.storage.JobNodePath;
import io.elasticjob.lite.lifecycle.api.JobSettingsAPI;
import io.elasticjob.lite.lifecycle.domain.JobSettings;
import io.elasticjob.lite.reg.base.CoordinatorRegistryCenter;
import java.beans.ConstructorProperties;

public final class JobSettingsAPIImpl
implements JobSettingsAPI {
    private final CoordinatorRegistryCenter regCenter;

    @Override
    public JobSettings getJobSettings(String jobName) {
        JobSettings result = new JobSettings();
        JobNodePath jobNodePath = new JobNodePath(jobName);
        LiteJobConfiguration liteJobConfig = LiteJobConfigurationGsonFactory.fromJson((String)this.regCenter.get(jobNodePath.getConfigNodePath()));
        String jobType = liteJobConfig.getTypeConfig().getJobType().name();
        this.buildSimpleJobSettings(jobName, result, liteJobConfig);
        if (JobType.DATAFLOW.name().equals(jobType)) {
            this.buildDataflowJobSettings(result, (DataflowJobConfiguration)liteJobConfig.getTypeConfig());
        }
        if (JobType.SCRIPT.name().equals(jobType)) {
            this.buildScriptJobSettings(result, (ScriptJobConfiguration)liteJobConfig.getTypeConfig());
        }
        return result;
    }

    private void buildSimpleJobSettings(String jobName, JobSettings result, LiteJobConfiguration liteJobConfig) {
        result.setJobName(jobName);
        result.setJobType(liteJobConfig.getTypeConfig().getJobType().name());
        result.setJobClass(liteJobConfig.getTypeConfig().getJobClass());
        result.setShardingTotalCount(liteJobConfig.getTypeConfig().getCoreConfig().getShardingTotalCount());
        result.setCron(liteJobConfig.getTypeConfig().getCoreConfig().getCron());
        result.setShardingItemParameters(liteJobConfig.getTypeConfig().getCoreConfig().getShardingItemParameters());
        result.setJobParameter(liteJobConfig.getTypeConfig().getCoreConfig().getJobParameter());
        result.setMonitorExecution(liteJobConfig.isMonitorExecution());
        result.setMaxTimeDiffSeconds(liteJobConfig.getMaxTimeDiffSeconds());
        result.setMonitorPort(liteJobConfig.getMonitorPort());
        result.setFailover(liteJobConfig.getTypeConfig().getCoreConfig().isFailover());
        result.setMisfire(liteJobConfig.getTypeConfig().getCoreConfig().isMisfire());
        result.setJobShardingStrategyClass(liteJobConfig.getJobShardingStrategyClass());
        result.setDescription(liteJobConfig.getTypeConfig().getCoreConfig().getDescription());
        result.setReconcileIntervalMinutes(liteJobConfig.getReconcileIntervalMinutes());
        result.getJobProperties().put(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER.getKey(), liteJobConfig.getTypeConfig().getCoreConfig().getJobProperties().get(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER));
        result.getJobProperties().put(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER.getKey(), liteJobConfig.getTypeConfig().getCoreConfig().getJobProperties().get(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER));
    }

    private void buildDataflowJobSettings(JobSettings result, DataflowJobConfiguration config) {
        result.setStreamingProcess(config.isStreamingProcess());
    }

    private void buildScriptJobSettings(JobSettings result, ScriptJobConfiguration config) {
        result.setScriptCommandLine(config.getScriptCommandLine());
    }

    @Override
    public void updateJobSettings(JobSettings jobSettings) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobSettings.getJobName()) ? 1 : 0) != 0, (Object)"jobName can not be empty.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobSettings.getCron()) ? 1 : 0) != 0, (Object)"cron can not be empty.");
        Preconditions.checkArgument((jobSettings.getShardingTotalCount() > 0 ? 1 : 0) != 0, (Object)"shardingTotalCount should larger than zero.");
        JobNodePath jobNodePath = new JobNodePath(jobSettings.getJobName());
        this.regCenter.update(jobNodePath.getConfigNodePath(), LiteJobConfigurationGsonFactory.toJsonForObject((Object)jobSettings));
    }

    @Override
    public void removeJobSettings(String jobName) {
        this.regCenter.remove("/" + jobName);
    }

    @ConstructorProperties(value={"regCenter"})
    public JobSettingsAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }
}

